/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.signatory.internal.gnupg;

import org.gradle.api.Project;
import org.gradle.plugins.signing.signatory.internal.gnupg.GnupgSettings;
import org.gradle.plugins.signing.signatory.internal.gnupg.GnupgSignatory;

public class GnupgSignatoryFactory {
    public GnupgSignatory createSignatory(Project project) {
        return this.createSignatory(project, "default");
    }

    public GnupgSignatory createSignatory(Project project, String name) {
        return this.createSignatory(project, name, "");
    }

    public GnupgSignatory createSignatory(Project project, String name, String propertyPrefix) {
        return new GnupgSignatory(project, name, this.readSettings(project, propertyPrefix));
    }

    private GnupgSettings readSettings(Project project, String propertyPrefix) {
        Object executable = project.findProperty(this.buildQualifiedProperty(propertyPrefix, "executable"));
        Object useLegacyGpg = project.findProperty(this.buildQualifiedProperty(propertyPrefix, "useLegacyGpg"));
        Object homeDir = project.findProperty(this.buildQualifiedProperty(propertyPrefix, "homeDir"));
        Object optionsFile = project.findProperty(this.buildQualifiedProperty(propertyPrefix, "optionsFile"));
        Object keyName = project.findProperty(this.buildQualifiedProperty(propertyPrefix, "keyName"));
        Object passphrase = project.findProperty(this.buildQualifiedProperty(propertyPrefix, "passphrase"));
        GnupgSettings settings = new GnupgSettings();
        if (executable != null) {
            settings.setExecutable(executable.toString());
        }
        if (useLegacyGpg != null) {
            settings.setUseLegacyGpg(Boolean.parseBoolean(useLegacyGpg.toString()));
        }
        if (homeDir != null) {
            settings.setHomeDir(project.file(homeDir.toString()));
        }
        if (optionsFile != null) {
            settings.setOptionsFile(project.file(optionsFile.toString()));
        }
        if (keyName != null) {
            settings.setKeyName(keyName.toString());
        }
        if (passphrase != null) {
            settings.setPassphrase(passphrase.toString());
        }
        return settings;
    }

    private String buildQualifiedProperty(String propertyPrefix, String property) {
        return "signing.gnupg." + propertyPrefix + (propertyPrefix.isEmpty() ? "" : ".") + property;
    }
}

