/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.jshint;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.plugins.javascript.base.JavaScriptExtension;
import org.gradle.plugins.javascript.jshint.JsHint;
import org.gradle.plugins.javascript.jshint.JsHintExtension;
import org.gradle.plugins.javascript.rhino.RhinoExtension;
import org.gradle.plugins.javascript.rhino.RhinoPlugin;
import org.gradle.util.DeprecationLogger;

public class JsHintPlugin
implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        DeprecationLogger.nagUserOfDeprecatedPlugin("org.gradle.jshint");
        project.getPluginManager().apply(RhinoPlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        JavaScriptExtension jsExtension = project.getExtensions().getByType(JavaScriptExtension.class);
        final JsHintExtension jsHintExtension = ((ExtensionAware)((Object)jsExtension)).getExtensions().create("jsHint", JsHintExtension.class, new Object[0]);
        final Configuration configuration = this.addConfiguration(project.getConfigurations(), project.getDependencies(), jsHintExtension);
        ConventionMapping conventionMapping = ((IConventionAware)((Object)jsHintExtension)).getConventionMapping();
        conventionMapping.map("js", new Callable<Configuration>(){

            @Override
            public Configuration call() {
                return configuration;
            }
        });
        conventionMapping.map("version", new Callable<String>(){

            @Override
            public String call() {
                return "r07";
            }
        });
        final RhinoExtension rhinoExtension = ((ExtensionAware)((Object)jsExtension)).getExtensions().getByType(RhinoExtension.class);
        final ReportingExtension reportingExtension = project.getExtensions().getByType(ReportingExtension.class);
        project.getTasks().withType(JsHint.class, new Action<JsHint>(){

            @Override
            public void execute(final JsHint task) {
                task.getConventionMapping().map("rhinoClasspath", new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() {
                        return rhinoExtension.getClasspath();
                    }
                });
                task.getConventionMapping().map("jsHint", new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() {
                        return jsHintExtension.getJs();
                    }
                });
                task.getConventionMapping().map("jsonReport", new Callable<File>(){

                    @Override
                    public File call() {
                        return reportingExtension.file(task.getName() + "/report.json");
                    }
                });
            }
        });
    }

    public Configuration addConfiguration(ConfigurationContainer configurations, final DependencyHandler dependencies, final JsHintExtension extension) {
        Configuration configuration = (Configuration)configurations.create("jsHintPlugin");
        configuration.defaultDependencies((Action<? super DependencySet>)new Action<DependencySet>(){

            @Override
            public void execute(DependencySet configDependencies) {
                String notation = "com.jshint:jshint:" + extension.getVersion() + "@js";
                Dependency dependency = dependencies.create(notation);
                configDependencies.add(dependency);
            }
        });
        return configuration;
    }
}

