/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Factory;
import org.gradle.plugin.use.internal.PluginRepositoriesProvider;
import org.gradle.plugin.use.internal.PluginRepositoryHandlerProvider;

public class PluginDependencyResolutionServices
implements DependencyResolutionServices {
    private static final String REPOSITORY_NAME_PREFIX = "__plugin_repository__";
    private final Factory<DependencyResolutionServices> factory;
    private DependencyResolutionServices dependencyResolutionServices;

    public PluginDependencyResolutionServices(Factory<DependencyResolutionServices> factory) {
        this.factory = factory;
    }

    private DependencyResolutionServices getDependencyResolutionServices() {
        if (this.dependencyResolutionServices == null) {
            this.dependencyResolutionServices = this.factory.create();
        }
        return this.dependencyResolutionServices;
    }

    @Override
    public RepositoryHandler getResolveRepositoryHandler() {
        return this.getDependencyResolutionServices().getResolveRepositoryHandler();
    }

    @Override
    public ConfigurationContainer getConfigurationContainer() {
        return this.getDependencyResolutionServices().getConfigurationContainer();
    }

    @Override
    public DependencyHandler getDependencyHandler() {
        return this.getDependencyResolutionServices().getDependencyHandler();
    }

    @Override
    public DependencyLockingHandler getDependencyLockingHandler() {
        return this.getDependencyResolutionServices().getDependencyLockingHandler();
    }

    @Override
    public ImmutableAttributesFactory getAttributesFactory() {
        return this.getDependencyResolutionServices().getAttributesFactory();
    }

    @Override
    public AttributesSchema getAttributesSchema() {
        return this.getDependencyResolutionServices().getAttributesSchema();
    }

    public PluginRepositoryHandlerProvider getPluginRepositoryHandlerProvider() {
        return new PluginRepositoryHandlerProvider(){

            @Override
            public RepositoryHandler getPluginRepositoryHandler() {
                return PluginDependencyResolutionServices.this.getResolveRepositoryHandler();
            }
        };
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.getDependencyResolutionServices().getObjectFactory();
    }

    public PluginRepositoriesProvider getPluginRepositoriesProvider() {
        return new PluginRepositoriesProvider(){

            @Override
            public List<ArtifactRepository> getPluginRepositories() {
                RepositoryHandler repositories = PluginDependencyResolutionServices.this.getResolveRepositoryHandler();
                ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>(repositories.size());
                for (ArtifactRepository repository : repositories) {
                    list.add(new PluginArtifactRepository(repository));
                }
                return list;
            }
        };
    }

    private static class PluginArtifactRepository
    implements ArtifactRepositoryInternal,
    ResolutionAwareRepository {
        private final ArtifactRepositoryInternal delegate;
        private final ResolutionAwareRepository resolutionAwareDelegate;

        private PluginArtifactRepository(ArtifactRepository delegate) {
            this.delegate = (ArtifactRepositoryInternal)delegate;
            this.resolutionAwareDelegate = (ResolutionAwareRepository)((Object)delegate);
        }

        @Override
        public String getName() {
            return PluginDependencyResolutionServices.REPOSITORY_NAME_PREFIX + this.delegate.getName();
        }

        @Override
        public void setName(String name) {
            this.delegate.setName(name);
        }

        @Override
        public void content(Action<? super RepositoryContentDescriptor> configureAction) {
            this.delegate.content(configureAction);
        }

        @Override
        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        @Override
        public ConfiguredModuleComponentRepository createResolver() {
            return this.resolutionAwareDelegate.createResolver();
        }

        @Override
        public RepositoryDescriptor getDescriptor() {
            return this.resolutionAwareDelegate.getDescriptor();
        }

        @Override
        public void onAddToContainer(NamedDomainObjectCollection<ArtifactRepository> container) {
            this.delegate.onAddToContainer(container);
        }
    }
}

