/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

@Incubating
@Deprecated
public class PlayPluginConfigurations {
    public static final String PLATFORM_CONFIGURATION = "playPlatform";
    public static final String COMPILE_CONFIGURATION = "play";
    public static final String RUN_CONFIGURATION = "playRun";
    public static final String TEST_COMPILE_CONFIGURATION = "playTest";
    private final ConfigurationContainer configurations;
    private final DependencyHandler dependencyHandler;

    public PlayPluginConfigurations(ConfigurationContainer configurations, DependencyHandler dependencyHandler) {
        this.configurations = configurations;
        this.dependencyHandler = dependencyHandler;
        Configuration playPlatform = (Configuration)configurations.create(PLATFORM_CONFIGURATION);
        Configuration playCompile = (Configuration)configurations.create(COMPILE_CONFIGURATION);
        playCompile.extendsFrom(playPlatform);
        Configuration playRun = (Configuration)configurations.create(RUN_CONFIGURATION);
        playRun.extendsFrom(playCompile);
        Configuration playTestCompile = (Configuration)configurations.create(TEST_COMPILE_CONFIGURATION);
        playTestCompile.extendsFrom(playCompile);
        ((Configuration)configurations.maybeCreate("default")).extendsFrom(playCompile);
    }

    public PlayConfiguration getPlayPlatform() {
        return new PlayConfiguration(PLATFORM_CONFIGURATION);
    }

    public PlayConfiguration getPlay() {
        return new PlayConfiguration(COMPILE_CONFIGURATION);
    }

    public PlayConfiguration getPlayRun() {
        return new PlayConfiguration(RUN_CONFIGURATION);
    }

    public PlayConfiguration getPlayTest() {
        return new PlayConfiguration(TEST_COMPILE_CONFIGURATION);
    }

    private static class FilterByProjectComponentTypeFileCollection
    extends LazilyInitializedFileCollection {
        private final Configuration configuration;
        private final boolean matchProjectComponents;

        private FilterByProjectComponentTypeFileCollection(Configuration configuration, boolean matchProjectComponents) {
            this.configuration = configuration;
            this.matchProjectComponents = matchProjectComponents;
        }

        @Override
        public String getDisplayName() {
            return this.configuration.toString();
        }

        @Override
        public FileCollectionInternal createDelegate() {
            ImmutableSet.Builder files = ImmutableSet.builder();
            for (ResolvedArtifact artifact : this.configuration.getResolvedConfiguration().getResolvedArtifacts()) {
                if (artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier != this.matchProjectComponents) continue;
                files.add((Object)artifact.getFile());
            }
            return ImmutableFileCollection.of((Iterable<? extends File>)files.build());
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.configuration);
        }
    }

    class PlayConfiguration {
        private final String name;

        PlayConfiguration(String name) {
            this.name = name;
        }

        Configuration getConfiguration() {
            return PlayPluginConfigurations.this.configurations.getByName(this.name);
        }

        FileCollection getAllArtifacts() {
            return this.getConfiguration();
        }

        FileCollection getChangingArtifacts() {
            return new FilterByProjectComponentTypeFileCollection(this.getConfiguration(), true);
        }

        FileCollection getNonChangingArtifacts() {
            return new FilterByProjectComponentTypeFileCollection(this.getConfiguration(), false);
        }

        void addDependency(Object notation) {
            PlayPluginConfigurations.this.dependencyHandler.add(this.name, notation);
        }

        void addArtifact(PublishArtifact artifact) {
            PlayPluginConfigurations.this.configurations.getByName(this.name).getArtifacts().add(artifact);
        }
    }
}

