/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Transformer;
import org.gradle.internal.MutableReference;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.work.ConditionalExecution;
import org.gradle.internal.work.ConditionalExecutionQueue;

public class DefaultConditionalExecutionQueue<T>
implements ConditionalExecutionQueue<T> {
    public static final int KEEP_ALIVE_TIME_MS = 2000;
    private final int maxWorkers;
    private final ResourceLockCoordinationService coordinationService;
    private final ManagedExecutor executor;
    private final Deque<ConditionalExecution<T>> queue = Lists.newLinkedList();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition workAvailable = this.lock.newCondition();
    private QueueState queueState = QueueState.Working;
    private volatile int workerCount;

    public DefaultConditionalExecutionQueue(String displayName, int maxWorkers, ExecutorFactory executorFactory, ResourceLockCoordinationService coordinationService) {
        this.maxWorkers = maxWorkers;
        this.executor = executorFactory.create(displayName);
        this.coordinationService = coordinationService;
        this.executor.setKeepAlive(2000, TimeUnit.MILLISECONDS);
    }

    @Override
    public void submit(ConditionalExecution<T> execution) {
        if (this.queueState == QueueState.Stopped) {
            throw new IllegalStateException("DefaultConditionalExecutionQueue cannot be reused once it has been stopped.");
        }
        this.lock.lock();
        try {
            if (this.workerCount < this.maxWorkers) {
                this.expand(true);
            }
            this.queue.add(execution);
            this.workAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void expand() {
        this.expand(false);
    }

    private void expand(boolean force) {
        this.lock.lock();
        try {
            if (force || !this.queue.isEmpty()) {
                this.executor.submit(new ExecutionRunner());
                ++this.workerCount;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.queueState = QueueState.Stopped;
            this.workAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.executor.stop();
    }

    private class ExecutionRunner
    implements Runnable {
        private ExecutionRunner() {
        }

        @Override
        public void run() {
            try {
                ConditionalExecution operation;
                while ((operation = this.waitForNextOperation()) != null) {
                    this.runBatch(operation);
                }
            }
            finally {
                this.shutDown();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ConditionalExecution waitForNextOperation() {
            DefaultConditionalExecutionQueue.this.lock.lock();
            try {
                while (DefaultConditionalExecutionQueue.this.queueState == QueueState.Working && DefaultConditionalExecutionQueue.this.queue.isEmpty() && DefaultConditionalExecutionQueue.this.workerCount <= DefaultConditionalExecutionQueue.this.maxWorkers) {
                    try {
                        DefaultConditionalExecutionQueue.this.workAvailable.await();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException(e);
                        return this.getReadyExecution();
                    }
                }
            }
            finally {
                DefaultConditionalExecutionQueue.this.lock.unlock();
            }
        }

        private void runBatch(ConditionalExecution firstOperation) {
            ConditionalExecution operation = firstOperation;
            while (operation != null) {
                this.runExecution(operation);
                operation = this.getReadyExecution();
            }
        }

        private ConditionalExecution getReadyExecution() {
            final MutableReference execution = MutableReference.empty();
            DefaultConditionalExecutionQueue.this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                    if (DefaultConditionalExecutionQueue.this.queue.isEmpty()) {
                        return ResourceLockState.Disposition.FINISHED;
                    }
                    DefaultConditionalExecutionQueue.this.lock.lock();
                    try {
                        Iterator itr = DefaultConditionalExecutionQueue.this.queue.iterator();
                        while (itr.hasNext()) {
                            ConditionalExecution next = (ConditionalExecution)itr.next();
                            if (!next.getResourceLock().tryLock()) continue;
                            execution.set(next);
                            itr.remove();
                            break;
                        }
                    }
                    finally {
                        DefaultConditionalExecutionQueue.this.lock.unlock();
                    }
                    if (execution.get() == null && !DefaultConditionalExecutionQueue.this.queue.isEmpty()) {
                        return ResourceLockState.Disposition.RETRY;
                    }
                    return ResourceLockState.Disposition.FINISHED;
                }
            });
            return (ConditionalExecution)execution.get();
        }

        private void runExecution(ConditionalExecution execution) {
            try {
                execution.getExecution().run();
            }
            catch (Throwable throwable) {
                DefaultConditionalExecutionQueue.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(execution.getResourceLock()));
                execution.complete();
                throw throwable;
            }
            DefaultConditionalExecutionQueue.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(execution.getResourceLock()));
            execution.complete();
        }

        private void shutDown() {
            DefaultConditionalExecutionQueue.this.lock.lock();
            try {
                DefaultConditionalExecutionQueue.this.workerCount--;
            }
            finally {
                DefaultConditionalExecutionQueue.this.lock.unlock();
            }
        }
    }

    private static enum QueueState {
        Working,
        Stopped;

    }
}

