/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.util.Optional;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.VfsRelativePath;
import org.gradle.internal.vfs.impl.SnapshotHierarchy;

public class DefaultSnapshotHierarchy
implements SnapshotHierarchy {
    @VisibleForTesting
    final FileSystemNode rootNode;
    private final CaseSensitivity caseSensitivity;

    public static SnapshotHierarchy from(String absolutePath, MetadataSnapshot snapshot, CaseSensitivity caseSensitivity) {
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        return new DefaultSnapshotHierarchy(snapshot.asFileSystemNode(relativePath.getAsString()), caseSensitivity);
    }

    private DefaultSnapshotHierarchy(FileSystemNode rootNode, CaseSensitivity caseSensitivity) {
        this.rootNode = rootNode;
        this.caseSensitivity = caseSensitivity;
    }

    public static SnapshotHierarchy empty(CaseSensitivity caseSensitivity) {
        switch (caseSensitivity) {
            case CASE_SENSITIVE: {
                return EmptySnapshotHierarchy.CASE_SENSITIVE;
            }
            case CASE_INSENSITIVE: {
                return EmptySnapshotHierarchy.CASE_INSENSITIVE;
            }
        }
        throw new AssertionError((Object)("Unknown case sensitivity: " + (Object)((Object)caseSensitivity)));
    }

    @Override
    public Optional<MetadataSnapshot> getMetadata(String absolutePath) {
        String pathToParent;
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        if (!relativePath.hasPrefix(pathToParent = this.rootNode.getPathToParent(), this.caseSensitivity)) {
            return Optional.empty();
        }
        return SnapshotUtil.getSnapshotFromChild(this.rootNode, relativePath, this.caseSensitivity);
    }

    @Override
    public SnapshotHierarchy store(String absolutePath, MetadataSnapshot snapshot) {
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        return new DefaultSnapshotHierarchy(SnapshotUtil.storeSingleChild(this.rootNode, relativePath, this.caseSensitivity, snapshot), this.caseSensitivity);
    }

    @Override
    public SnapshotHierarchy invalidate(String absolutePath) {
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        return SnapshotUtil.invalidateSingleChild(this.rootNode, relativePath, this.caseSensitivity).map(newRootNode -> new DefaultSnapshotHierarchy((FileSystemNode)newRootNode, this.caseSensitivity)).orElse(this.empty());
    }

    @Override
    public SnapshotHierarchy empty() {
        return DefaultSnapshotHierarchy.empty(this.caseSensitivity);
    }

    @Override
    public void visitSnapshots(SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
        this.rootNode.accept(node -> node.getSnapshot().ifPresent(snapshot -> {
            if (snapshot instanceof CompleteFileSystemLocationSnapshot) {
                snapshotVisitor.visitSnapshot((CompleteFileSystemLocationSnapshot)snapshot);
            }
        }));
    }

    private static enum EmptySnapshotHierarchy implements SnapshotHierarchy
    {
        CASE_SENSITIVE(CaseSensitivity.CASE_SENSITIVE),
        CASE_INSENSITIVE(CaseSensitivity.CASE_INSENSITIVE);

        private final CaseSensitivity caseSensitivity;

        private EmptySnapshotHierarchy(CaseSensitivity caseInsensitive) {
            this.caseSensitivity = caseInsensitive;
        }

        @Override
        public Optional<MetadataSnapshot> getMetadata(String absolutePath) {
            return Optional.empty();
        }

        @Override
        public SnapshotHierarchy store(String absolutePath, MetadataSnapshot snapshot) {
            return DefaultSnapshotHierarchy.from(absolutePath, snapshot, this.caseSensitivity);
        }

        @Override
        public SnapshotHierarchy invalidate(String absolutePath) {
            return this;
        }

        @Override
        public SnapshotHierarchy empty() {
            return this;
        }

        @Override
        public void visitSnapshots(SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
        }
    }
}

