/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class LockFileReaderWriter {
    private static final Logger LOGGER = Logging.getLogger(LockFileReaderWriter.class);
    private static final DocumentationRegistry DOC_REG = new DocumentationRegistry();
    static final String FILE_SUFFIX = ".lockfile";
    static final String DEPENDENCY_LOCKING_FOLDER = "gradle/dependency-locks";
    static final Charset CHARSET = Charset.forName("UTF-8");
    static final String LOCKFILE_HEADER = "# This is a Gradle generated file for dependency locking.\n# Manual edits can break the build and are not advised.\n# This file is expected to be part of source control.\n";
    private final Path lockFilesRoot;
    private final DomainObjectContext context;

    public LockFileReaderWriter(FileResolver fileResolver, DomainObjectContext context) {
        this.context = context;
        Path resolve = null;
        if (fileResolver.canResolveRelativePath()) {
            resolve = fileResolver.resolve(DEPENDENCY_LOCKING_FOLDER).toPath();
        }
        this.lockFilesRoot = resolve;
        LOGGER.debug("Lockfiles root: {}", this.lockFilesRoot);
    }

    public void writeLockFile(String configurationName, List<String> resolvedModules) {
        this.checkValidRoot(configurationName);
        if (!Files.exists(this.lockFilesRoot, new LinkOption[0])) {
            try {
                Files.createDirectories(this.lockFilesRoot, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Issue creating dependency-lock directory", e);
            }
        }
        StringBuilder builder = new StringBuilder(LOCKFILE_HEADER);
        for (String module : resolvedModules) {
            builder.append(module).append("\n");
        }
        try {
            Files.write(this.lockFilesRoot.resolve(this.decorate(configurationName) + FILE_SUFFIX), builder.toString().getBytes(CHARSET), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write lock file", e);
        }
    }

    public List<String> readLockFile(String configurationName) {
        this.checkValidRoot(configurationName);
        try {
            Path lockFile = this.lockFilesRoot.resolve(this.decorate(configurationName) + FILE_SUFFIX);
            if (Files.exists(lockFile, new LinkOption[0])) {
                List<String> lines = Files.readAllLines(lockFile, CHARSET);
                this.filterNonModuleLines(lines);
                return lines;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load lock file", e);
        }
    }

    private String decorate(String configurationName) {
        if (this.context.isScript()) {
            return "buildscript-" + configurationName;
        }
        return configurationName;
    }

    private void checkValidRoot(String configurationName) {
        if (this.lockFilesRoot == null) {
            throw new IllegalStateException("Dependency locking cannot be used for configuration '" + this.context.identityPath(configurationName) + "'. See limitations in the documentation (" + DOC_REG.getDocumentationFor("dependency_locking", "locking_limitations") + ").");
        }
    }

    private void filterNonModuleLines(List<String> lines) {
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String value = iterator.next().trim();
            if (!value.startsWith("#") && !value.isEmpty()) continue;
            iterator.remove();
        }
    }
}

