/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import java.util.Optional;
import java.util.SortedMap;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryCacheAccess;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.impl.DefaultAfterPreviousExecutionState;
import org.gradle.internal.execution.history.impl.DefaultPreviousExecutionStateSerializer;
import org.gradle.internal.execution.history.impl.FileCollectionFingerprintSerializer;
import org.gradle.internal.execution.history.impl.SerializableFileCollectionFingerprint;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class DefaultExecutionHistoryStore
implements ExecutionHistoryStore {
    private final PersistentIndexedCache<String, AfterPreviousExecutionState> store;

    public DefaultExecutionHistoryStore(ExecutionHistoryCacheAccess executionHistoryCacheAccess, StringInterner stringInterner) {
        DefaultPreviousExecutionStateSerializer serializer = new DefaultPreviousExecutionStateSerializer(new FileCollectionFingerprintSerializer(stringInterner));
        this.store = executionHistoryCacheAccess.createCache(PersistentIndexedCacheParameters.of("executionHistory", String.class, serializer), 10000, false);
    }

    @Override
    public Optional<AfterPreviousExecutionState> load(String key) {
        return Optional.ofNullable(this.store.get(key));
    }

    @Override
    public void store(String key, OriginMetadata originMetadata, ImplementationSnapshot implementation, ImmutableList<ImplementationSnapshot> additionalImplementations, ImmutableSortedMap<String, ValueSnapshot> inputProperties, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFileProperties, boolean successful) {
        this.store.put(key, new DefaultAfterPreviousExecutionState(originMetadata, implementation, additionalImplementations, inputProperties, DefaultExecutionHistoryStore.prepareForSerialization(inputFileProperties), DefaultExecutionHistoryStore.prepareForSerialization(outputFileProperties), successful));
    }

    @Override
    public void remove(String key) {
        this.store.remove(key);
    }

    private static ImmutableSortedMap<String, FileCollectionFingerprint> prepareForSerialization(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprints) {
        return ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformValues(fingerprints, value -> new SerializableFileCollectionFingerprint(value.getFingerprints(), value.getRootHashes())));
    }
}

