/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.List;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.external.model.ShadowedCapability;
import org.gradle.internal.component.external.model.ShadowedCapabilityOnly;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class ImmutableCapabilities
implements CapabilitiesMetadata {
    public static final ImmutableCapabilities EMPTY = new ImmutableCapabilities((ImmutableList<? extends Capability>)ImmutableList.of());
    private final ImmutableList<? extends Capability> capabilities;

    public static ImmutableCapabilities of(CapabilitiesMetadata capabilities) {
        if (capabilities instanceof ImmutableCapabilities) {
            return (ImmutableCapabilities)capabilities;
        }
        return ImmutableCapabilities.of(capabilities.getCapabilities());
    }

    public static ImmutableCapabilities of(List<? extends Capability> capabilities) {
        Capability single;
        if (capabilities.isEmpty()) {
            return EMPTY;
        }
        if (capabilities.size() == 1 && (single = capabilities.get(0)) instanceof ShadowedCapability) {
            return new ShadowedSingleImmutableCapabilities(single);
        }
        return new ImmutableCapabilities((ImmutableList<? extends Capability>)ImmutableList.copyOf(capabilities));
    }

    public ImmutableCapabilities(ImmutableList<? extends Capability> capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public List<? extends Capability> getCapabilities() {
        return this.capabilities;
    }

    private static class ShadowedSingleImmutableCapabilities
    extends ImmutableCapabilities
    implements ShadowedCapabilityOnly {
        public ShadowedSingleImmutableCapabilities(Capability single) {
            super((ImmutableList<? extends Capability>)ImmutableList.of((Object)single));
        }
    }
}

