/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.Closeable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import org.gradle.api.Transformer;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.ClasspathTransformerCacheFactory;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.JarCache;
import org.gradle.internal.resource.local.FileAccessTracker;
import org.gradle.internal.vfs.AdditiveCacheLocations;
import org.gradle.util.CollectionUtils;

public class DefaultCachedClasspathTransformer
implements CachedClasspathTransformer,
Closeable {
    private final PersistentCache cache;
    private final Transformer<File, File> jarFileTransformer;

    public DefaultCachedClasspathTransformer(CacheRepository cacheRepository, ClasspathTransformerCacheFactory classpathTransformerCacheFactory, FileAccessTimeJournal fileAccessTimeJournal, JarCache jarCache, AdditiveCacheLocations additiveCacheLocations) {
        this.cache = classpathTransformerCacheFactory.createCache(cacheRepository, fileAccessTimeJournal);
        FileAccessTracker fileAccessTracker = classpathTransformerCacheFactory.createFileAccessTracker(fileAccessTimeJournal);
        this.jarFileTransformer = new FileAccessTrackingJarFileTransformer(new CachedJarFileTransformer(jarCache, additiveCacheLocations), fileAccessTracker);
    }

    @Override
    public ClassPath transform(ClassPath classPath) {
        return DefaultClassPath.of(CollectionUtils.collect(classPath.getAsFiles(), this.jarFileTransformer));
    }

    @Override
    public Collection<URL> transform(Collection<URL> urls) {
        return CollectionUtils.collect(urls, url -> {
            if (url.getProtocol().equals("file")) {
                try {
                    return this.jarFileTransformer.transform(new File(url.toURI())).toURI().toURL();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            return url;
        });
    }

    @Override
    public void close() {
        this.cache.close();
    }

    private static class FileAccessTrackingJarFileTransformer
    implements Transformer<File, File> {
        private final Transformer<File, File> delegate;
        private final FileAccessTracker fileAccessTracker;

        FileAccessTrackingJarFileTransformer(Transformer<File, File> delegate, FileAccessTracker fileAccessTracker) {
            this.delegate = delegate;
            this.fileAccessTracker = fileAccessTracker;
        }

        @Override
        public File transform(File file) {
            File result = this.delegate.transform(file);
            this.fileAccessTracker.markAccessed(result);
            return result;
        }
    }

    private class CachedJarFileTransformer
    implements Transformer<File, File> {
        private final JarCache jarCache;
        private final AdditiveCacheLocations additiveCacheLocations;

        CachedJarFileTransformer(JarCache jarCache, AdditiveCacheLocations additiveCacheLocations) {
            this.jarCache = jarCache;
            this.additiveCacheLocations = additiveCacheLocations;
        }

        @Override
        public File transform(File original) {
            if (this.shouldUseFromCache(original)) {
                return DefaultCachedClasspathTransformer.this.cache.useCache(() -> this.jarCache.getCachedJar(original, DefaultCachedClasspathTransformer.this.cache.getBaseDir()));
            }
            return original;
        }

        private boolean shouldUseFromCache(File original) {
            if (!original.isFile()) {
                return false;
            }
            String absolutePath = original.getAbsolutePath();
            return !this.additiveCacheLocations.isInsideAdditiveCache(absolutePath);
        }
    }
}

