/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.plugins;

import org.gradle.api.Incubating;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.ide.visualstudio.VisualStudioExtension;
import org.gradle.ide.visualstudio.internal.NativeSpecVisualStudioTargetBinary;
import org.gradle.ide.visualstudio.internal.VisualStudioExtensionInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.platform.base.BinaryContainer;

@Incubating
class VisualStudioPluginRules {
    VisualStudioPluginRules() {
    }

    static class VisualStudioPluginProjectRules
    extends RuleSource {
        VisualStudioPluginProjectRules() {
        }

        @Mutate
        public static void createVisualStudioModelForBinaries(VisualStudioExtensionInternal visualStudioExtension, BinaryContainer binaries) {
            for (NativeBinarySpec binary : binaries.withType(NativeBinarySpec.class)) {
                if (!binary.isBuildable()) continue;
                visualStudioExtension.getProjectRegistry().addProjectConfiguration(new NativeSpecVisualStudioTargetBinary(binary));
            }
        }

        @Mutate
        public static void realizeExtension(TaskContainer tasks, VisualStudioExtensionInternal visualStudioExtension) {
        }
    }

    static class VisualStudioPluginRootRules
    extends RuleSource {
        VisualStudioPluginRootRules() {
        }

        @Mutate
        public static void ensureSubprojectsAreRealized(TaskContainer tasks, ProjectIdentifier projectIdentifier, ServiceRegistry serviceRegistry) {
            ProjectModelResolver projectModelResolver = serviceRegistry.get(ProjectModelResolver.class);
            ProjectRegistry projectRegistry = (ProjectRegistry)Cast.uncheckedCast(serviceRegistry.get(ProjectRegistry.class));
            for (ProjectInternal subproject : projectRegistry.getSubProjects(projectIdentifier.getPath())) {
                projectModelResolver.resolveProjectModel(subproject.getPath()).find("visualStudio", VisualStudioExtension.class);
            }
        }
    }

    static class VisualStudioExtensionRules
    extends RuleSource {
        VisualStudioExtensionRules() {
        }

        @Model
        public static VisualStudioExtensionInternal visualStudio(ExtensionContainer extensionContainer) {
            return (VisualStudioExtensionInternal)extensionContainer.getByType(VisualStudioExtension.class);
        }
    }
}

