/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import org.gradle.api.Transformer;
import org.gradle.cache.FileAccess;
import org.gradle.cache.FileIntegrityViolationException;
import org.gradle.cache.FileLock;
import org.gradle.cache.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.internal.Factory;

public class DefaultMultiProcessSafePersistentIndexedCache<K, V>
implements MultiProcessSafePersistentIndexedCache<K, V> {
    private final FileAccess fileAccess;
    private final Factory<BTreePersistentIndexedCache<K, V>> factory;
    private BTreePersistentIndexedCache<K, V> cache;

    public DefaultMultiProcessSafePersistentIndexedCache(Factory<BTreePersistentIndexedCache<K, V>> factory, FileAccess fileAccess) {
        this.factory = factory;
        this.fileAccess = fileAccess;
    }

    public String toString() {
        return this.fileAccess.toString();
    }

    @Override
    public V get(final K key) {
        final BTreePersistentIndexedCache<K, V> cache = this.getCache();
        try {
            return (V)this.fileAccess.readFile(new Factory<V>(){

                @Override
                public V create() {
                    return cache.get(key);
                }
            });
        }
        catch (FileIntegrityViolationException e) {
            return null;
        }
    }

    @Override
    public V get(K key, Transformer<? extends V, ? super K> producer) {
        V value = this.get(key);
        if (value == null) {
            value = producer.transform(key);
            this.put(key, value);
        }
        return value;
    }

    @Override
    public void put(final K key, final V value) {
        final BTreePersistentIndexedCache<K, V> cache = this.getCache();
        this.fileAccess.writeFile(new Runnable(){

            @Override
            public void run() {
                cache.put(key, value);
            }
        });
    }

    @Override
    public void remove(final K key) {
        final BTreePersistentIndexedCache<K, V> cache = this.getCache();
        this.fileAccess.writeFile(new Runnable(){

            @Override
            public void run() {
                cache.remove(key);
            }
        });
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
    }

    @Override
    public void finishWork() {
        if (this.cache != null) {
            try {
                this.fileAccess.writeFile(new Runnable(){

                    @Override
                    public void run() {
                        DefaultMultiProcessSafePersistentIndexedCache.this.cache.close();
                    }
                });
            }
            finally {
                this.cache = null;
            }
        }
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
    }

    private BTreePersistentIndexedCache<K, V> getCache() {
        if (this.cache == null) {
            this.fileAccess.writeFile(new Runnable(){

                @Override
                public void run() {
                    DefaultMultiProcessSafePersistentIndexedCache.this.cache = (BTreePersistentIndexedCache)DefaultMultiProcessSafePersistentIndexedCache.this.factory.create();
                }
            });
        }
        return this.cache;
    }
}

