/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Pair;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.locking.LockOutOfDateException;
import org.gradle.internal.logging.text.StyledTextOutput;

class ResolutionErrorRenderer
implements Action<Throwable> {
    private final Spec<DependencyResult> dependencySpec;
    private final List<Action<StyledTextOutput>> errorActions = Lists.newArrayListWithExpectedSize((int)1);

    public ResolutionErrorRenderer(Spec<DependencyResult> dependencySpec) {
        this.dependencySpec = dependencySpec;
    }

    @Override
    public void execute(Throwable throwable) {
        if (!(throwable instanceof ResolveException)) {
            throw UncheckedException.throwAsUncheckedException(throwable);
        }
        Throwable cause = throwable.getCause();
        this.handleResolutionError(cause);
    }

    private void handleResolutionError(Throwable cause) {
        if (cause instanceof VersionConflictException) {
            this.handleConflict((VersionConflictException)cause);
        } else if (cause instanceof LockOutOfDateException) {
            this.handleOutOfDateLocks((LockOutOfDateException)cause);
        } else {
            throw UncheckedException.throwAsUncheckedException(cause);
        }
    }

    private void handleOutOfDateLocks(final LockOutOfDateException cause) {
        this.registerError(new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput output) {
                List<String> errors = cause.getErrors();
                output.text("The dependency locks are out-of-date:");
                output.println();
                for (String error : errors) {
                    output.text("   - " + error);
                    output.println();
                }
                output.println();
            }
        });
    }

    private void handleConflict(final VersionConflictException conflict) {
        this.registerError(new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput output) {
                output.text("Dependency resolution failed because of conflict(s) on the following module(s):");
                output.println();
                for (Pair<List<? extends ModuleVersionIdentifier>, String> identifierStringPair : conflict.getConflicts()) {
                    boolean matchesSpec = ResolutionErrorRenderer.this.hasVersionConflictOnRequestedDependency(identifierStringPair.getLeft());
                    if (!matchesSpec) continue;
                    output.text("   - ");
                    output.withStyle(StyledTextOutput.Style.Error).text(identifierStringPair.getRight());
                    output.println();
                }
                output.println();
            }
        });
    }

    public void renderErrors(StyledTextOutput output) {
        for (Action<StyledTextOutput> errorAction : this.errorActions) {
            errorAction.execute(output);
        }
    }

    private void registerError(Action<StyledTextOutput> errorAction) {
        this.errorActions.add(errorAction);
    }

    private boolean hasVersionConflictOnRequestedDependency(List<? extends ModuleVersionIdentifier> versionIdentifiers) {
        for (ModuleVersionIdentifier moduleVersionIdentifier : versionIdentifiers) {
            if (!this.dependencySpec.isSatisfiedBy(this.asDependencyResult(moduleVersionIdentifier))) continue;
            return true;
        }
        return false;
    }

    private DependencyResult asDependencyResult(final ModuleVersionIdentifier versionIdentifier) {
        return new DependencyResult(){

            @Override
            public ComponentSelector getRequested() {
                return DefaultModuleComponentSelector.newSelector(versionIdentifier.getModule(), versionIdentifier.getVersion());
            }

            @Override
            public ResolvedComponentResult getFrom() {
                return null;
            }

            @Override
            public boolean isConstraint() {
                return false;
            }
        };
    }
}

