/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ProjectBackedModule;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

@Incubating
public class OutgoingVariantsReportTask
extends DefaultTask {
    private final Property<String> variantSpec = this.getProject().getObjects().property(String.class);
    private final Property<Boolean> showAll = this.getProject().getObjects().property(Boolean.class).convention(false);

    @Input
    @Optional
    @Option(option="variant", description="The variant name")
    Property<String> getVariantName() {
        return this.variantSpec;
    }

    @Input
    @Optional
    @Option(option="all", description="Shows all variants, including legacy and deprecated configurations")
    Property<Boolean> getShowAll() {
        return this.showAll;
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    void buildReport() {
        List<Configuration> configurations = this.filterConfigurations();
        StyledTextOutput output = this.getTextOutputFactory().create(this.getClass());
        if (configurations.isEmpty()) {
            this.reportNoMatchingVariant(configurations, output);
        } else {
            Legend legend = new Legend();
            configurations.forEach(cnf -> this.reportVariant((ConfigurationInternal)cnf, new ProjectBackedModule(this.getProject()), output, legend));
            legend.print(output);
        }
    }

    private void reportVariant(ConfigurationInternal cnf, ProjectBackedModule projectBackedModule, StyledTextOutput output, Legend legend) {
        cnf.preventFromFurtherMutation();
        Formatter tree = new Formatter(output);
        String name = cnf.getName();
        if (cnf.isCanBeResolved()) {
            name = name + " (l)";
            legend.hasLegacyConfigurations = true;
        }
        this.header("Variant " + name, output);
        String description = cnf.getDescription();
        if (description != null) {
            tree.value("Description", description);
            tree.println();
        }
        if (this.formatAttributesAndCapabilities(cnf, projectBackedModule, tree)) {
            tree.println();
        }
        if (this.formatArtifacts(cnf.getAllArtifacts(), tree)) {
            tree.println();
        }
        if (this.formatPublications(cnf, tree, legend)) {
            tree.println();
        }
    }

    private void header(String text, StyledTextOutput output) {
        output.style(StyledTextOutput.Style.Header).println("--------------------------------------------------").println(text).println("--------------------------------------------------").style(StyledTextOutput.Style.Normal);
    }

    private boolean formatPublications(ConfigurationInternal cnf, Formatter tree, Legend legend) {
        NamedDomainObjectContainer<ConfigurationVariant> outgoing = cnf.getOutgoing().getVariants();
        if (!outgoing.isEmpty()) {
            tree.section("Secondary variants (*)", () -> {
                outgoing.forEach(variant -> tree.section("Variant", variant.getName(), () -> {
                    this.formatAttributes(variant.getAttributes(), tree);
                    this.formatArtifacts(variant.getArtifacts(), tree);
                }));
                legend.hasPublications = true;
            });
            return true;
        }
        return false;
    }

    private boolean formatArtifacts(PublishArtifactSet artifacts, Formatter tree) {
        if (!artifacts.isEmpty()) {
            tree.section("Artifacts", () -> artifacts.stream().sorted(Comparator.comparing(Object::toString)).forEach(artifact -> this.formatArtifact((PublishArtifact)artifact, tree)));
            return true;
        }
        return false;
    }

    private void formatArtifact(PublishArtifact artifact, Formatter tree) {
        String type = artifact.getType();
        File file = artifact.getFile();
        tree.text(this.getFileResolver().resolveAsRelativePath(file));
        if (StringUtils.isNotEmpty((String)type)) {
            tree.append(" (");
            tree.appendValue("artifactType", type);
            tree.append(")");
        }
        tree.println();
    }

    private boolean formatAttributes(AttributeContainer attributes, Formatter tree) {
        if (!attributes.isEmpty()) {
            tree.section("Attributes", () -> {
                Integer max = attributes.keySet().stream().map(attr -> attr.getName().length()).max(Integer::compare).get();
                attributes.keySet().stream().sorted(Comparator.comparing(Attribute::getName)).forEach(attr -> tree.value(StringUtils.rightPad((String)attr.getName(), (int)max), String.valueOf(attributes.getAttribute(attr))));
            });
            return true;
        }
        return false;
    }

    private void formatCapabilities(Collection<? extends Capability> capabilities, ProjectBackedModule projectBackedModule, Formatter tree) {
        tree.section("Capabilities", () -> {
            if (capabilities.isEmpty()) {
                tree.text(String.format("%s:%s:%s (default capability)", projectBackedModule.getGroup(), projectBackedModule.getName(), projectBackedModule.getVersion()));
            } else {
                capabilities.forEach(cap -> tree.println(String.format("%s:%s:%s", cap.getGroup(), cap.getName(), cap.getVersion())));
            }
        });
    }

    private boolean formatAttributesAndCapabilities(ConfigurationInternal configuration, ProjectBackedModule projectBackedModule, Formatter tree) {
        AttributeContainerInternal attributes = configuration.getAttributes();
        if (!attributes.isEmpty()) {
            Collection<? extends Capability> capabilities = configuration.getOutgoing().getCapabilities();
            this.formatCapabilities(capabilities, projectBackedModule, tree);
            tree.println();
            this.formatAttributes(attributes, tree);
            return true;
        }
        return false;
    }

    private void reportNoMatchingVariant(List<Configuration> configurations, StyledTextOutput output) {
        if (this.variantSpec.isPresent()) {
            output.println("There is no variant named '" + (String)this.variantSpec.get() + "' defined on this project.");
            configurations = this.getAllConsumableConfigurations().collect(Collectors.toList());
        }
        String projectName = this.getProject().getName();
        if (configurations.isEmpty()) {
            output.println("There are no outgoing variants on project " + projectName);
        } else {
            output.println("Here are the available outgoing variants: " + configurations.stream().map(Configuration::getName).collect(Collectors.joining(", ")));
        }
    }

    private List<Configuration> filterConfigurations() {
        Stream<Configuration> configurations = this.getAllConsumableConfigurations();
        if (!((Boolean)this.showAll.get()).booleanValue() && !this.variantSpec.isPresent()) {
            configurations = configurations.filter(files -> !files.isCanBeResolved());
        }
        if (this.variantSpec.isPresent()) {
            String variantName = (String)this.variantSpec.get();
            configurations = configurations.filter(cnf -> cnf.getName().equals(variantName));
        }
        return configurations.collect(Collectors.toList());
    }

    private Stream<Configuration> getAllConsumableConfigurations() {
        return this.getProject().getConfigurations().stream().filter(Configuration::isCanBeConsumed).sorted(Comparator.comparing(Configuration::getName));
    }

    private static class Formatter {
        private final StyledTextOutput output;
        private int depth;

        private Formatter(StyledTextOutput output) {
            this.output = output;
        }

        void section(String title, Runnable action) {
            this.section(title, null, action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void section(String title, String description, Runnable action) {
            this.output.style(StyledTextOutput.Style.Description);
            this.text(title);
            this.output.style(StyledTextOutput.Style.Normal);
            if (description != null) {
                this.output.text(" : " + description);
            }
            try {
                ++this.depth;
                this.output.println();
                action.run();
            }
            finally {
                --this.depth;
            }
        }

        void value(String key, String value) {
            this.output.style(StyledTextOutput.Style.Identifier);
            this.text(key);
            this.output.style(StyledTextOutput.Style.Normal).println(" = " + value);
        }

        void append(String text) {
            this.output.text(text);
        }

        void appendValue(String key, String value) {
            this.output.style(StyledTextOutput.Style.Identifier);
            this.append(key);
            this.output.style(StyledTextOutput.Style.Normal).text(" = " + value);
        }

        void text(String text) {
            this.output.text(StringUtils.repeat((String)"   ", (int)this.depth));
            if (this.depth > 0) {
                this.output.withStyle(StyledTextOutput.Style.Normal).text(" - ");
            }
            this.output.text(text);
        }

        public void println() {
            this.output.println();
        }

        public void println(String text) {
            this.text(text);
            this.println();
        }
    }

    private static class Legend {
        private boolean hasPublications;
        private boolean hasLegacyConfigurations;

        private Legend() {
        }

        void print(StyledTextOutput output) {
            StyledTextOutput info = output.style(StyledTextOutput.Style.Info);
            if (this.hasLegacyConfigurations || this.hasPublications) {
                info.println();
            }
            if (this.hasLegacyConfigurations) {
                info.println("(l) Legacy or deprecated configuration. Those are variants created for backwards compatibility which are both resolvable and consumable.");
            }
            if (this.hasPublications) {
                info.text("(*) Secondary variants are variants created via the ").style(StyledTextOutput.Style.Identifier).text("Configuration#getOutgoing(): ConfigurationPublications").style(StyledTextOutput.Style.Info).text(" API which also participate in selection, in addition to the configuration itself.").println();
            }
        }
    }
}

