/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.JavaToolChainFactory;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CompileJavaBuildOperationReportingCompiler;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JavaRecompilationSpecProvider;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@CacheableTask
public class JavaCompile
extends AbstractCompile {
    private final CompileOptions compileOptions;
    private JavaToolChain toolChain;
    private final FileCollection stableSources = this.getProject().files(new Callable<Object[]>(){

        @Override
        public Object[] call() {
            return new Object[]{JavaCompile.this.getSource(), JavaCompile.this.getSources()};
        }
    });

    public JavaCompile() {
        CompileOptions compileOptions;
        this.compileOptions = compileOptions = this.getServices().get(ObjectFactory.class).newInstance(CompileOptions.class, new Object[0]);
        CompilerForkUtils.doNotCacheIfForkingViaExecutable(compileOptions, this.getOutputs());
    }

    @Override
    @ReplacedBy(value="stableSources")
    public FileTree getSource() {
        return super.getSource();
    }

    @Deprecated
    @Internal
    protected FileTree getSources() {
        return ImmutableFileCollection.of().getAsFileTree();
    }

    @Nested
    public JavaToolChain getToolChain() {
        if (this.toolChain != null) {
            return this.toolChain;
        }
        return this.getJavaToolChainFactory().forCompileOptions(this.getOptions());
    }

    public void setToolChain(JavaToolChain toolChain) {
        this.toolChain = toolChain;
    }

    @Deprecated
    @TaskAction
    protected void compile(IncrementalTaskInputs inputs) {
        DeprecationLogger.nagUserOfDeprecated("Extending the JavaCompile task", "Configure the task instead.");
        this.compile((InputChanges)((Object)inputs));
    }

    @Incubating
    @TaskAction
    protected void compile(InputChanges inputs) {
        Compiler<JavaCompileSpec> compiler;
        DefaultJavaCompileSpec spec;
        if (!this.compileOptions.isIncremental()) {
            spec = this.createSpec();
            spec.setSourceFiles(this.getSource());
            compiler = this.createCompiler(spec);
        } else {
            spec = this.createSpec();
            FileTree sources = this.getStableSources().getAsFileTree();
            compiler = this.getIncrementalCompilerFactory().makeIncremental(this.createCompiler(spec), this.getPath(), sources, new JavaRecompilationSpecProvider(this.getDeleter(), ((ProjectInternal)this.getProject()).getFileOperations(), sources, inputs.isIncremental(), () -> inputs.getFileChanges(this.getStableSources()).iterator()));
        }
        this.performCompilation(spec, compiler);
    }

    @Inject
    protected IncrementalCompilerFactory getIncrementalCompilerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaToolChainFactory getJavaToolChainFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    private CleaningJavaCompiler<JavaCompileSpec> createCompiler(JavaCompileSpec spec) {
        Compiler javaCompiler = CompilerUtil.castCompiler(((JavaToolChainInternal)this.getToolChain()).select(this.getPlatform()).newCompiler(spec.getClass()));
        return new CleaningJavaCompiler<JavaCompileSpec>(javaCompiler, this.getOutputs(), this.getDeleter());
    }

    @Nested
    protected JavaPlatform getPlatform() {
        return new DefaultJavaPlatform(JavaVersion.toVersion(this.getTargetCompatibility()));
    }

    private void performCompilation(JavaCompileSpec spec, Compiler<JavaCompileSpec> compiler) {
        WorkResult result = new CompileJavaBuildOperationReportingCompiler(this, compiler, this.getServices().get(BuildOperationExecutor.class)).execute(spec);
        this.setDidWork(result.getDidWork());
    }

    private DefaultJavaCompileSpec createSpec() {
        DefaultJavaCompileSpec spec = (DefaultJavaCompileSpec)new DefaultJavaCompileSpecFactory(this.compileOptions).create();
        spec.setDestinationDir(this.getDestinationDirectory().getAsFile().get());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List<File>)ImmutableList.copyOf((Iterable)this.getClasspath()));
        spec.setAnnotationProcessorPath((List<File>)(this.compileOptions.getAnnotationProcessorPath() == null ? ImmutableList.of() : ImmutableList.copyOf((Iterable)this.compileOptions.getAnnotationProcessorPath())));
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setCompileOptions(this.compileOptions);
        spec.setSourcesRoots(CompilationSourceDirs.inferSourceRoots((FileTreeInternal)this.getStableSources().getAsFileTree()));
        return spec;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @Override
    @CompileClasspath
    @Incremental
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @Incubating
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    protected FileCollection getStableSources() {
        return this.stableSources;
    }
}

