/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Splitter;

public class ScalaRuntime {
    private static final Pattern SCALA_JAR_PATTERN = Pattern.compile("scala-(\\w.*?)-(\\d.*).jar");
    private final Project project;

    public ScalaRuntime(Project project) {
        this.project = project;
    }

    public FileCollection inferScalaClasspath(final Iterable<File> classpath) {
        return new LazilyInitializedFileCollection(){

            @Override
            public String getDisplayName() {
                return "Scala runtime classpath";
            }

            @Override
            public FileCollection createDelegate() {
                if (ScalaRuntime.this.project.getRepositories().isEmpty()) {
                    throw new GradleException(String.format("Cannot infer Scala class path because no repository is declared in %s", ScalaRuntime.this.project));
                }
                File scalaLibraryJar = ScalaRuntime.this.findScalaJar(classpath, "library");
                if (scalaLibraryJar == null) {
                    throw new GradleException(String.format("Cannot infer Scala class path because no Scala library Jar was found. Does %s declare dependency to scala-library? Searched classpath: %s.", ScalaRuntime.this.project, classpath));
                }
                String scalaVersion = ScalaRuntime.this.getScalaVersion(scalaLibraryJar);
                if (scalaVersion == null) {
                    throw new AssertionError((Object)String.format("Unexpectedly failed to parse version of Scala Jar file: %s in %s", scalaLibraryJar, ScalaRuntime.this.project));
                }
                String scalaMajorMinorVersion = Joiner.on((char)'.').join(Splitter.on((char)'.').splitToList((CharSequence)scalaVersion).subList(0, 2));
                DefaultExternalModuleDependency compilerBridgeJar = new DefaultExternalModuleDependency("org.scala-sbt", "compiler-bridge_" + scalaMajorMinorVersion, "1.3.0");
                compilerBridgeJar.setTransitive(false);
                compilerBridgeJar.artifact(artifact -> {
                    artifact.setClassifier("sources");
                    artifact.setType("jar");
                    artifact.setExtension("jar");
                    artifact.setName(compilerBridgeJar.getName());
                });
                DefaultExternalModuleDependency compilerInterfaceJar = new DefaultExternalModuleDependency("org.scala-sbt", "compiler-interface", "1.3.0");
                return ScalaRuntime.this.project.getConfigurations().detachedConfiguration(new DefaultExternalModuleDependency("org.scala-lang", "scala-compiler", scalaVersion), compilerBridgeJar, compilerInterfaceJar);
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                if (classpath instanceof Buildable) {
                    context.add(classpath);
                }
            }
        };
    }

    @Nullable
    public File findScalaJar(Iterable<File> classpath, String appendix) {
        for (File file : classpath) {
            Matcher matcher = SCALA_JAR_PATTERN.matcher(file.getName());
            if (!matcher.matches() || !matcher.group(1).equals(appendix)) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public String getScalaVersion(File scalaJar) {
        Matcher matcher = SCALA_JAR_PATTERN.matcher(scalaJar.getName());
        return matcher.matches() ? matcher.group(2) : null;
    }
}

