/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.NonExtensible;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.services.internal.BuildServiceProvider;
import org.gradle.api.services.internal.BuildServiceRegistryInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.SharedResource;
import org.gradle.internal.resources.SharedResourceLeaseRegistry;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultBuildServicesRegistry
implements BuildServiceRegistryInternal {
    private final NamedDomainObjectSet<BuildServiceRegistration<?, ?>> registrations;
    private final InstantiatorFactory instantiatorFactory;
    private final ListenerManager listenerManager;
    private final IsolatableFactory isolatableFactory;
    private final SharedResourceLeaseRegistry leaseRegistry;
    private final IsolationScheme<BuildService, BuildServiceParameters> isolationScheme = new IsolationScheme<BuildService, BuildServiceParameters.None>(BuildService.class, BuildServiceParameters.class, BuildServiceParameters.None.class);
    private final Instantiator paramsInstantiator;
    private final Instantiator specInstantiator;

    public DefaultBuildServicesRegistry(DomainObjectCollectionFactory factory, InstantiatorFactory instantiatorFactory, ServiceRegistry services, ListenerManager listenerManager, IsolatableFactory isolatableFactory, SharedResourceLeaseRegistry leaseRegistry) {
        this.registrations = (NamedDomainObjectSet)Cast.uncheckedCast(factory.newNamedDomainObjectSet(BuildServiceRegistration.class));
        this.instantiatorFactory = instantiatorFactory;
        this.listenerManager = listenerManager;
        this.isolatableFactory = isolatableFactory;
        this.leaseRegistry = leaseRegistry;
        this.paramsInstantiator = instantiatorFactory.decorateScheme().withServices(services).instantiator();
        this.specInstantiator = instantiatorFactory.decorateLenientScheme().withServices(services).instantiator();
    }

    @Override
    public NamedDomainObjectSet<BuildServiceRegistration<?, ?>> getRegistrations() {
        return this.registrations;
    }

    @Override
    public SharedResource forService(Provider<? extends BuildService<?>> service) {
        if (!(service instanceof BuildServiceProvider)) {
            throw new IllegalArgumentException("The given provider is not a build service provider.");
        }
        BuildServiceProvider provider = (BuildServiceProvider)service;
        DefaultServiceRegistration registration = (DefaultServiceRegistration)this.registrations.getByName(provider.getName());
        return registration.asSharedResource(() -> {
            registration.getMaxParallelUsages().finalizeValue();
            int maxUsages = registration.getMaxParallelUsages().getOrElse(-1);
            if (maxUsages > 0) {
                this.leaseRegistry.registerSharedResource(provider.getName(), maxUsages);
            }
            return new ServiceBackedSharedResource(provider.getName(), maxUsages, this.leaseRegistry);
        });
    }

    @Override
    public <T extends BuildService<P>, P extends BuildServiceParameters> Provider<T> registerIfAbsent(String name, Class<T> implementationType, Action<? super BuildServiceSpec<P>> configureAction) {
        BuildServiceRegistration existing = (BuildServiceRegistration)this.registrations.findByName(name);
        if (existing != null) {
            return (Provider)Cast.uncheckedCast(existing.getService());
        }
        Class parameterType = this.isolationScheme.parameterTypeFor(implementationType);
        BuildServiceParameters parameters = parameterType != null ? (BuildServiceParameters)this.paramsInstantiator.newInstance(parameterType, new Object[0]) : null;
        DefaultServiceSpec spec = this.specInstantiator.newInstance(DefaultServiceSpec.class, parameters);
        configureAction.execute(spec);
        Integer maxParallelUsages = (Integer)spec.getMaxParallelUsages().getOrNull();
        return this.doRegister(name, implementationType, parameterType, parameters, maxParallelUsages);
    }

    @Override
    public BuildServiceProvider<?, ?> register(String name, Class<? extends BuildService> implementationType, BuildServiceParameters parameters, int maxUsages) {
        if (this.registrations.findByName(name) != null) {
            throw new IllegalArgumentException(String.format("Service '%s' has already been registered.", name));
        }
        return this.doRegister(name, implementationType, this.isolationScheme.parameterTypeFor(implementationType), parameters, maxUsages <= 0 ? null : Integer.valueOf(maxUsages));
    }

    private <T extends BuildService<P>, P extends BuildServiceParameters> BuildServiceProvider<T, P> doRegister(String name, Class<T> implementationType, Class<P> parameterType, P parameters, @Nullable Integer maxParallelUsages) {
        BuildServiceProvider<T, P> provider = new BuildServiceProvider<T, P>(name, implementationType, parameterType, parameters, this.instantiatorFactory.injectScheme(), this.isolatableFactory);
        DefaultServiceRegistration registration = this.specInstantiator.newInstance(DefaultServiceRegistration.class, name, parameters, provider);
        registration.getMaxParallelUsages().set(maxParallelUsages);
        this.registrations.add(registration);
        this.listenerManager.addListener(new ServiceCleanupListener(provider));
        return provider;
    }

    private static class ServiceCleanupListener
    extends BuildAdapter {
        private final BuildServiceProvider<?, ?> provider;

        ServiceCleanupListener(BuildServiceProvider<?, ?> provider) {
            this.provider = provider;
        }

        @Override
        public void buildFinished(BuildResult result) {
            this.provider.maybeStop();
        }
    }

    @NonExtensible
    public static abstract class DefaultServiceSpec<P extends BuildServiceParameters>
    implements BuildServiceSpec<P> {
        private final P parameters;

        public DefaultServiceSpec(P parameters) {
            this.parameters = parameters;
        }

        @Override
        public P getParameters() {
            return this.parameters;
        }

        @Override
        public void parameters(Action<? super P> configureAction) {
            configureAction.execute(this.parameters);
        }
    }

    public static abstract class DefaultServiceRegistration<T extends BuildService<P>, P extends BuildServiceParameters>
    implements BuildServiceRegistration<T, P> {
        private final String name;
        private final P parameters;
        private final BuildServiceProvider<T, P> provider;
        private SharedResource resourceWrapper;

        public DefaultServiceRegistration(String name, P parameters, BuildServiceProvider<T, P> provider) {
            this.name = name;
            this.parameters = parameters;
            this.provider = provider;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public P getParameters() {
            return this.parameters;
        }

        @Override
        public Provider<T> getService() {
            return this.provider;
        }

        public SharedResource asSharedResource(Supplier<SharedResource> factory) {
            if (this.resourceWrapper == null) {
                this.resourceWrapper = factory.get();
            }
            return this.resourceWrapper;
        }
    }

    private static class ServiceBackedSharedResource
    implements SharedResource {
        private final String name;
        private final int maxUsages;
        private final SharedResourceLeaseRegistry leaseRegistry;

        public ServiceBackedSharedResource(String name, int maxUsages, SharedResourceLeaseRegistry leaseRegistry) {
            this.name = name;
            this.maxUsages = maxUsages;
            this.leaseRegistry = leaseRegistry;
        }

        @Override
        public int getMaxUsages() {
            return this.maxUsages;
        }

        @Override
        public ResourceLock getResourceLock(int usages) {
            return this.leaseRegistry.getResourceLock(this.name, usages);
        }
    }
}

