/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import java.util.concurrent.Callable;
import org.gradle.api.internal.artifacts.repositories.transport.NetworkingIssueVerifier;
import org.gradle.api.publication.maven.internal.action.MavenDeployRetrier;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.org.apache.maven.artifact.ant.RemoteRepository;
import org.gradle.internal.impldep.org.sonatype.aether.deployment.DeploymentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMavenDeployRetrier
implements MavenDeployRetrier {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMavenDeployRetrier.class);
    private final RemoteRepository remoteRepository;
    private final Callable operation;
    private final int maxDeployAttempts;
    private final int initialBackOff;

    public DefaultMavenDeployRetrier(Callable operation, RemoteRepository remoteRepository, int maxDeployAttempts, int initialBackOff) {
        this.operation = operation;
        this.maxDeployAttempts = maxDeployAttempts;
        this.initialBackOff = initialBackOff;
        assert (maxDeployAttempts > 0);
        assert (initialBackOff > 0);
        this.remoteRepository = remoteRepository;
    }

    @Override
    public void deployWithRetry() throws DeploymentException {
        int backoff = this.initialBackOff;
        int retries = 0;
        while (retries < this.maxDeployAttempts) {
            ++retries;
            try {
                this.operation.call();
                if (retries <= 1) break;
                LOGGER.info("Successfully deployed resource after {} retries", (Object)(retries - 1));
                break;
            }
            catch (Exception throwable) {
                Exception failure = throwable;
                if (!NetworkingIssueVerifier.isLikelyTransientNetworkingIssue(failure) || retries == this.maxDeployAttempts) {
                    throw new DeploymentException("Could not deploy to remote repository | " + failure.getMessage(), (Throwable)failure);
                }
                LOGGER.info("Error while accessing remote repository {}. Waiting {}ms before next retry. {} retries left", new Object[]{this.remoteRepository, backoff, this.maxDeployAttempts - retries, failure});
                try {
                    Thread.sleep(backoff);
                    backoff *= 2;
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        }
    }
}

