/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.publication.maven.internal.MavenFactory;
import org.gradle.api.publication.maven.internal.MavenPomMetaInfoProvider;
import org.gradle.util.ConfigureUtil;

public class MavenPluginConvention
implements MavenPomMetaInfoProvider {
    private final ProjectInternal project;
    private final MavenFactory mavenFactory;
    private Conf2ScopeMappingContainer conf2ScopeMappings;
    private Object pomDir;

    public MavenPluginConvention(ProjectInternal project, MavenFactory mavenFactory) {
        this.project = project;
        this.mavenFactory = mavenFactory;
        this.conf2ScopeMappings = mavenFactory.createConf2ScopeMappingContainer(Collections.emptyMap());
    }

    public Conf2ScopeMappingContainer getConf2ScopeMappings() {
        return this.conf2ScopeMappings;
    }

    public void setConf2ScopeMappings(Conf2ScopeMappingContainer conf2ScopeMappings) {
        this.conf2ScopeMappings = conf2ScopeMappings;
    }

    @Override
    public File getMavenPomDir() {
        if (this.pomDir == null) {
            return new File(this.project.getBuildDir(), "poms");
        }
        return this.project.getFileResolver().resolve(this.pomDir);
    }

    public void setMavenPomDir(File pomDir) {
        this.setMavenPomDir((Object)pomDir);
    }

    public void setMavenPomDir(Object pomDir) {
        this.pomDir = pomDir;
    }

    public MavenPom pom() {
        MavenPom pom = this.createMavenPom();
        pom.setGroupId(this.project.getGroup().toString());
        pom.setArtifactId(this.project.getName());
        pom.setVersion(this.project.getVersion().toString());
        return pom;
    }

    public MavenPom pom(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.pom());
    }

    public MavenPom pom(Action<? super MavenPom> configureAction) {
        MavenPom pom = this.pom();
        configureAction.execute(pom);
        return pom;
    }

    private MavenPom createMavenPom() {
        return this.mavenFactory.createMavenPomFactory(this.project.getConfigurations(), this.conf2ScopeMappings.getMappings(), this.project.getFileResolver()).create();
    }
}

