/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.gradle.api.internal.tasks.options.AbstractOptionElement;
import org.gradle.api.internal.tasks.options.BooleanOptionElement;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.api.internal.tasks.options.OptionValueNotationParserFactory;
import org.gradle.api.internal.tasks.options.PropertySetter;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.model.internal.type.ModelType;

public class MethodOptionElement {
    private static String assertValidOptionName(Option option, String elementName, Class<?> declaredClass) {
        if (option.option().length() == 0) {
            throw new OptionValidationException(String.format("No option name set on '%s' in class '%s'.", elementName, declaredClass.getName()));
        }
        return option.option();
    }

    public static OptionElement create(Option option, Method method, OptionValueNotationParserFactory optionValueNotationParserFactory) {
        String optionName = MethodOptionElement.assertValidOptionName(option, method.getName(), method.getDeclaringClass());
        if (Property.class.isAssignableFrom(method.getReturnType())) {
            MethodOptionElement.assertCanUseMethodReturnType(optionName, method);
            PropertySetter setter = MethodOptionElement.mutateUsingReturnValue(method);
            return AbstractOptionElement.of(optionName, option, setter, optionValueNotationParserFactory);
        }
        if (method.getParameterTypes().length == 0) {
            return new BooleanOptionElement(optionName, option, MethodOptionElement.setFlagUsingMethod(method));
        }
        MethodOptionElement.assertCanUseMethodParam(optionName, method);
        PropertySetter setter = MethodOptionElement.mutateUsingParameter(method);
        return AbstractOptionElement.of(optionName, option, setter, optionValueNotationParserFactory);
    }

    private static PropertySetter setFlagUsingMethod(Method method) {
        return new MethodInvokingSetter(method);
    }

    private static PropertySetter mutateUsingParameter(Method method) {
        return new MethodPropertySetter(method);
    }

    private static PropertySetter mutateUsingReturnValue(Method method) {
        return new PropertyValueSetter(method);
    }

    private static void assertCanUseMethodReturnType(String optionName, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 0) {
            throw new OptionValidationException(String.format("Option '%s' on method that returns %s cannot take parameters in class '%s#%s'.", optionName, method.getGenericReturnType(), method.getDeclaringClass().getName(), method.getName()));
        }
    }

    private static void assertCanUseMethodParam(String optionName, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new OptionValidationException(String.format("Option '%s' on method cannot take multiple parameters in class '%s#%s'.", optionName, method.getDeclaringClass().getName(), method.getName()));
        }
    }

    private static class MethodInvokingSetter
    implements PropertySetter {
        private final Method method;

        public MethodInvokingSetter(Method method) {
            this.method = method;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public Class<?> getRawType() {
            return Void.TYPE;
        }

        @Override
        public Type getGenericType() {
            return Void.TYPE;
        }

        @Override
        public void setValue(Object object, Object value) {
            JavaMethod.of(Object.class, this.method).invoke(object, new Object[0]);
        }
    }

    private static class PropertyValueSetter
    implements PropertySetter {
        private final Method method;
        private final Class<?> elementType;

        public PropertyValueSetter(Method method) {
            this.method = method;
            this.elementType = ModelType.of(method.getGenericReturnType()).getTypeVariables().get(0).getRawClass();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public Class<?> getRawType() {
            return this.elementType;
        }

        @Override
        public Type getGenericType() {
            return this.elementType;
        }

        @Override
        public void setValue(Object target, Object value) {
            Property property = (Property)JavaMethod.of(Object.class, this.method).invoke(target, new Object[0]);
            property.set(value);
        }
    }

    private static class MethodPropertySetter
    implements PropertySetter {
        private final Method method;

        public MethodPropertySetter(Method method) {
            this.method = method;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public Class<?> getRawType() {
            return this.method.getParameterTypes()[0];
        }

        @Override
        public Type getGenericType() {
            return this.method.getGenericParameterTypes()[0];
        }

        @Override
        public void setValue(Object target, Object value) {
            JavaMethod.of(Object.class, this.method).invoke(target, value);
        }
    }
}

