/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.util.DeprecationLogger;

public class TransformBackedProvider<OUT, IN>
extends AbstractMappingProvider<OUT, IN> {
    private final Transformer<? extends OUT, ? super IN> transformer;

    public TransformBackedProvider(Transformer<? extends OUT, ? super IN> transformer, ProviderInternal<? extends IN> provider) {
        super(null, provider);
        this.transformer = transformer;
    }

    public Transformer<? extends OUT, ? super IN> getTransformer() {
        return this.transformer;
    }

    @Override
    public boolean isValueProducedByTask() {
        return super.isValueProducedByTask() || !this.getProducerTasks().isEmpty();
    }

    @Override
    protected void beforeRead() {
        for (Task producer : this.getProducerTasks()) {
            if (producer.getState().getExecuted()) continue;
            DeprecationLogger.nagUserOfDiscontinuedInvocation(String.format("Querying the mapped value of %s before %s has completed", this.getProvider(), producer));
            break;
        }
    }

    @Override
    protected OUT mapValue(IN v) {
        OUT result = this.transformer.transform(v);
        if (result == null) {
            throw new IllegalStateException("Transformer for this provider returned a null value.");
        }
        return result;
    }

    private List<Task> getProducerTasks() {
        ArrayList<Task> producers = new ArrayList<Task>();
        this.getProvider().visitProducerTasks(producers::add);
        return producers;
    }
}

