/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.AbstractProviderWithValue;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ScalarSupplier;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;

public class Providers {
    public static final String NULL_TRANSFORMER_RESULT = "Transformer for this provider returned a null value.";
    public static final String NULL_VALUE = "No value has been specified for this provider.";
    private static final NoValueProvider NULL_PROVIDER = new NoValueProvider();
    public static final Provider<Boolean> TRUE = Providers.of(true);
    public static final Provider<Boolean> FALSE = Providers.of(false);

    public static <T> ScalarSupplier<T> noValue() {
        return (ScalarSupplier)Cast.uncheckedCast(NULL_PROVIDER);
    }

    public static <T> ScalarSupplier<T> fixedValue(T value) {
        return new FixedValueProvider<T>(value);
    }

    public static <T> ScalarSupplier<T> fixedValue(DisplayName owner, T value, Class<T> targetType, ValueSanitizer<T> sanitizer) {
        if (!targetType.isInstance(value = sanitizer.sanitize(value))) {
            throw new IllegalArgumentException(String.format("Cannot set the value of %s of type %s using an instance of type %s.", owner.getDisplayName(), targetType.getName(), value.getClass().getName()));
        }
        return new FixedValueProvider<T>(value);
    }

    public static <T> ScalarSupplier<T> nullableValue(@Nullable T value) {
        if (value == null) {
            return Providers.noValue();
        }
        return Providers.fixedValue(value);
    }

    public static <T> ProviderInternal<T> notDefined() {
        return (ProviderInternal)Cast.uncheckedCast(NULL_PROVIDER);
    }

    public static <T> ProviderInternal<T> of(T value) {
        return new FixedValueProvider<T>(value);
    }

    public static <T> ProviderInternal<T> internal(Provider<T> value) {
        return (ProviderInternal)Cast.uncheckedCast(value);
    }

    public static <T> ProviderInternal<T> ofNullable(@Nullable T value) {
        if (value == null) {
            return Providers.notDefined();
        }
        return Providers.of(value);
    }

    public static IllegalStateException nullValue(Describable owner) {
        return new IllegalStateException(String.format("No value has been specified for %s.", owner.getDisplayName()));
    }

    private static class NoValueProvider
    extends AbstractMinimalProvider<Object>
    implements ScalarSupplier<Object> {
        private NoValueProvider() {
        }

        @Override
        public Object get() {
            throw new IllegalStateException(Providers.NULL_VALUE);
        }

        @Override
        public Object get(DisplayName owner) throws IllegalStateException {
            throw Providers.nullValue(owner);
        }

        @Override
        public boolean immutable() {
            return true;
        }

        @Override
        @Nullable
        public Class<Object> getType() {
            return null;
        }

        @Override
        public Object getOrNull() {
            return null;
        }

        @Override
        public Object getOrElse(Object defaultValue) {
            return defaultValue;
        }

        @Override
        public <S> ProviderInternal<S> map(Transformer<? extends S, ? super Object> transformer) {
            return (ProviderInternal)Cast.uncheckedCast(this);
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public ScalarSupplier<Object> asSupplier(DisplayName owner, Class<? super Object> targetType, ValueSanitizer<? super Object> sanitizer) {
            return this;
        }

        @Override
        public ProviderInternal<Object> asProvider() {
            return this;
        }

        @Override
        public ScalarSupplier<Object> withFinalValue() {
            return this;
        }

        @Override
        public Provider<Object> orElse(Object value) {
            return Providers.of(value);
        }

        @Override
        public Provider<Object> orElse(Provider<?> provider) {
            return (Provider)Cast.uncheckedCast(provider);
        }

        @Override
        public String toString() {
            return "undefined";
        }
    }

    private static class MappedFixedValueProvider<S, T>
    extends AbstractMinimalProvider<S> {
        private final Transformer<? extends S, ? super T> transformer;
        private final Provider<T> provider;
        private S value;

        MappedFixedValueProvider(Transformer<? extends S, ? super T> transformer, Provider<T> provider) {
            this.transformer = transformer;
            this.provider = provider;
        }

        @Override
        @Nullable
        public Class<S> getType() {
            if (this.value != null) {
                return (Class)Cast.uncheckedCast(this.value.getClass());
            }
            return null;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public S get() {
            if (this.value == null) {
                this.value = this.transformer.transform(this.provider.get());
                if (this.value == null) {
                    throw new IllegalStateException(Providers.NULL_TRANSFORMER_RESULT);
                }
            }
            return this.value;
        }

        @Override
        public S getOrElse(S defaultValue) {
            return this.get();
        }

        @Override
        @Nullable
        public S getOrNull() {
            return this.get();
        }

        @Override
        public <U> ProviderInternal<U> map(Transformer<? extends U, ? super S> transformer) {
            return new MappedFixedValueProvider<U, S>(transformer, this);
        }

        @Override
        public String toString() {
            if (this.value == null) {
                return String.format("transform(not calculated)", new Object[0]);
            }
            return String.format("transform(%s, %s)", this.getType(), this.value);
        }
    }

    public static class FixedValueProvider<T>
    extends AbstractProviderWithValue<T>
    implements ScalarSupplier<T> {
        private final T value;

        FixedValueProvider(T value) {
            this.value = value;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return (Class)Cast.uncheckedCast(this.value.getClass());
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T get(DisplayName owner) throws IllegalStateException {
            return this.value;
        }

        @Override
        public ProviderInternal<T> asProvider() {
            return this;
        }

        @Override
        public ScalarSupplier<T> withFinalValue() {
            return this;
        }

        @Override
        public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
            return new MappedFixedValueProvider<S, T>(transformer, this);
        }

        @Override
        public String toString() {
            return String.format("fixed(%s, %s)", this.getType(), this.value);
        }
    }
}

