/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.file.FileContents;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSourceProviderFactory;
import org.gradle.api.internal.provider.sources.EnvironmentVariableValueSource;
import org.gradle.api.internal.provider.sources.FileBytesValueSource;
import org.gradle.api.internal.provider.sources.FileContentValueSource;
import org.gradle.api.internal.provider.sources.FileTextValueSource;
import org.gradle.api.internal.provider.sources.SystemPropertyValueSource;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;

public class DefaultProviderFactory
implements ProviderFactory {
    @Nullable
    private final ValueSourceProviderFactory valueSourceProviderFactory;

    public DefaultProviderFactory() {
        this(null);
    }

    public DefaultProviderFactory(@Nullable ValueSourceProviderFactory valueSourceProviderFactory) {
        this.valueSourceProviderFactory = valueSourceProviderFactory;
    }

    @Override
    public <T> Provider<T> provider(Callable<? extends T> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return new DefaultProvider<T>(value);
    }

    @Override
    public Provider<String> environmentVariable(String variableName) {
        return this.environmentVariable(Providers.of(variableName));
    }

    @Override
    public Provider<String> environmentVariable(Provider<String> variableName) {
        return this.of(EnvironmentVariableValueSource.class, spec -> ((EnvironmentVariableValueSource.Parameters)spec.getParameters()).getVariableName().set(variableName));
    }

    @Override
    public Provider<String> systemProperty(String propertyName) {
        return this.systemProperty(Providers.of(propertyName));
    }

    @Override
    public Provider<String> systemProperty(Provider<String> propertyName) {
        return this.of(SystemPropertyValueSource.class, spec -> ((SystemPropertyValueSource.Parameters)spec.getParameters()).getPropertyName().set(propertyName));
    }

    @Override
    public FileContents fileContents(RegularFile file) {
        return this.fileContents((RegularFileProperty property) -> property.set(file));
    }

    @Override
    public FileContents fileContents(Provider<RegularFile> file) {
        return this.fileContents((RegularFileProperty property) -> property.set(file));
    }

    private FileContents fileContents(final Action<RegularFileProperty> setFileProperty) {
        return new FileContents(){

            @Override
            public Provider<String> getAsText() {
                return DefaultProviderFactory.this.of(FileTextValueSource.class, spec -> setFileProperty.execute(((FileContentValueSource.Parameters)spec.getParameters()).getFile()));
            }

            @Override
            public Provider<byte[]> getAsBytes() {
                return DefaultProviderFactory.this.of(FileBytesValueSource.class, spec -> setFileProperty.execute(((FileContentValueSource.Parameters)spec.getParameters()).getFile()));
            }
        };
    }

    @Override
    public <T, P extends ValueSourceParameters> Provider<T> of(Class<? extends ValueSource<T, P>> valueSourceType, Action<? super ValueSourceSpec<P>> configuration) {
        if (this.valueSourceProviderFactory == null) {
            throw new UnsupportedOperationException();
        }
        return this.valueSourceProviderFactory.createProviderOf(valueSourceType, configuration);
    }
}

