/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.Set;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;

public abstract class ImmutableFileCollection
extends AbstractFileCollection {
    private static final ImmutableFileCollection EMPTY = new ImmutableFileCollection(){

        @Override
        public Set<File> getFiles() {
            return ImmutableSet.of();
        }
    };

    public static ImmutableFileCollection of() {
        return EMPTY;
    }

    public static ImmutableFileCollection of(File ... files) {
        if (files.length == 0) {
            return EMPTY;
        }
        return new FileOnlyImmutableFileCollection((ImmutableSet<File>)ImmutableSet.copyOf((Object[])files));
    }

    public static ImmutableFileCollection of(Iterable<? extends File> files) {
        if (Iterables.isEmpty(files)) {
            return EMPTY;
        }
        return new FileOnlyImmutableFileCollection((ImmutableSet<File>)ImmutableSet.copyOf(files));
    }

    private ImmutableFileCollection() {
    }

    @Override
    public String getDisplayName() {
        return "file collection";
    }

    private static class FileOnlyImmutableFileCollection
    extends ImmutableFileCollection {
        private final ImmutableSet<File> files;

        FileOnlyImmutableFileCollection(ImmutableSet<File> files) {
            this.files = files;
        }

        @Override
        public Set<File> getFiles() {
            return this.files;
        }

        @Override
        public String toString() {
            if (this.files.size() == 1) {
                return String.format("file '%s'", ((File)this.files.iterator().next()).getAbsolutePath());
            }
            return super.toString();
        }
    }
}

