/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileBackedDirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.SingletonFileTree;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public abstract class AbstractSingletonFileTree
implements SingletonFileTree,
PatternFilterableFileTree,
FileSystemMirroringFileTree {
    private final PatternSet patterns;

    protected AbstractSingletonFileTree(PatternSet patterns) {
        this.patterns = patterns;
    }

    protected abstract FileVisitDetails createFileVisitDetails();

    @Override
    public void visit(FileVisitor visitor) {
        FileVisitDetails fileVisitDetails = this.createFileVisitDetails();
        if (this.patterns.isEmpty() || this.patterns.getAsSpec().isSatisfiedBy(fileVisitDetails)) {
            visitor.visitFile(fileVisitDetails);
        }
    }

    @Override
    public PatternSet getPatterns() {
        return this.patterns;
    }

    protected PatternSet filterPatternSet(PatternFilterable patterns) {
        PatternSet patternSet = this.patterns.intersect();
        patternSet.copyFrom(patterns);
        return patternSet;
    }

    @Override
    public DirectoryFileTree getMirror() {
        return new FileBackedDirectoryFileTree(this.getFile()).filter(this.patterns);
    }
}

