/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.ManagedFactories;
import org.gradle.api.internal.provider.AbstractCombiningProvider;
import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.AbstractReadOnlyProvider;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.state.Managed;

public class DefaultFilePropertyFactory
implements FilePropertyFactory {
    private final FileResolver fileResolver;
    private final FileCollectionFactory fileCollectionFactory;

    public DefaultFilePropertyFactory(FileResolver resolver, FileCollectionFactory fileCollectionFactory) {
        this.fileResolver = resolver;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    @Override
    public DirectoryProperty newDirectoryProperty() {
        return new DefaultDirectoryVar(this.fileResolver, this.fileCollectionFactory);
    }

    @Override
    public RegularFileProperty newFileProperty() {
        return new DefaultRegularFileVar(this.fileResolver);
    }

    static class ToFileProvider
    extends AbstractMappingProvider<File, FileSystemLocation> {
        ToFileProvider(ProviderInternal<? extends FileSystemLocation> provider) {
            super(File.class, provider);
        }

        @Override
        protected File mapValue(FileSystemLocation provider) {
            return provider.getAsFile();
        }
    }

    public static class DefaultDirectoryVar
    extends AbstractFileVar<Directory, DirectoryProperty>
    implements DirectoryProperty,
    Managed {
        private final FileResolver resolver;
        private final FileCollectionFactory fileCollectionFactory;

        DefaultDirectoryVar(FileResolver resolver, FileCollectionFactory fileCollectionFactory) {
            super(Directory.class);
            this.resolver = resolver;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        DefaultDirectoryVar(FileResolver resolver, FileCollectionFactory fileCollectionFactory, Object value) {
            super(Directory.class);
            this.resolver = resolver;
            this.fileCollectionFactory = fileCollectionFactory;
            this.resolveAndSet(value);
        }

        @Override
        public Class<?> publicType() {
            return DirectoryProperty.class;
        }

        @Override
        public int getFactoryId() {
            return ManagedFactories.DirectoryPropertyManagedFactory.FACTORY_ID;
        }

        @Override
        public FileTree getAsFileTree() {
            return this.fileCollectionFactory.resolving(this).getAsFileTree();
        }

        void resolveAndSet(Object value) {
            File resolved = this.resolver.resolve(value);
            FileResolver dirResolver = this.resolver.newResolver(resolved);
            this.set(new FixedDirectory(resolved, dirResolver, this.fileCollectionFactory.withResolver(dirResolver)));
        }

        @Override
        protected Directory fromFile(File dir) {
            File resolved = this.resolver.resolve(dir);
            FileResolver dirResolver = this.resolver.newResolver(resolved);
            return new FixedDirectory(resolved, dirResolver, this.fileCollectionFactory.withResolver(dirResolver));
        }

        @Override
        public Provider<Directory> dir(final String path) {
            return new AbstractMappingProvider<Directory, Directory>(Directory.class, (ProviderInternal)this){

                @Override
                protected Directory mapValue(Directory dir) {
                    return dir.dir(path);
                }
            };
        }

        @Override
        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<Directory, Directory, CharSequence>(Directory.class, (Provider)this, path){

                @Override
                protected Directory map(Directory b, CharSequence v) {
                    return b.dir(v.toString());
                }
            };
        }

        @Override
        public Provider<RegularFile> file(final String path) {
            return new AbstractMappingProvider<RegularFile, Directory>(RegularFile.class, (ProviderInternal)this){

                @Override
                protected RegularFile mapValue(Directory dir) {
                    return dir.file(path);
                }
            };
        }

        @Override
        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<RegularFile, Directory, CharSequence>(RegularFile.class, (Provider)this, path){

                @Override
                protected RegularFile map(Directory b, CharSequence v) {
                    return b.file(v.toString());
                }
            };
        }

        @Override
        public FileCollection files(Object ... paths) {
            return this.fileCollectionFactory.withResolver(this.resolver).resolving(paths);
        }
    }

    static class ResolvingDirectory
    extends AbstractMappingProvider<Directory, CharSequence> {
        private final FileResolver resolver;
        private final FileCollectionFactory fileCollectionFactory;

        ResolvingDirectory(FileResolver resolver, FileCollectionFactory fileCollectionFactory, ProviderInternal<? extends CharSequence> valueProvider) {
            super(Directory.class, valueProvider);
            this.resolver = resolver;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        @Override
        protected Directory mapValue(CharSequence path) {
            File dir = this.resolver.resolve(path);
            FileResolver dirResolver = this.resolver.newResolver(dir);
            return new FixedDirectory(dir, dirResolver, this.fileCollectionFactory.withResolver(dirResolver));
        }
    }

    public static class DefaultRegularFileVar
    extends AbstractFileVar<RegularFile, RegularFileProperty>
    implements RegularFileProperty,
    Managed {
        private final PathToFileResolver fileResolver;

        DefaultRegularFileVar(PathToFileResolver fileResolver) {
            super(RegularFile.class);
            this.fileResolver = fileResolver;
        }

        @Override
        public Class<?> publicType() {
            return RegularFileProperty.class;
        }

        @Override
        public int getFactoryId() {
            return ManagedFactories.RegularFilePropertyManagedFactory.FACTORY_ID;
        }

        @Override
        protected RegularFile fromFile(File file) {
            return new FixedFile(this.fileResolver.resolve(file));
        }
    }

    static abstract class AbstractFileVar<T extends FileSystemLocation, THIS extends FileSystemLocationProperty<T>>
    extends DefaultProperty<T>
    implements FileSystemLocationProperty<T> {
        public AbstractFileVar(Class<T> type) {
            super(type);
        }

        protected abstract T fromFile(File var1);

        @Override
        public Provider<File> getAsFile() {
            return new ToFileProvider(this);
        }

        @Override
        public void setFromAnyValue(Object object) {
            if (object instanceof File) {
                this.set((File)object);
            } else {
                super.setFromAnyValue(object);
            }
        }

        public THIS value(T value) {
            super.value(value);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        public THIS value(Provider<? extends T> provider) {
            super.value(provider);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        @Override
        public void set(File file) {
            if (file == null) {
                this.set((FileSystemLocation)null);
                return;
            }
            this.set(this.fromFile(file));
        }

        public THIS fileValue(@Nullable File file) {
            this.set(file);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        public THIS fileProvider(Provider<File> provider) {
            this.set(provider.map((? super T file) -> this.fromFile((File)file)));
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        public THIS convention(T value) {
            super.convention(value);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        public THIS convention(Provider<? extends T> valueProvider) {
            super.convention(valueProvider);
            return (THIS)((FileSystemLocationProperty)Cast.uncheckedNonnullCast(this));
        }

        @Override
        public Provider<T> getLocationOnly() {
            return new AbstractReadOnlyProvider<T>(){

                @Override
                @Nullable
                public Class<T> getType() {
                    return this.getType();
                }

                @Override
                @Nullable
                public T getOrNull() {
                    return (FileSystemLocation)this.getOrNull();
                }
            };
        }
    }

    static class ResolvingRegularFileProvider
    extends AbstractMappingProvider<RegularFile, CharSequence> {
        private final PathToFileResolver resolver;

        ResolvingRegularFileProvider(PathToFileResolver resolver, ProviderInternal<? extends CharSequence> path) {
            super(RegularFile.class, path);
            this.resolver = resolver;
        }

        @Override
        protected RegularFile mapValue(CharSequence path) {
            return new FixedFile(this.resolver.resolve(path));
        }
    }

    static class FixedFile
    extends DefaultFileSystemLocation
    implements RegularFile,
    Managed {
        FixedFile(File file) {
            super(file);
        }

        @Override
        public boolean immutable() {
            return true;
        }

        @Override
        public Class<?> publicType() {
            return RegularFile.class;
        }

        @Override
        public Object unpackState() {
            return this.getAsFile();
        }

        @Override
        public int getFactoryId() {
            return ManagedFactories.RegularFileManagedFactory.FACTORY_ID;
        }
    }

    static class FixedDirectory
    extends DefaultFileSystemLocation
    implements Directory,
    Managed {
        final FileResolver fileResolver;
        private final FileCollectionFactory fileCollectionFactory;

        FixedDirectory(File value, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory) {
            super(value);
            this.fileResolver = fileResolver;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        @Override
        public boolean immutable() {
            return true;
        }

        @Override
        public Class<?> publicType() {
            return Directory.class;
        }

        @Override
        public Object unpackState() {
            return this.getAsFile();
        }

        @Override
        public int getFactoryId() {
            return ManagedFactories.DirectoryManagedFactory.FACTORY_ID;
        }

        @Override
        public Directory dir(String path) {
            File newDir = this.fileResolver.resolve(path);
            FileResolver dirResolver = this.fileResolver.newResolver(newDir);
            return new FixedDirectory(newDir, dirResolver, this.fileCollectionFactory.withResolver(dirResolver));
        }

        @Override
        public FileTree getAsFileTree() {
            return this.fileCollectionFactory.resolving(this).getAsFileTree();
        }

        @Override
        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new ResolvingDirectory(this.fileResolver, this.fileCollectionFactory, Providers.internal(path));
        }

        @Override
        public RegularFile file(String path) {
            return new FixedFile(this.fileResolver.resolve(path));
        }

        @Override
        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new ResolvingRegularFileProvider(this.fileResolver, Providers.internal(path));
        }

        @Override
        public FileCollection files(Object ... paths) {
            return this.fileCollectionFactory.withResolver(this.fileResolver).resolving(paths);
        }
    }
}

