/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.UnpackingVisitor;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class DefaultFileCollectionFactory
implements FileCollectionFactory {
    public static final String DEFAULT_DISPLAY_NAME = "file collection";
    private final PathToFileResolver fileResolver;
    private final TaskDependencyFactory taskDependencyFactory;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final Factory<PatternSet> patternSetFactory;

    public DefaultFileCollectionFactory(PathToFileResolver fileResolver, TaskDependencyFactory taskDependencyFactory, DirectoryFileTreeFactory directoryFileTreeFactory, Factory<PatternSet> patternSetFactory) {
        this.fileResolver = fileResolver;
        this.taskDependencyFactory = taskDependencyFactory;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patternSetFactory = patternSetFactory;
    }

    @Override
    public FileCollectionFactory withResolver(PathToFileResolver fileResolver) {
        if (fileResolver == this.fileResolver) {
            return this;
        }
        return new DefaultFileCollectionFactory(fileResolver, this.taskDependencyFactory, this.directoryFileTreeFactory, this.patternSetFactory);
    }

    @Override
    public ConfigurableFileCollection configurableFiles() {
        return new DefaultConfigurableFileCollection(null, this.fileResolver, this.taskDependencyFactory, Collections.emptyList());
    }

    @Override
    public ConfigurableFileCollection configurableFiles(String displayName) {
        return new DefaultConfigurableFileCollection(displayName, this.fileResolver, this.taskDependencyFactory, Collections.emptyList());
    }

    @Override
    public ConfigurableFileTree fileTree() {
        return new DefaultConfigurableFileTree(this.fileResolver, this.patternSetFactory, this.taskDependencyFactory, this.directoryFileTreeFactory);
    }

    @Override
    public FileCollectionInternal create(final TaskDependency builtBy, MinimalFileSet contents) {
        return new FileCollectionAdapter(contents){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                super.visitDependencies(context);
                context.add(builtBy);
            }
        };
    }

    @Override
    public FileCollectionInternal create(MinimalFileSet contents) {
        return new FileCollectionAdapter(contents);
    }

    @Override
    public FileCollectionInternal resolving(String displayName, List<?> sources) {
        if (sources.isEmpty()) {
            return new EmptyFileCollection(displayName);
        }
        return new ResolvingFileCollection(displayName, this.fileResolver, (ImmutableList<Object>)ImmutableList.copyOf(sources));
    }

    @Override
    public FileCollectionInternal resolving(String displayName, Object ... sources) {
        return this.resolving(displayName, (List<?>)ImmutableList.copyOf((Object[])sources));
    }

    @Override
    public FileCollectionInternal resolving(Object ... sources) {
        if (sources.length == 1 && sources[0] instanceof FileCollectionInternal) {
            return (FileCollectionInternal)sources[0];
        }
        return this.resolving(DEFAULT_DISPLAY_NAME, sources);
    }

    @Override
    public FileCollectionInternal empty(String displayName) {
        return new EmptyFileCollection(displayName);
    }

    @Override
    public FileCollectionInternal empty() {
        return this.empty(DEFAULT_DISPLAY_NAME);
    }

    @Override
    public FileCollectionInternal fixed(File ... files) {
        if (files.length == 0) {
            return this.empty();
        }
        return this.fixed(DEFAULT_DISPLAY_NAME, files);
    }

    @Override
    public FileCollectionInternal fixed(String displayName, File ... files) {
        if (files.length == 0) {
            return new EmptyFileCollection(displayName);
        }
        return new FixedFileCollection(displayName, (ImmutableSet<File>)ImmutableSet.copyOf((Object[])files));
    }

    @Override
    public FileCollectionInternal fixed(Collection<File> files) {
        if (files.isEmpty()) {
            return this.empty();
        }
        return this.fixed(DEFAULT_DISPLAY_NAME, files);
    }

    @Override
    public FileCollectionInternal fixed(String displayName, Collection<File> files) {
        if (files.isEmpty()) {
            return new EmptyFileCollection(displayName);
        }
        return new FixedFileCollection(displayName, (ImmutableSet<File>)ImmutableSet.copyOf(files));
    }

    private static final class ResolvingFileCollection
    extends CompositeFileCollection {
        private final String displayName;
        private final PathToFileResolver resolver;
        private final ImmutableList<Object> paths;

        public ResolvingFileCollection(String displayName, PathToFileResolver resolver, ImmutableList<Object> paths) {
            this.displayName = displayName;
            this.resolver = resolver;
            this.paths = paths;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public void visitContents(FileCollectionResolveContext context) {
            UnpackingVisitor nested = new UnpackingVisitor(context, this.resolver);
            nested.add(this.paths);
        }
    }

    private static final class FixedFileCollection
    extends AbstractFileCollection {
        private final String displayName;
        private final ImmutableSet<File> files;

        public FixedFileCollection(String displayName, ImmutableSet<File> files) {
            this.displayName = displayName;
            this.files = files;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public Set<File> getFiles() {
            return this.files;
        }
    }

    private static final class EmptyFileCollection
    extends AbstractFileCollection {
        private final String displayName;

        public EmptyFileCollection(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public Set<File> getFiles() {
            return ImmutableSet.of();
        }

        @Override
        public void visitStructure(FileCollectionStructureVisitor visitor) {
        }
    }
}

