/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.internal.DefaultMutationGuard;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.collections.DefaultPendingSource;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.collections.PendingSource;
import org.gradle.api.internal.provider.ChangingValue;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.ProviderInternal;

public class SortedSetElementSource<T>
implements ElementSource<T> {
    private final TreeSet<T> values;
    private final PendingSource<T> pending = new DefaultPendingSource();
    private final MutationGuard mutationGuard = new DefaultMutationGuard();

    public SortedSetElementSource(Comparator<T> comparator) {
        this.values = new TreeSet<T>(comparator);
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty() && this.pending.isEmpty();
    }

    @Override
    public boolean constantTimeIsEmpty() {
        return this.values.isEmpty() && this.pending.isEmpty();
    }

    @Override
    public int size() {
        return this.values.size() + this.pending.size();
    }

    @Override
    public int estimatedSize() {
        return this.values.size() + this.pending.size();
    }

    @Override
    public Iterator<T> iterator() {
        this.pending.realizePending();
        return this.values.iterator();
    }

    @Override
    public Iterator<T> iteratorNoFlush() {
        return this.values.iterator();
    }

    @Override
    public boolean contains(Object element) {
        this.pending.realizePending();
        return this.values.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        this.pending.realizePending();
        return this.values.containsAll(elements);
    }

    @Override
    public boolean add(T element) {
        return this.values.add(element);
    }

    @Override
    public boolean addRealized(T element) {
        return this.values.add(element);
    }

    @Override
    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    @Override
    public void clear() {
        this.pending.clear();
        this.values.clear();
    }

    @Override
    public void realizePending() {
        this.pending.realizePending();
    }

    @Override
    public void realizePending(Class<?> type) {
        this.pending.realizePending(type);
    }

    @Override
    public boolean addPending(final ProviderInternal<? extends T> provider) {
        if (provider instanceof ChangingValue) {
            ((ChangingValue)((Object)provider)).onValueChange(new Action<T>(){

                @Override
                public void execute(T previousValue) {
                    SortedSetElementSource.this.values.remove(previousValue);
                    SortedSetElementSource.this.pending.addPending(provider);
                }
            });
        }
        return this.pending.addPending(provider);
    }

    @Override
    public boolean removePending(ProviderInternal<? extends T> provider) {
        return this.pending.removePending(provider);
    }

    @Override
    public boolean addPendingCollection(final CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        if (provider instanceof ChangingValue) {
            ((ChangingValue)((Object)provider)).onValueChange(new Action<Iterable<T>>(){

                @Override
                public void execute(Iterable<T> previousValues) {
                    for (Object value : previousValues) {
                        SortedSetElementSource.this.values.remove(value);
                    }
                    SortedSetElementSource.this.pending.addPendingCollection(provider);
                }
            });
        }
        return this.pending.addPendingCollection(provider);
    }

    @Override
    public boolean removePendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        return this.pending.removePendingCollection(provider);
    }

    @Override
    public void onRealize(Action<T> action) {
        this.pending.onRealize(action);
    }

    @Override
    public void realizeExternal(ProviderInternal<? extends T> provider) {
        this.pending.realizeExternal(provider);
    }

    @Override
    public MutationGuard getMutationGuard() {
        return this.mutationGuard;
    }
}

