/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import groovy.lang.Closure;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.internal.Actions;
import org.gradle.internal.Factory;
import org.gradle.util.ConfigureUtil;

public class DefaultResolutionResult
implements ResolutionResult {
    private final Factory<ResolvedComponentResult> rootSource;
    private final AttributeContainer requestedAttributes;

    public DefaultResolutionResult(Factory<ResolvedComponentResult> rootSource, AttributeContainer requestedAttributes) {
        assert (rootSource != null);
        this.rootSource = rootSource;
        this.requestedAttributes = requestedAttributes;
    }

    @Override
    public ResolvedComponentResult getRoot() {
        return this.rootSource.create();
    }

    @Override
    public Set<? extends DependencyResult> getAllDependencies() {
        final LinkedHashSet out = new LinkedHashSet();
        this.allDependencies((Action<? super DependencyResult>)new Action<DependencyResult>(){

            @Override
            public void execute(DependencyResult dep) {
                out.add(dep);
            }
        });
        return out;
    }

    @Override
    public void allDependencies(Action<? super DependencyResult> action) {
        this.eachElement(this.getRoot(), Actions.doNothing(), action, new HashSet<ResolvedComponentResult>());
    }

    @Override
    public void allDependencies(Closure closure) {
        this.allDependencies(ConfigureUtil.configureUsing(closure));
    }

    private void eachElement(ResolvedComponentResult node, Action<? super ResolvedComponentResult> moduleAction, Action<? super DependencyResult> dependencyAction, Set<ResolvedComponentResult> visited) {
        if (!visited.add(node)) {
            return;
        }
        moduleAction.execute(node);
        for (DependencyResult dependencyResult : node.getDependencies()) {
            dependencyAction.execute(dependencyResult);
            if (!(dependencyResult instanceof ResolvedDependencyResult)) continue;
            this.eachElement(((ResolvedDependencyResult)dependencyResult).getSelected(), moduleAction, dependencyAction, visited);
        }
    }

    @Override
    public Set<ResolvedComponentResult> getAllComponents() {
        LinkedHashSet<ResolvedComponentResult> out = new LinkedHashSet<ResolvedComponentResult>();
        this.eachElement(this.getRoot(), Actions.doNothing(), Actions.doNothing(), out);
        return out;
    }

    @Override
    public void allComponents(Action<? super ResolvedComponentResult> action) {
        this.eachElement(this.getRoot(), action, Actions.doNothing(), new HashSet<ResolvedComponentResult>());
    }

    @Override
    public void allComponents(Closure closure) {
        this.allComponents(ConfigureUtil.configureUsing(closure));
    }

    @Override
    public AttributeContainer getRequestedAttributes() {
        return this.requestedAttributes;
    }
}

