/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflictFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.component.external.model.CapabilityInternal;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class DefaultCapabilitiesConflictHandler
implements CapabilitiesConflictHandler {
    private final List<CapabilitiesConflictHandler.Resolver> resolvers = Lists.newArrayListWithExpectedSize((int)3);
    private final Map<String, Set<NodeState>> capabilityWithoutVersionToNodes = Maps.newHashMap();
    private final Deque<CapabilityConflict> conflicts = new ArrayDeque<CapabilityConflict>();

    @Override
    public PotentialConflict registerCandidate(CapabilitiesConflictHandler.Candidate candidate) {
        CapabilityInternal capability = (CapabilityInternal)candidate.getCapability();
        String group = capability.getGroup();
        String name = capability.getName();
        Set<NodeState> nodes = this.findNodesFor(capability);
        Collection<NodeState> implicitCapabilityProviders = candidate.getImplicitCapabilityProviders();
        nodes.addAll(implicitCapabilityProviders);
        NodeState node = candidate.getNode();
        if ((nodes.add(node) || implicitCapabilityProviders.contains(node)) && nodes.size() > 1) {
            ModuleIdentifier rootId = null;
            final ArrayList candidatesForConflict = Lists.newArrayListWithCapacity((int)nodes.size());
            for (NodeState ns : nodes) {
                if (!ns.isSelected() || ns.isAttachedToVirtualPlatform()) continue;
                candidatesForConflict.add(ns);
                if (!ns.isRoot()) continue;
                rootId = ns.getComponent().getId().getModule();
            }
            if (rootId != null && candidatesForConflict.size() > 1) {
                ModuleIdentifier rootModuleId = rootId;
                candidatesForConflict.removeIf(n -> !n.isRoot() && n.getComponent().getId().getModule().equals(rootModuleId));
            }
            if (candidatesForConflict.size() > 1) {
                PotentialConflict conflict = new PotentialConflict(){

                    @Override
                    public void withParticipatingModules(Action<ModuleIdentifier> action) {
                        for (NodeState node : candidatesForConflict) {
                            action.execute(node.getComponent().getId().getModule());
                        }
                    }

                    @Override
                    public boolean conflictExists() {
                        return true;
                    }
                };
                this.conflicts.add(new CapabilityConflict(group, name, candidatesForConflict));
                return conflict;
            }
        }
        return PotentialConflictFactory.noConflict();
    }

    private Set<NodeState> findNodesFor(CapabilityInternal capability) {
        String capabilityId = capability.getCapabilityId();
        LinkedHashSet nodes = this.capabilityWithoutVersionToNodes.get(capabilityId);
        if (nodes == null) {
            nodes = Sets.newLinkedHashSet();
            this.capabilityWithoutVersionToNodes.put(capabilityId, nodes);
        }
        return nodes;
    }

    @Override
    public boolean hasConflicts() {
        return !this.conflicts.isEmpty();
    }

    @Override
    public void resolveNextConflict(Action<ConflictResolutionResult> resolutionAction) {
        CapabilityConflict conflict = this.conflicts.poll();
        Details details = new Details(conflict);
        for (CapabilitiesConflictHandler.Resolver resolver : this.resolvers) {
            resolver.resolve(details);
            if (!details.hasResult()) continue;
            resolutionAction.execute(details);
            ComponentSelectionDescriptorInternal conflictResolution = ComponentSelectionReasons.CONFLICT_RESOLUTION;
            if (details.reason != null) {
                conflictResolution = conflictResolution.withDescription(details.reason);
            }
            details.getSelected().addCause(conflictResolution);
            return;
        }
    }

    @Override
    public void registerResolver(CapabilitiesConflictHandler.Resolver conflictResolver) {
        this.resolvers.add(conflictResolver);
    }

    @Override
    public boolean hasSeenCapability(Capability capability) {
        return this.capabilityWithoutVersionToNodes.containsKey(((CapabilityInternal)capability).getCapabilityId());
    }

    public static CapabilitiesConflictHandler.Candidate candidate(NodeState node, Capability capability, Collection<NodeState> implicitCapabilityProviders) {
        return new Candidate(node, capability, implicitCapabilityProviders);
    }

    private static String prettifyCapabilities(CapabilityConflict conflict) {
        TreeSet capabilities = Sets.newTreeSet();
        for (Capability c : conflict.descriptors) {
            capabilities.add(c.getGroup() + ":" + c.getName() + ":" + c.getVersion());
        }
        return Joiner.on((String)", ").join((Iterable)capabilities);
    }

    private static String prettifyCandidates(CapabilityConflict conflict) {
        TreeSet candidates = Sets.newTreeSet();
        boolean showVariant = DefaultCapabilitiesConflictHandler.sameComponentAppearsMultipleTimes(conflict);
        for (NodeState node : conflict.nodes) {
            candidates.add(showVariant ? node.getNameWithVariant() : node.getSimpleName());
        }
        return Joiner.on((String)" and ").join((Iterable)candidates);
    }

    private static boolean sameComponentAppearsMultipleTimes(CapabilityConflict conflict) {
        HashSet components = Sets.newHashSet();
        for (NodeState node : conflict.nodes) {
            if (components.add(node.getComponent())) continue;
            return true;
        }
        return false;
    }

    private static class CapabilityConflict {
        private final Collection<NodeState> nodes;
        private final Set<Capability> descriptors;

        private CapabilityConflict(String group, String name, Collection<NodeState> nodes) {
            this.nodes = nodes;
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (NodeState node : nodes) {
                Capability capability = node.findCapability(group, name);
                if (capability == null) continue;
                builder.add((Object)capability);
            }
            this.descriptors = builder.build();
        }
    }

    private static class Details
    implements CapabilitiesConflictHandler.ResolutionDetails {
        private final CapabilityConflict conflict;
        private final Set<NodeState> evicted = Sets.newHashSet();
        private NodeState selected;
        private Describable reason;

        private Details(CapabilityConflict conflict) {
            this.conflict = conflict;
        }

        @Override
        public Collection<? extends Capability> getCapabilityVersions() {
            return this.conflict.descriptors;
        }

        @Override
        public Collection<? extends CapabilitiesConflictHandler.CandidateDetails> getCandidates(final Capability capability) {
            ImmutableList.Builder candidates = new ImmutableList.Builder();
            String group = capability.getGroup();
            String name = capability.getName();
            String version = capability.getVersion();
            for (final NodeState node : this.conflict.nodes) {
                Capability componentCapability;
                if (this.evicted.contains(node) || (componentCapability = node.findCapability(group, name)) == null || !componentCapability.getVersion().equals(version)) continue;
                candidates.add((Object)new CapabilitiesConflictHandler.CandidateDetails(){

                    @Override
                    public ComponentIdentifier getId() {
                        return node.getComponent().getComponentId();
                    }

                    @Override
                    public String getVariantName() {
                        return node.getResolvedConfigurationId().getConfiguration();
                    }

                    @Override
                    public void evict() {
                        node.evict();
                        evicted.add(node);
                    }

                    @Override
                    public void select() {
                        selected = node;
                    }

                    @Override
                    public void reject() {
                        ComponentState component = node.getComponent();
                        component.rejectForCapabilityConflict(capability, this.conflictedNodes(node, conflict.nodes));
                        component.selectAndRestartModule();
                    }

                    @Override
                    public void byReason(Describable description) {
                        reason = description;
                    }
                });
            }
            return candidates.build();
        }

        private Collection<NodeState> conflictedNodes(NodeState node, Collection<NodeState> nodes) {
            ArrayList conflictedNodes = Lists.newArrayList(nodes);
            conflictedNodes.remove(node);
            return conflictedNodes;
        }

        @Override
        public void withParticipatingModules(Action<? super ModuleIdentifier> action) {
            HashSet seen = Sets.newHashSet();
            for (NodeState node : this.conflict.nodes) {
                ModuleIdentifier module = node.getComponent().getId().getModule();
                if (!seen.add(module)) continue;
                action.execute(module);
            }
        }

        @Override
        public boolean hasResult() {
            return this.selected != null;
        }

        @Override
        public ComponentState getSelected() {
            return this.selected.getComponent();
        }
    }

    private static class Candidate
    implements CapabilitiesConflictHandler.Candidate {
        private final NodeState node;
        private final Capability capability;
        private final Collection<NodeState> implicitCapabilityProviders;

        public Candidate(NodeState node, Capability capability, Collection<NodeState> implicitCapabilityProviders) {
            this.node = node;
            this.capability = capability;
            this.implicitCapabilityProviders = implicitCapabilityProviders;
        }

        @Override
        public NodeState getNode() {
            return this.node;
        }

        @Override
        public Capability getCapability() {
            return this.capability;
        }

        @Override
        public Collection<NodeState> getImplicitCapabilityProviders() {
            return this.implicitCapabilityProviders;
        }
    }
}

