/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class PendingDependencies {
    private final ModuleIdentifier moduleIdentifier;
    private final Set<NodeState> affectedComponents;
    private int hardEdges;
    private boolean reportActivePending;

    PendingDependencies(ModuleIdentifier moduleIdentifier) {
        this.moduleIdentifier = moduleIdentifier;
        this.affectedComponents = Sets.newLinkedHashSet();
        this.hardEdges = 0;
        this.reportActivePending = true;
    }

    ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    void addNode(NodeState state) {
        if (this.hardEdges != 0) {
            throw new IllegalStateException("Cannot add a pending node for a dependency which is not pending");
        }
        this.affectedComponents.add(state);
        if (state.getComponent().getModule().isVirtualPlatform()) {
            this.reportActivePending = false;
        }
    }

    void turnIntoHardDependencies() {
        for (NodeState affectedComponent : this.affectedComponents) {
            affectedComponent.prepareForConstraintNoLongerPending(this.moduleIdentifier);
        }
        this.affectedComponents.clear();
        this.reportActivePending = true;
    }

    public boolean isPending() {
        return this.hardEdges == 0;
    }

    boolean hasPendingComponents() {
        return !this.affectedComponents.isEmpty();
    }

    void increaseHardEdgeCount() {
        ++this.hardEdges;
    }

    void decreaseHardEdgeCount() {
        assert (this.hardEdges > 0) : "Cannot remove a hard edge when none recorded";
        --this.hardEdges;
    }

    public boolean shouldReportActivatePending() {
        return this.reportActivePending;
    }
}

