/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.AbstractExternalModuleDependency;

public class DefaultClientModule
extends AbstractExternalModuleDependency
implements ClientModule {
    private Set<ModuleDependency> dependencies = new LinkedHashSet<ModuleDependency>();

    public DefaultClientModule(String group, String name, String version) {
        this(group, name, version, null);
    }

    public DefaultClientModule(String group, String name, String version, String configuration) {
        super(DefaultClientModule.assertModuleId(group, name), version, configuration);
    }

    @Override
    public String getId() {
        return this.emptyStringIfNull(this.getGroup()) + ":" + this.getName() + ":" + this.emptyStringIfNull(this.getVersion());
    }

    private String emptyStringIfNull(String value) {
        return value == null ? "" : value;
    }

    @Override
    public Set<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void addDependency(ModuleDependency dependency) {
        this.dependencies.add(dependency);
    }

    @Override
    public ClientModule copy() {
        DefaultClientModule copiedClientModule = new DefaultClientModule(this.getGroup(), this.getName(), this.getVersion(), this.getTargetConfiguration());
        this.copyTo(copiedClientModule);
        for (ModuleDependency dependency : this.dependencies) {
            copiedClientModule.addDependency(dependency.copy());
        }
        return copiedClientModule;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Dependency)) {
            return false;
        }
        return this.contentEquals((Dependency)o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (dependency == null || this.getClass() != dependency.getClass()) {
            return false;
        }
        ClientModule that = (ClientModule)dependency;
        return this.isContentEqualsFor(that) && this.dependencies.equals(that.getDependencies());
    }
}

