/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import icons.OpenapiIcons;
import java.io.IOException;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilderHelper;

public class MavenFrameworkSupportProvider
extends FrameworkSupportProvider {
    public MavenFrameworkSupportProvider() {
        super(MavenFrameworkSupportProvider.class.getName(), "Maven");
    }

    @NotNull
    public FrameworkSupportConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            MavenFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        return new FrameworkSupportConfigurable(){

            public JComponent getComponent() {
                return new JPanel();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel model, @Nullable Library library) {
                VirtualFile root;
                VirtualFile[] roots;
                if (module == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (model == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((roots = model.getContentRoots()).length == 0) {
                    VirtualFile moduleFile = module.getModuleFile();
                    if (moduleFile == null) return;
                    root = moduleFile.getParent();
                    model.addContentEntry(root);
                } else {
                    root = roots[0];
                }
                VirtualFile existingPom = null;
                for (VirtualFile child : root.getChildren()) {
                    if (!child.getName().startsWith("pom.")) continue;
                    existingPom = child;
                }
                if (existingPom != null) {
                    MavenProjectsManager.getInstance(module.getProject()).addManagedFilesOrUnignore(Collections.singletonList(existingPom));
                    return;
                } else {
                    MavenFrameworkSupportProvider.prepareProjectStructure(model, root);
                    new MavenModuleBuilderHelper(new MavenId("groupId", module.getName(), "1.0-SNAPSHOT"), null, null, false, false, null, null, "Add Maven Support").configure(model.getProject(), root, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider$1";
                objectArray[2] = "addSupport";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void prepareProjectStructure(@NotNull ModifiableRootModel model, @NotNull VirtualFile root) {
        VirtualFile src;
        if (model == null) {
            MavenFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        if (root == null) {
            MavenFrameworkSupportProvider.$$$reportNull$$$0(2);
        }
        if ((src = root.findChild("src")) == null || !src.isDirectory()) {
            return;
        }
        if (ArrayUtil.contains((Object)src, (Object[])model.getSourceRoots())) {
            try {
                VirtualFile java = VfsUtil.createDirectories((String)(src.getPath() + "/main/java"));
                if (java != null && java.isDirectory()) {
                    for (VirtualFile child : src.getChildren()) {
                        if (child.getName().equals("main")) continue;
                        child.move(null, java);
                    }
                }
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
    }

    public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
        if (builder == null) {
            MavenFrameworkSupportProvider.$$$reportNull$$$0(3);
        }
        return false;
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module) {
        if (module == null) {
            MavenFrameworkSupportProvider.$$$reportNull$$$0(4);
        }
        return MavenProjectsManager.getInstance(module.getProject()).isMavenizedModule(module);
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            MavenFrameworkSupportProvider.$$$reportNull$$$0(5);
        }
        return moduleType.equals((Object)StdModuleTypes.JAVA);
    }

    public Icon getIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareProjectStructure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForModuleBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportAlreadyAdded";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForModuleType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

