/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class MavenDisablePanelCheckbox
extends JCheckBox {
    private final JComponent myPanel;
    private Set<JComponent> myDisabledComponents;

    public MavenDisablePanelCheckbox(String text, @NotNull JComponent panel) {
        if (panel == null) {
            MavenDisablePanelCheckbox.$$$reportNull$$$0(0);
        }
        super(text);
        this.myPanel = panel;
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MavenDisablePanelCheckbox.this.isSelected()) {
                    if (MavenDisablePanelCheckbox.this.myDisabledComponents == null) {
                        MavenDisablePanelCheckbox.this.myDisabledComponents = new HashSet();
                        MavenDisablePanelCheckbox.this.disable(MavenDisablePanelCheckbox.this.myPanel);
                    }
                } else if (MavenDisablePanelCheckbox.this.myDisabledComponents != null) {
                    MavenDisablePanelCheckbox.this.enable(MavenDisablePanelCheckbox.this.myPanel);
                    MavenDisablePanelCheckbox.this.myDisabledComponents = null;
                }
            }
        });
    }

    private void disable(JComponent c) {
        if (c.isEnabled()) {
            this.myDisabledComponents.add(c);
            c.setEnabled(false);
        }
        for (Component component : c.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            this.disable((JComponent)component);
        }
    }

    private void enable(JComponent c) {
        if (this.myDisabledComponents.contains(c)) {
            c.setEnabled(true);
        }
        for (Component component : c.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            this.enable((JComponent)component);
        }
    }

    public static Pair<JPanel, JCheckBox> createPanel(JComponent component, String title) {
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                JBColor c = enabled ? JBColor.GRAY : JBColor.LIGHT_GRAY;
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)c), BorderFactory.createEmptyBorder(10, 0, 0, 0)));
            }
        };
        panel.setEnabled(true);
        panel.add(component);
        MavenDisablePanelCheckbox checkbox = new MavenDisablePanelCheckbox(title, panel);
        JPanel res = new JPanel(new BorderLayout(0, 10));
        res.add((Component)checkbox, "North");
        res.add((Component)panel, "Center");
        return Pair.create((Object)res, (Object)checkbox);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "org/jetbrains/idea/maven/project/MavenDisablePanelCheckbox", "<init>"));
    }
}

