/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.worktree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.workspace.api.EntitySource;
import com.intellij.workspace.api.LibraryEntity;
import com.intellij.workspace.api.LibraryId;
import com.intellij.workspace.api.LibraryRoot;
import com.intellij.workspace.api.LibraryRootTypeId;
import com.intellij.workspace.api.LibraryTableId;
import com.intellij.workspace.api.ModifiableProxyBasedImlModelEntitiesKt;
import com.intellij.workspace.api.ModuleDependencyItem;
import com.intellij.workspace.api.ModuleEntity;
import com.intellij.workspace.api.ModuleId;
import com.intellij.workspace.api.SourceRootEntity;
import com.intellij.workspace.api.TypedEntityStorageBuilder;
import com.intellij.workspace.api.TypedEntityStorageDiffBuilder;
import com.intellij.workspace.api.VirtualFileUrl;
import com.intellij.workspace.api.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenModelUtil;
import org.jetbrains.idea.maven.importing.worktree.MavenExternalSource;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0006\u0010\u001e\u001a\u00020\u001cJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/idea/maven/importing/worktree/WorkspaceModuleImporter;", "", "project", "Lcom/intellij/openapi/project/Project;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "projectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "diff", "Lcom/intellij/workspace/api/TypedEntityStorageBuilder;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lcom/intellij/workspace/api/TypedEntityStorageBuilder;)V", "moduleEntity", "Lcom/intellij/workspace/api/ModuleEntity;", "addBundleDependency", "Lcom/intellij/workspace/api/ModuleDependencyItem;", "artifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "addLibraryToProjectTable", "Lcom/intellij/workspace/api/LibraryEntity;", "collectDependencies", "", "createDependency", "createLibraryDependency", "Lcom/intellij/workspace/api/ModuleDependencyItem$Exportable$LibraryDependency;", "createModuleDependency", "depProject", "createSystemDependency", "importFolders", "", "importLanguageLevel", "importModule", "libraryExists", "", "toEntityScope", "Lcom/intellij/workspace/api/ModuleDependencyItem$DependencyScope;", "mavenScope", "", "intellij.maven"})
public final class WorkspaceModuleImporter {
    private ModuleEntity moduleEntity;
    private final Project project;
    private final MavenProject mavenProject;
    private final MavenProjectsTree projectsTree;
    private final TypedEntityStorageBuilder diff;

    public final void importModule() {
        List<ModuleDependencyItem> dependencies = this.collectDependencies();
        TypedEntityStorageDiffBuilder typedEntityStorageDiffBuilder = (TypedEntityStorageDiffBuilder)this.diff;
        String string = this.mavenProject.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mavenProject.displayName");
        this.moduleEntity = ModifiableProxyBasedImlModelEntitiesKt.addModuleEntity((TypedEntityStorageDiffBuilder)typedEntityStorageDiffBuilder, (String)string, dependencies, (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()));
        TypedEntityStorageDiffBuilder typedEntityStorageDiffBuilder2 = (TypedEntityStorageDiffBuilder)this.diff;
        String string2 = this.mavenProject.getDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"mavenProject.directory");
        VirtualFileUrl virtualFileUrl = VirtualFileUrlManager.INSTANCE.fromPath(string2);
        List list = CollectionsKt.emptyList();
        List list2 = CollectionsKt.emptyList();
        ModuleEntity moduleEntity = this.moduleEntity;
        if (moduleEntity == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"moduleEntity");
        }
        ModifiableProxyBasedImlModelEntitiesKt.addContentRootEntity((TypedEntityStorageDiffBuilder)typedEntityStorageDiffBuilder2, (VirtualFileUrl)virtualFileUrl, (List)list, (List)list2, (ModuleEntity)moduleEntity, (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()));
        this.importFolders();
        this.importLanguageLevel();
    }

    private final void importLanguageLevel() {
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModuleDependencyItem> collectDependencies() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
        MavenImportingSettings mavenImportingSettings = mavenProjectsManager.getImportingSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenImportingSettings, (String)"MavenProjectsManager.get\u2026roject).importingSettings");
        Set<String> set = mavenImportingSettings.getDependencyTypesAsSet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"MavenProjectsManager.get\u2026ings.dependencyTypesAsSet");
        Set<String> dependencyTypes = set;
        Set<String> set2 = this.mavenProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT);
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"mavenProject.getDependen\u2026edRequestType.FOR_IMPORT)");
        dependencyTypes.addAll((Collection<String>)set2);
        Collection collection = CollectionsKt.listOf((Object[])new ModuleDependencyItem[]{(ModuleDependencyItem)ModuleDependencyItem.ModuleSourceDependency.INSTANCE, (ModuleDependencyItem)ModuleDependencyItem.InheritedSdkDependency.INSTANCE});
        List<MavenArtifact> list = this.mavenProject.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"mavenProject.dependencies");
        Iterable iterable = list;
        Collection collection2 = collection;
        boolean $i$f$filter = false;
        void var4_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenArtifact it = (MavenArtifact)element$iv$iv;
            boolean bl = false;
            MavenArtifact mavenArtifact = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenArtifact, (String)"it");
            if (!dependencyTypes.contains(mavenArtifact.getType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filter$iv = list2;
        WorkspaceModuleImporter workspaceModuleImporter = this;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ModuleDependencyItem moduleDependencyItem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenArtifact p1 = (MavenArtifact)element$iv$iv;
            boolean bl2 = false;
            if (workspaceModuleImporter.createDependency(p1) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ModuleDependencyItem it$iv$iv = moduleDependencyItem;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        list2 = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)collection2, (Iterable)list2);
    }

    private final ModuleDependencyItem createDependency(MavenArtifact artifact) {
        MavenProject depProject = this.projectsTree.findProject(artifact.getMavenId());
        if (depProject == null) {
            if (Intrinsics.areEqual((Object)artifact.getScope(), (Object)"system")) {
                return (ModuleDependencyItem)this.createSystemDependency(artifact);
            }
            if (Intrinsics.areEqual((Object)artifact.getType(), (Object)"bundle")) {
                return this.addBundleDependency(artifact);
            }
            return (ModuleDependencyItem)this.createLibraryDependency(artifact);
        }
        if (depProject == this.mavenProject) {
            return null;
        }
        if (this.projectsTree.isIgnored(depProject)) {
            boolean bl = false;
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        return this.createModuleDependency(artifact, depProject);
    }

    private final ModuleDependencyItem addBundleDependency(MavenArtifact artifact) {
        MavenArtifact newArtifact = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, this.mavenProject.getLocalRepository(), false, false);
        return (ModuleDependencyItem)this.createLibraryDependency(newArtifact);
    }

    private final ModuleDependencyItem.Exportable.LibraryDependency createSystemDependency(MavenArtifact artifact) {
        boolean bl = Intrinsics.areEqual((Object)"system", (Object)artifact.getScope());
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<LibraryRoot> roots = new ArrayList<LibraryRoot>();
        String string = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, null, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MavenModelUtil.getArtifa\u2026ion(artifact, null, null)");
        roots.add(new LibraryRoot(VirtualFileUrlManager.INSTANCE.fromUrl(string), new LibraryRootTypeId("CLASSES"), LibraryRoot.InclusionOptions.ROOT_ITSELF));
        String string2 = this.mavenProject.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"mavenProject.displayName");
        LibraryTableId.ModuleLibraryTableId libraryTableId = new LibraryTableId.ModuleLibraryTableId(new ModuleId(string2));
        TypedEntityStorageDiffBuilder typedEntityStorageDiffBuilder = (TypedEntityStorageDiffBuilder)this.diff;
        String string3 = artifact.getLibraryName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"artifact.libraryName");
        ModifiableProxyBasedImlModelEntitiesKt.addLibraryEntity((TypedEntityStorageDiffBuilder)typedEntityStorageDiffBuilder, (String)string3, (LibraryTableId)((LibraryTableId)libraryTableId), (List)roots, (List)CollectionsKt.emptyList(), (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()));
        String string4 = artifact.getLibraryName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"artifact.libraryName");
        LibraryId libraryId = new LibraryId(string4, (LibraryTableId)libraryTableId);
        String string5 = artifact.getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"artifact.scope");
        return new ModuleDependencyItem.Exportable.LibraryDependency(libraryId, false, this.toEntityScope(string5));
    }

    private final ModuleDependencyItem createModuleDependency(MavenArtifact artifact, MavenProject depProject) {
        boolean isTestJar = Intrinsics.areEqual((Object)"test-jar", (Object)artifact.getType()) || Intrinsics.areEqual((Object)"tests", (Object)artifact.getClassifier());
        String string = depProject.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"depProject.displayName");
        ModuleId moduleId = new ModuleId(string);
        String string2 = artifact.getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"artifact.scope");
        return (ModuleDependencyItem)new ModuleDependencyItem.Exportable.ModuleDependency(moduleId, false, this.toEntityScope(string2), isTestJar);
    }

    private final ModuleDependencyItem.Exportable.LibraryDependency createLibraryDependency(MavenArtifact artifact) {
        boolean bl = Intrinsics.areEqual((Object)"system", (Object)artifact.getScope()) ^ true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!this.libraryExists(artifact)) {
            this.addLibraryToProjectTable(artifact);
        }
        LibraryTableId.ProjectLibraryTableId libraryTableId = LibraryTableId.ProjectLibraryTableId.INSTANCE;
        String string = artifact.getLibraryName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"artifact.libraryName");
        LibraryId libraryId = new LibraryId(string, (LibraryTableId)libraryTableId);
        String string2 = artifact.getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"artifact.scope");
        return new ModuleDependencyItem.Exportable.LibraryDependency(libraryId, false, this.toEntityScope(string2));
    }

    private final boolean libraryExists(MavenArtifact artifact) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = this.diff.entities(LibraryEntity.class);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                LibraryEntity it = (LibraryEntity)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)artifact.getLibraryName())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final LibraryEntity addLibraryToProjectTable(MavenArtifact artifact) {
        ArrayList<LibraryRoot> roots = new ArrayList<LibraryRoot>();
        String string = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, null, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MavenModelUtil.getArtifa\u2026ion(artifact, null, null)");
        roots.add(new LibraryRoot(VirtualFileUrlManager.INSTANCE.fromUrl(string), new LibraryRootTypeId("CLASSES"), LibraryRoot.InclusionOptions.ROOT_ITSELF));
        String string2 = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, "javadoc", "jar");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MavenModelUtil.getArtifa\u2026tifact, \"javadoc\", \"jar\")");
        roots.add(new LibraryRoot(VirtualFileUrlManager.INSTANCE.fromUrl(string2), new LibraryRootTypeId("JAVADOC"), LibraryRoot.InclusionOptions.ROOT_ITSELF));
        String string3 = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, "sources", "jar");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"MavenModelUtil.getArtifa\u2026tifact, \"sources\", \"jar\")");
        roots.add(new LibraryRoot(VirtualFileUrlManager.INSTANCE.fromUrl(string3), new LibraryRootTypeId("SOURCES"), LibraryRoot.InclusionOptions.ROOT_ITSELF));
        LibraryTableId.ProjectLibraryTableId libraryTableId = LibraryTableId.ProjectLibraryTableId.INSTANCE;
        TypedEntityStorageDiffBuilder typedEntityStorageDiffBuilder = (TypedEntityStorageDiffBuilder)this.diff;
        String string4 = artifact.getLibraryName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"artifact.libraryName");
        return ModifiableProxyBasedImlModelEntitiesKt.addLibraryEntity((TypedEntityStorageDiffBuilder)typedEntityStorageDiffBuilder, (String)string4, (LibraryTableId)((LibraryTableId)libraryTableId), (List)roots, (List)CollectionsKt.emptyList(), (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()));
    }

    /*
     * WARNING - void declaration
     */
    private final void importFolders() {
        Map<String, JpsModuleSourceRootType<?>> map = MavenFoldersImporter.getSourceFolders(this.mavenProject);
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"MavenFoldersImporter.get\u2026urceFolders(mavenProject)");
        Map<String, JpsModuleSourceRootType<?>> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Map<String, JpsModuleSourceRootType<?>> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, JpsModuleSourceRootType<?>>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            JpsModuleSourceRootPropertiesSerializer serializer;
            Object v4;
            Object v3;
            Object $this$firstOrNull$iv;
            Map.Entry<String, JpsModuleSourceRootType<?>> entry;
            block8: {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                Map.Entry<String, JpsModuleSourceRootType<?>> element$iv;
                entry = element$iv = iterator.next();
                boolean bl2 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)JpsModelSerializerExtension.getExtensions(), (String)"JpsModelSerializerExtension.getExtensions()");
                boolean $i$f$flatMap = false;
                Object object = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    JpsModelSerializerExtension it = (JpsModelSerializerExtension)element$iv$iv;
                    boolean bl3 = false;
                    JpsModelSerializerExtension jpsModelSerializerExtension = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jpsModelSerializerExtension, (String)"it");
                    Iterable list$iv$iv = jpsModelSerializerExtension.getModuleSourceRootPropertiesSerializers();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                object = $this$firstOrNull$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv2 = object.next();
                    JpsModuleSourceRootPropertiesSerializer it = (JpsModuleSourceRootPropertiesSerializer)element$iv2;
                    boolean bl4 = false;
                    JpsModuleSourceRootPropertiesSerializer jpsModuleSourceRootPropertiesSerializer = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jpsModuleSourceRootPropertiesSerializer, (String)"it");
                    if (!Intrinsics.areEqual((Object)((JpsModuleSourceRootType)jpsModuleSourceRootPropertiesSerializer.getType()), entry.getValue())) continue;
                    v3 = element$iv2;
                    break block8;
                }
                v3 = v4 = null;
            }
            if (!(v3 instanceof JpsModuleSourceRootPropertiesSerializer)) {
                v4 = null;
            }
            if ((JpsModuleSourceRootPropertiesSerializer)v4 == null) {
                $this$firstOrNull$iv = "Module source root type " + entry + ".value is not registered as JpsModelSerializerExtension";
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException($this$firstOrNull$iv.toString());
            }
            TypedEntityStorageDiffBuilder typedEntityStorageDiffBuilder = (TypedEntityStorageDiffBuilder)this.diff;
            ModuleEntity moduleEntity = this.moduleEntity;
            if (moduleEntity == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"moduleEntity");
            }
            String string = VfsUtilCore.pathToUrl((String)entry.getKey());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VfsUtilCore.pathToUrl(entry.key)");
            VirtualFileUrl virtualFileUrl = VirtualFileUrlManager.INSTANCE.fromUrl(string);
            JpsModuleSourceRootType<?> jpsModuleSourceRootType = entry.getValue();
            Intrinsics.checkExpressionValueIsNotNull(jpsModuleSourceRootType, (String)"entry.value");
            boolean bl6 = jpsModuleSourceRootType.isForTests();
            String string2 = serializer.getTypeId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"serializer.typeId");
            SourceRootEntity sourceRootEntity = ModifiableProxyBasedImlModelEntitiesKt.addSourceRootEntity((TypedEntityStorageDiffBuilder)typedEntityStorageDiffBuilder, (ModuleEntity)moduleEntity, (VirtualFileUrl)virtualFileUrl, (boolean)bl6, (String)string2, (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()));
            JpsModuleSourceRootType<?> jpsModuleSourceRootType2 = entry.getValue();
            if (jpsModuleSourceRootType2 instanceof JavaSourceRootType) {
                ModifiableProxyBasedImlModelEntitiesKt.addJavaSourceRootEntity((TypedEntityStorageDiffBuilder)((TypedEntityStorageDiffBuilder)this.diff), (SourceRootEntity)sourceRootEntity, (boolean)false, (String)"", (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()));
                continue;
            }
            if (jpsModuleSourceRootType2 instanceof JavaResourceRootType) {
                ModifiableProxyBasedImlModelEntitiesKt.addJavaResourceRootEntity((TypedEntityStorageDiffBuilder)((TypedEntityStorageDiffBuilder)this.diff), (SourceRootEntity)sourceRootEntity, (boolean)false, (String)"", (EntitySource)((EntitySource)MavenExternalSource.getINSTANCE()));
                continue;
            }
            boolean bl7 = false;
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
    }

    @NotNull
    public final ModuleDependencyItem.DependencyScope toEntityScope(@NotNull String mavenScope) {
        Intrinsics.checkParameterIsNotNull((Object)mavenScope, (String)"mavenScope");
        if (Intrinsics.areEqual((Object)"runtime", (Object)mavenScope)) {
            return ModuleDependencyItem.DependencyScope.RUNTIME;
        }
        if (Intrinsics.areEqual((Object)"test", (Object)mavenScope)) {
            return ModuleDependencyItem.DependencyScope.TEST;
        }
        return Intrinsics.areEqual((Object)"provided", (Object)mavenScope) ? ModuleDependencyItem.DependencyScope.PROVIDED : ModuleDependencyItem.DependencyScope.COMPILE;
    }

    public WorkspaceModuleImporter(@NotNull Project project, @NotNull MavenProject mavenProject, @NotNull MavenProjectsTree projectsTree, @NotNull TypedEntityStorageBuilder diff) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkParameterIsNotNull((Object)projectsTree, (String)"projectsTree");
        Intrinsics.checkParameterIsNotNull((Object)diff, (String)"diff");
        this.project = project;
        this.mavenProject = mavenProject;
        this.projectsTree = projectsTree;
        this.diff = diff;
    }
}

