/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ClassTypeImpl;
import com.jetbrains.jdi.CommandSender;
import com.jetbrains.jdi.FieldImpl;
import com.jetbrains.jdi.InterfaceTypeImpl;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.JNITypeParser;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.PacketStream;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.VMAction;
import com.jetbrains.jdi.VMListener;
import com.jetbrains.jdi.VMState;
import com.jetbrains.jdi.ValueContainer;
import com.jetbrains.jdi.ValueImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectReferenceImpl
extends ValueImpl
implements ObjectReference,
VMListener {
    protected final long ref;
    private ReferenceType type = null;
    private int gcDisableCount = 0;
    boolean addedListener = false;
    private static final Cache noInitCache = new Cache();
    private static final Cache markerCache = new Cache();
    private Cache cache = noInitCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableCache() {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableCache() {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.cache = markerCache;
        }
    }

    protected Cache newCache() {
        return new Cache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Cache getCache() {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            if (this.cache == noInitCache) {
                if (this.vm.state().isSuspended()) {
                    this.enableCache();
                } else {
                    this.disableCache();
                }
            }
            if (this.cache == markerCache) {
                this.cache = this.newCache();
            }
            return this.cache;
        }
    }

    protected ClassTypeImpl invokableReferenceType(Method method) {
        return (ClassTypeImpl)this.referenceType();
    }

    ObjectReferenceImpl(VirtualMachine aVm, long aRef) {
        super(aVm);
        this.ref = aRef;
    }

    protected String description() {
        return "ObjectReference " + this.uniqueID();
    }

    @Override
    public boolean vmSuspended(VMAction action) {
        this.enableCache();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean vmNotSuspended(VMAction action) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            if (this.cache != null && (this.vm.traceFlags & 0x10) != 0) {
                this.vm.printTrace("Clearing temporary cache for " + this.description());
            }
            this.disableCache();
            if (this.addedListener) {
                this.addedListener = false;
                return false;
            }
            return true;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ObjectReferenceImpl) {
            ObjectReferenceImpl other = (ObjectReferenceImpl)obj;
            return this.ref() == other.ref() && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)this.ref();
    }

    @Override
    public Type type() {
        return this.referenceType();
    }

    @Override
    public ReferenceType referenceType() {
        if (this.type == null) {
            try {
                JDWP.ObjectReference.ReferenceType rtinfo = JDWP.ObjectReference.ReferenceType.process(this.vm, this);
                this.type = this.vm.referenceType(rtinfo.typeID, rtinfo.refTypeTag);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.type;
    }

    @Override
    public Value getValue(Field sig) {
        ArrayList<Field> list = new ArrayList<Field>(1);
        list.add(sig);
        Map<Field, Value> map = this.getValues(list);
        return map.get(sig);
    }

    @Override
    public Map<Field, Value> getValues(List<? extends Field> theFields) {
        ValueImpl[] values;
        this.validateMirrors(theFields);
        ArrayList<Field> staticFields = new ArrayList<Field>(0);
        int size = theFields.size();
        ArrayList<Field> instanceFields = new ArrayList<Field>(size);
        for (int i = 0; i < size; ++i) {
            Field field = theFields.get(i);
            ((ReferenceTypeImpl)this.referenceType()).validateFieldAccess(field);
            if (field.isStatic()) {
                staticFields.add(field);
                continue;
            }
            instanceFields.add(field);
        }
        Map<Field, Value> map = staticFields.size() > 0 ? this.referenceType().getValues(staticFields) : new HashMap<Field, Value>(size);
        size = instanceFields.size();
        JDWP.ObjectReference.GetValues.Field[] queryFields = new JDWP.ObjectReference.GetValues.Field[size];
        for (int i = 0; i < size; ++i) {
            FieldImpl field = (FieldImpl)instanceFields.get(i);
            queryFields[i] = new JDWP.ObjectReference.GetValues.Field(field.ref());
        }
        try {
            values = JDWP.ObjectReference.GetValues.process((VirtualMachineImpl)this.vm, (ObjectReferenceImpl)this, (JDWP.ObjectReference.GetValues.Field[])queryFields).values;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        if (size != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        for (int i = 0; i < size; ++i) {
            FieldImpl field = (FieldImpl)instanceFields.get(i);
            map.put(field, values[i]);
        }
        return map;
    }

    @Override
    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        block6: {
            this.validateMirror(field);
            this.validateMirrorOrNull(value);
            ((ReferenceTypeImpl)this.referenceType()).validateFieldSet(field);
            if (field.isStatic()) {
                ReferenceType type = this.referenceType();
                if (type instanceof ClassType) {
                    ((ClassType)type).setValue(field, value);
                    return;
                }
                throw new IllegalArgumentException("Invalid type for static field set");
            }
            try {
                JDWP.ObjectReference.SetValues.FieldValue[] fvals = new JDWP.ObjectReference.SetValues.FieldValue[]{new JDWP.ObjectReference.SetValues.FieldValue(((FieldImpl)field).ref(), ObjectReferenceImpl.prepareForAssignment(value, (FieldImpl)field))};
                try {
                    JDWP.ObjectReference.SetValues.process(this.vm, this, fvals);
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
            }
            catch (ClassNotLoadedException e) {
                if (value == null) break block6;
                throw e;
            }
        }
    }

    void validateMethodInvocation(Method method, int options) throws InvalidTypeException {
        ReferenceTypeImpl declType = (ReferenceTypeImpl)method.declaringType();
        if (!declType.isAssignableFrom(this)) {
            throw new IllegalArgumentException("Invalid method");
        }
        if (declType instanceof ClassTypeImpl) {
            this.validateClassMethodInvocation(method, options);
        } else if (declType instanceof InterfaceTypeImpl) {
            this.validateIfaceMethodInvocation(method, options);
        } else {
            throw new InvalidTypeException();
        }
    }

    void validateClassMethodInvocation(Method method, int options) {
        if (method.isConstructor()) {
            throw new IllegalArgumentException("Cannot invoke constructor");
        }
        if (ObjectReferenceImpl.isNonVirtual(options) && method.isAbstract()) {
            throw new IllegalArgumentException("Abstract method");
        }
    }

    void validateIfaceMethodInvocation(Method method, int options) {
        if (ObjectReferenceImpl.isNonVirtual(options) && method.isAbstract()) {
            throw new IllegalArgumentException("Abstract method");
        }
    }

    PacketStream sendInvokeCommand(ThreadReferenceImpl thread, ClassTypeImpl refType, MethodImpl method, ValueImpl[] args, int options) {
        CommandSender sender = () -> JDWP.ObjectReference.InvokeMethod.enqueueCommand(this.vm, this, thread, refType, method.ref(), args, options);
        PacketStream stream = (options & 1) != 0 ? thread.sendResumingCommand(sender) : this.vm.sendResumingCommand(sender);
        return stream;
    }

    @Override
    public Value invokeMethod(ThreadReference threadIntf, Method methodIntf, List<? extends Value> origArguments, int options) throws InvalidTypeException, IncompatibleThreadStateException, InvocationException, ClassNotLoadedException {
        JDWP.ObjectReference.InvokeMethod ret;
        this.validateMirror(threadIntf);
        this.validateMirror(methodIntf);
        this.validateMirrorsOrNulls(origArguments);
        MethodImpl method = (MethodImpl)methodIntf;
        ThreadReferenceImpl thread = (ThreadReferenceImpl)threadIntf;
        if (method.isStatic()) {
            if (this.referenceType() instanceof InterfaceType) {
                InterfaceType type = (InterfaceType)this.referenceType();
                return type.invokeMethod(thread, method, origArguments, options);
            }
            if (this.referenceType() instanceof ClassType) {
                ClassType type = (ClassType)this.referenceType();
                return type.invokeMethod(thread, method, origArguments, options);
            }
            throw new IllegalArgumentException("Invalid type for static method invocation");
        }
        this.validateMethodInvocation(method, options);
        List<Value> arguments = method.validateAndPrepareArgumentsForInvoke(origArguments);
        ValueImpl[] args = arguments.toArray(new ValueImpl[0]);
        try {
            PacketStream stream = this.sendInvokeCommand(thread, this.invokableReferenceType(method), method, args, options);
            ret = JDWP.ObjectReference.InvokeMethod.waitForReply(this.vm, stream);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw exc.toJDIException();
        }
        if ((options & 1) == 0) {
            this.vm.notifySuspend();
        }
        if (ret.exception != null) {
            throw new InvocationException(ret.exception);
        }
        return ret.returnValue;
    }

    @Override
    public synchronized void disableCollection() {
        if (this.gcDisableCount == 0) {
            try {
                JDWP.ObjectReference.DisableCollection.process(this.vm, this);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        ++this.gcDisableCount;
    }

    @Override
    public synchronized void enableCollection() {
        block3: {
            --this.gcDisableCount;
            if (this.gcDisableCount == 0) {
                try {
                    JDWP.ObjectReference.EnableCollection.process(this.vm, this);
                }
                catch (JDWPException exc) {
                    if (exc.errorCode() == 20) break block3;
                    throw exc.toJDIException();
                }
            }
        }
    }

    @Override
    public boolean isCollected() {
        try {
            return JDWP.ObjectReference.IsCollected.process((VirtualMachineImpl)this.vm, (ObjectReferenceImpl)this).isCollected;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public long uniqueID() {
        return this.ref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JDWP.ObjectReference.MonitorInfo jdwpMonitorInfo() throws IncompatibleThreadStateException {
        JDWP.ObjectReference.MonitorInfo info = null;
        try {
            Cache local;
            VMState vMState = this.vm.state();
            synchronized (vMState) {
                local = this.getCache();
                if (local != null && (info = local.monitorInfo) == null && !this.vm.state().hasListener(this)) {
                    this.vm.state().addListener(this);
                    this.addedListener = true;
                }
            }
            if (info == null) {
                info = JDWP.ObjectReference.MonitorInfo.process(this.vm, this);
                if (local != null) {
                    local.monitorInfo = info;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace("ObjectReference " + this.uniqueID() + " temporarily caching monitor info");
                    }
                }
            }
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 13) {
                throw new IncompatibleThreadStateException();
            }
            throw exc.toJDIException();
        }
        return info;
    }

    @Override
    public List<ThreadReference> waitingThreads() throws IncompatibleThreadStateException {
        return Arrays.asList(this.jdwpMonitorInfo().waiters);
    }

    @Override
    public ThreadReference owningThread() throws IncompatibleThreadStateException {
        return this.jdwpMonitorInfo().owner;
    }

    @Override
    public int entryCount() throws IncompatibleThreadStateException {
        return this.jdwpMonitorInfo().entryCount;
    }

    @Override
    public List<ObjectReference> referringObjects(long maxReferrers) {
        if (!this.vm.canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting referring objects");
        }
        if (maxReferrers < 0L) {
            throw new IllegalArgumentException("maxReferrers is less than zero: " + maxReferrers);
        }
        int intMax = maxReferrers > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxReferrers;
        try {
            return Arrays.asList(JDWP.ObjectReference.ReferringObjects.process((VirtualMachineImpl)this.vm, (ObjectReferenceImpl)this, (int)intMax).referringObjects);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    long ref() {
        return this.ref;
    }

    boolean isClassObject() {
        return this.referenceType().name().equals("java.lang.Class");
    }

    @Override
    ValueImpl prepareForAssignmentTo(ValueContainer destination) throws InvalidTypeException, ClassNotLoadedException {
        this.validateAssignment(destination);
        return this;
    }

    void validateAssignment(ValueContainer destination) throws InvalidTypeException, ClassNotLoadedException {
        if (destination.signature().length() == 1) {
            throw new InvalidTypeException("Can't assign object value to primitive");
        }
        if (destination.signature().charAt(0) == '[' && this.type().signature().charAt(0) != '[') {
            throw new InvalidTypeException("Can't assign non-array value to an array");
        }
        if ("void".equals(destination.typeName())) {
            throw new InvalidTypeException("Can't assign object value to a void");
        }
        ReferenceTypeImpl destType = (ReferenceTypeImpl)destination.type();
        ReferenceTypeImpl myType = (ReferenceTypeImpl)this.referenceType();
        if (!myType.isAssignableTo(destType)) {
            JNITypeParser parser = new JNITypeParser(destType.signature());
            String destTypeName = parser.typeName();
            throw new InvalidTypeException("Can't assign " + this.type().name() + " to " + destTypeName);
        }
    }

    @Override
    public String toString() {
        return "instance of " + this.referenceType().name() + "(id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 76;
    }

    private static boolean isNonVirtual(int options) {
        return (options & 2) != 0;
    }

    protected static class Cache {
        JDWP.ObjectReference.MonitorInfo monitorInfo = null;

        protected Cache() {
        }
    }
}

