/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.labels;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBRectangle;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Set;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkLabel<T>
extends JLabel {
    protected boolean myUnderline;
    private LinkListener<T> myLinkListener;
    private T myLinkData;
    private static final Set<String> ourVisitedLinks = new THashSet();
    private boolean myIsLinkActive;
    private final String myVisitedLinksKey;
    private Icon myHoveringIcon;
    private Icon myInactiveIcon;
    private boolean myClickIsBeingProcessed;
    protected boolean myPaintUnderline = true;
    private final JBRectangle iconR = new JBRectangle();
    private final JBRectangle textR = new JBRectangle();
    private final JBRectangle viewR = new JBRectangle();

    public LinkLabel() {
        this("", AllIcons.Ide.Link);
    }

    public LinkLabel(@Nls String text, @Nullable Icon icon) {
        this(text, icon, null, null, null);
    }

    public LinkLabel(@Nls String text, @Nullable Icon icon, @Nullable LinkListener<T> aListener) {
        this(text, icon, aListener, null, null);
    }

    @NotNull
    public static LinkLabel<?> create(@Nullable @Nls String text, final @Nullable Runnable action) {
        return new LinkLabel<Object>(text, null, action == null ? null : new LinkListener<Object>(){

            @Override
            public void linkSelected(LinkLabel source, Object linkData) {
                action.run();
            }
        }, null, null);
    }

    public LinkLabel(@Nls String text, @Nullable Icon icon, @Nullable LinkListener<T> aListener, @Nullable T aLinkData) {
        this(text, icon, aListener, aLinkData, null);
    }

    public LinkLabel(@Nls String text, @Nullable Icon icon, @Nullable LinkListener<T> aListener, @Nullable T aLinkData, @Nullable String aVisitedLinksKey) {
        super(text, icon, 2);
        this.setOpaque(false);
        this.setFocusable(ScreenReader.isActive());
        this.setListener(aListener, aLinkData);
        this.myInactiveIcon = this.getIcon();
        MyMouseHandler mouseHandler = new MyMouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                    e.consume();
                    LinkLabel.this.doClick();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                LinkLabel.this.myUnderline = true;
                LinkLabel.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                LinkLabel.this.myUnderline = false;
                LinkLabel.this.repaint();
            }
        });
        this.myVisitedLinksKey = aVisitedLinksKey;
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this.myInactiveIcon = icon;
    }

    public void setHoveringIcon(Icon iconForHovering) {
        this.myHoveringIcon = iconForHovering;
    }

    public void setListener(LinkListener<T> listener2, @Nullable T linkData) {
        this.myLinkListener = listener2;
        this.myLinkData = linkData;
    }

    public T getLinkData() {
        return this.myLinkData;
    }

    public void doClick() {
        if (this.myClickIsBeingProcessed) {
            return;
        }
        try {
            this.myClickIsBeingProcessed = true;
            if (this.myLinkListener != null) {
                this.myLinkListener.linkSelected(this, this.myLinkData);
            }
            if (this.myVisitedLinksKey != null) {
                ourVisitedLinks.add(this.myVisitedLinksKey);
            }
            this.repaint();
        }
        finally {
            this.myClickIsBeingProcessed = false;
        }
    }

    public boolean isVisited() {
        return this.myVisitedLinksKey != null && ourVisitedLinks.contains(this.myVisitedLinksKey);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.setForeground(this.getTextColor());
        super.paintComponent(g);
        if (this.getText() != null) {
            g.setColor(this.getTextColor());
            if (this.myUnderline && this.myPaintUnderline) {
                Rectangle bounds = this.getTextBounds();
                int lineY = this.getUI().getBaseline(this, this.getWidth(), this.getHeight()) + 1;
                g.drawLine(bounds.x, lineY, bounds.x + bounds.width, lineY);
            }
            if (this.isFocusOwner()) {
                g.setColor(UIUtil.getTreeSelectionBorderColor());
                UIUtil.drawLabelDottedRectangle((JLabel)this, (Graphics)g, (Rectangle)this.getTextBounds());
            }
        }
    }

    @NotNull
    protected Rectangle getTextBounds() {
        if (this.textR.isEmpty()) {
            this.updateLayoutRectangles();
        }
        JBRectangle jBRectangle = this.textR;
        if (jBRectangle == null) {
            LinkLabel.$$$reportNull$$$0(0);
        }
        return jBRectangle;
    }

    protected Color getTextColor() {
        return this.myIsLinkActive ? this.getActive() : (this.myUnderline ? this.getHover() : (this.isVisited() ? this.getVisited() : this.getNormal()));
    }

    public void setPaintUnderline(boolean paintUnderline) {
        this.myPaintUnderline = paintUnderline;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            this.disableUnderline();
        }
    }

    private void setActive(boolean isActive) {
        this.myIsLinkActive = isActive;
        this.onSetActive(this.myIsLinkActive);
        this.repaint();
    }

    protected void onSetActive(boolean active) {
    }

    protected boolean isInClickableArea(Point pt) {
        this.updateLayoutRectangles();
        if (this.getIcon() != null) {
            this.iconR.width += this.getIconTextGap();
            if (this.iconR.contains(pt)) {
                return true;
            }
        }
        return this.textR.contains(pt);
    }

    private void updateLayoutRectangles() {
        this.iconR.clear();
        this.textR.clear();
        Insets insets = this.getInsets(null);
        this.viewR.x = insets.left;
        this.viewR.y = insets.top;
        this.viewR.width = this.getWidth() - (insets.left + insets.right);
        this.viewR.height = this.getHeight() - (insets.top + insets.bottom);
        SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), this.getText(), this.isEnabled() ? this.getIcon() : this.getDisabledIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), (Rectangle)this.viewR, (Rectangle)this.iconR, (Rectangle)this.textR, this.getIconTextGap());
    }

    public Point getTextRectangleCenter() {
        this.isInClickableArea(new Point(0, 0));
        return new Point(this.textR.x + this.textR.width / 2, this.textR.y + this.textR.height / 2);
    }

    private void enableUnderline() {
        UIUtil.setCursor((Component)this, (Cursor)Cursor.getPredefinedCursor(12));
        this.myUnderline = true;
        if (this.myHoveringIcon != null) {
            super.setIcon(this.myHoveringIcon);
        }
        LinkLabel.setStatusBarText(this.getStatusBarText());
        this.repaint();
    }

    protected String getStatusBarText() {
        return this.getToolTipText();
    }

    private void disableUnderline() {
        UIUtil.setCursor((Component)this, (Cursor)Cursor.getDefaultCursor());
        this.myUnderline = false;
        super.setIcon(this.myInactiveIcon);
        LinkLabel.setStatusBarText(null);
        this.setActive(false);
    }

    private static void setStatusBarText(String statusBarText) {
        Project[] projects;
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            StatusBar.Info.set(statusBarText, project);
        }
    }

    public static void clearVisitedHistory() {
        ourVisitedLinks.clear();
    }

    protected Color getVisited() {
        return JBUI.CurrentTheme.Link.linkVisitedColor();
    }

    protected Color getActive() {
        return JBUI.CurrentTheme.Link.linkPressedColor();
    }

    protected Color getNormal() {
        return JBUI.CurrentTheme.Link.linkColor();
    }

    protected Color getHover() {
        return JBUI.CurrentTheme.Link.linkHoverColor();
    }

    public void entered(MouseEvent e) {
        this.enableUnderline();
    }

    public void exited(MouseEvent e) {
        this.disableUnderline();
    }

    public void pressed(MouseEvent e) {
        this.doClick(e);
    }

    public void doClick(InputEvent e) {
        this.doClick();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleLinkLabel();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/labels/LinkLabel", "getTextBounds"));
    }

    protected class AccessibleLinkLabel
    extends JLabel.AccessibleJLabel
    implements AccessibleAction {
        protected AccessibleLinkLabel() {
            super(LinkLabel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.HYPERLINK;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            if (i == 0) {
                return UIManager.getString("AbstractButton.clickText");
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (i == 0) {
                LinkLabel.this.doClick();
                return true;
            }
            return false;
        }
    }

    private class MyMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private MyMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (LinkLabel.this.isEnabled() && LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.setActive(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (LinkLabel.this.isEnabled() && LinkLabel.this.myIsLinkActive && LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.doClick(e);
            }
            LinkLabel.this.setActive(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (LinkLabel.this.isEnabled() && LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.enableUnderline();
            } else {
                LinkLabel.this.disableUnderline();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            LinkLabel.this.disableUnderline();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }
}

