/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBarInfo;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StatusBar
extends StatusBarInfo,
Disposable {
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void addWidget(@NotNull StatusBarWidget var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void addWidget(@NotNull StatusBarWidget var1, @NotNull String var2);

    @ApiStatus.Internal
    public void addWidget(@NotNull StatusBarWidget var1, @NotNull Disposable var2);

    @ApiStatus.Internal
    public void addWidget(@NotNull StatusBarWidget var1, @NotNull String var2, @NotNull Disposable var3);

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void addCustomIndicationComponent(@NotNull JComponent var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void removeCustomIndicationComponent(@NotNull JComponent var1);

    @ApiStatus.Internal
    public void removeWidget(@NotNull String var1);

    public void updateWidget(@NotNull String var1);

    @Nullable
    public StatusBarWidget getWidget(@NonNls String var1);

    public void fireNotificationPopup(@NotNull JComponent var1, Color var2);

    @Nullable
    public StatusBar createChild(@NotNull IdeFrame var1);

    public JComponent getComponent();

    public StatusBar findChild(Component var1);

    @Nullable
    public IdeFrame getFrame();

    @Nullable
    public Project getProject();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    default public StatusBar createChild() {
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    default public void install(@NotNull IdeFrame frame) {
        if (frame == null) {
            StatusBar.$$$reportNull$$$0(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/openapi/wm/StatusBar", "install"));
    }

    public static final class StandardWidgets {
        public static final String ENCODING_PANEL = "Encoding";
        public static final String COLUMN_SELECTION_MODE_PANEL = "InsertOverwrite";
        public static final String READONLY_ATTRIBUTE_PANEL = "ReadOnlyAttribute";
        public static final String POSITION_PANEL = "Position";
        public static final String LINE_SEPARATOR_PANEL = "LineSeparator";
    }

    public static final class Anchors {
        public static final String DEFAULT_ANCHOR = Anchors.after("InsertOverwrite");

        public static String before(String widgetId) {
            return "before " + widgetId;
        }

        public static String after(String widgetId) {
            return "after " + widgetId;
        }
    }

    public static abstract class Info
    implements StatusBarInfo {
        public static final Topic<StatusBarInfo> TOPIC = Topic.create((String)"IdeStatusBar.Text", StatusBarInfo.class);

        private Info() {
        }

        public static void set(@Nullable String text, @Nullable Project project) {
            Info.set(text, project, null);
        }

        public static void set(@Nullable String text, @Nullable Project project, @Nullable String requestor) {
            if (project != null) {
                if (project.isDisposed()) {
                    return;
                }
                if (!project.isInitialized()) {
                    StartupManager.getInstance(project).runWhenProjectIsInitialized(() -> ((StatusBarInfo)project.getMessageBus().syncPublisher(TOPIC)).setInfo(text, requestor));
                    return;
                }
            }
            MessageBus bus = project == null ? ApplicationManager.getApplication().getMessageBus() : project.getMessageBus();
            ((StatusBarInfo)bus.syncPublisher(TOPIC)).setInfo(text, requestor);
        }
    }
}

