/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.FocusUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreeComponentsSplitter
extends JPanel
implements Disposable {
    private static final Icon SplitGlueV = EmptyIcon.create((int)17, (int)6);
    private int myDividerWidth;
    private boolean myVerticalSplit;
    private boolean myHonorMinimumSize;
    private final Divider myFirstDivider;
    private final Divider myLastDivider;
    private EventDispatcher<ComponentListener> myDividerDispatcher;
    @Nullable
    private JComponent myFirstComponent;
    @Nullable
    private JComponent myInnerComponent;
    @Nullable
    private JComponent myLastComponent;
    private int myFirstSize;
    private int myLastSize;
    private int myMinSize;
    private boolean myShowDividerControls;
    private int myDividerZone;

    public ThreeComponentsSplitter(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ThreeComponentsSplitter.$$$reportNull$$$0(0);
        }
        this(false, parentDisposable);
    }

    @Deprecated
    public ThreeComponentsSplitter() {
        this(false, false, null, true);
    }

    public ThreeComponentsSplitter(boolean vertical, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ThreeComponentsSplitter.$$$reportNull$$$0(1);
        }
        this(vertical, false, parentDisposable);
    }

    @Deprecated
    public ThreeComponentsSplitter(boolean vertical) {
        this(vertical, false, null, true);
    }

    public ThreeComponentsSplitter(boolean vertical, boolean onePixelDividers, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ThreeComponentsSplitter.$$$reportNull$$$0(2);
        }
        this(vertical, onePixelDividers, parentDisposable, true);
    }

    @Deprecated
    public ThreeComponentsSplitter(boolean vertical, boolean onePixelDividers) {
        this(vertical, onePixelDividers, null, true);
    }

    private ThreeComponentsSplitter(boolean vertical, boolean onePixelDividers, @Nullable Disposable parentDisposable, boolean __) {
        this.myHonorMinimumSize = false;
        this.myFirstSize = 0;
        this.myLastSize = 0;
        this.myMinSize = 0;
        this.myVerticalSplit = vertical;
        this.myShowDividerControls = false;
        this.myFirstDivider = new Divider(true, onePixelDividers, parentDisposable == null ? this : parentDisposable);
        this.myLastDivider = new Divider(false, onePixelDividers, parentDisposable == null ? this : parentDisposable);
        int n = this.myDividerWidth = onePixelDividers ? 1 : 7;
        if (onePixelDividers) {
            Color bg = UIUtil.CONTRAST_BORDER_COLOR;
            this.myFirstDivider.setBackground(bg);
            this.myLastDivider.setBackground(bg);
        }
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.setOpaque(false);
        this.add(this.myFirstDivider);
        this.add(this.myLastDivider);
    }

    public void setShowDividerControls(boolean showDividerControls) {
        this.myShowDividerControls = showDividerControls;
        this.setOrientation(this.myVerticalSplit);
    }

    public void setDividerMouseZoneSize(int size) {
        this.myDividerZone = JBUIScale.scale((int)size);
    }

    public boolean isHonorMinimumSize() {
        return this.myHonorMinimumSize;
    }

    public void setHonorComponentsMinimumSize(boolean honorMinimumSize) {
        this.myHonorMinimumSize = honorMinimumSize;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.firstVisible() || this.innerVisible() || this.lastVisible());
    }

    private boolean lastVisible() {
        return !Splitter.isNull((Component)this.myLastComponent) && this.myLastComponent.isVisible();
    }

    private boolean innerVisible() {
        return !Splitter.isNull((Component)this.myInnerComponent) && this.myInnerComponent.isVisible();
    }

    private boolean firstVisible() {
        return !Splitter.isNull((Component)this.myFirstComponent) && this.myFirstComponent.isVisible();
    }

    private int visibleDividersCount() {
        int count = 0;
        if (this.firstDividerVisible()) {
            ++count;
        }
        if (this.lastDividerVisible()) {
            ++count;
        }
        return count;
    }

    private boolean firstDividerVisible() {
        return this.firstVisible() && this.innerVisible() || this.firstVisible() && this.lastVisible() && !this.innerVisible();
    }

    private boolean lastDividerVisible() {
        return this.innerVisible() && this.lastVisible();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isHonorMinimumSize()) {
            JBDimension innerSize;
            int dividerWidth = this.getDividerWidth();
            JBDimension firstSize = this.myFirstComponent != null ? this.myFirstComponent.getMinimumSize() : JBUI.emptySize();
            JBDimension lastSize = this.myLastComponent != null ? this.myLastComponent.getMinimumSize() : JBUI.emptySize();
            Object object = innerSize = this.myInnerComponent != null ? this.myInnerComponent.getMinimumSize() : JBUI.emptySize();
            if (this.getOrientation()) {
                int width = Math.max(firstSize.width, Math.max(lastSize.width, innerSize.width));
                int height = this.visibleDividersCount() * dividerWidth;
                height += firstSize.height;
                height += lastSize.height;
                return new Dimension(width, height += innerSize.height);
            }
            int height = Math.max(firstSize.height, Math.max(lastSize.height, innerSize.height));
            int width = this.visibleDividersCount() * dividerWidth;
            width += firstSize.width;
            width += lastSize.width;
            return new Dimension(width += innerSize.width, height);
        }
        return super.getMinimumSize();
    }

    @Override
    public void doLayout() {
        int innerComponentSize;
        int lastComponentSize;
        int firstComponentSize;
        int width = this.getWidth();
        int height = this.getHeight();
        Rectangle firstRect = new Rectangle();
        Rectangle firstDividerRect = new Rectangle();
        Rectangle lastDividerRect = new Rectangle();
        Rectangle lastRect = new Rectangle();
        Rectangle innerRect = new Rectangle();
        int componentSize = this.getOrientation() ? height : width;
        int dividerWidth = this.getDividerWidth();
        int dividersCount = this.visibleDividersCount();
        if (componentSize <= dividersCount * dividerWidth) {
            firstComponentSize = 0;
            lastComponentSize = 0;
            innerComponentSize = 0;
            dividerWidth = componentSize;
        } else {
            firstComponentSize = this.getFirstSize();
            int sizeLack = firstComponentSize + (lastComponentSize = this.getLastSize()) - (componentSize - dividersCount * dividerWidth - this.myMinSize);
            if (sizeLack > 0) {
                double firstSizeRatio = (double)firstComponentSize / (double)(firstComponentSize + lastComponentSize);
                if (firstComponentSize > 0) {
                    firstComponentSize = (int)((double)firstComponentSize - (double)sizeLack * firstSizeRatio);
                    firstComponentSize = Math.max(this.myMinSize, firstComponentSize);
                }
                if (lastComponentSize > 0) {
                    lastComponentSize = (int)((double)lastComponentSize - (double)sizeLack * (1.0 - firstSizeRatio));
                    lastComponentSize = Math.max(this.myMinSize, lastComponentSize);
                }
                innerComponentSize = this.getMinSize(this.myInnerComponent);
            } else {
                innerComponentSize = Math.max(this.getMinSize(this.myInnerComponent), componentSize - dividersCount * dividerWidth - this.getFirstSize() - this.getLastSize());
            }
            if (!this.innerVisible()) {
                lastComponentSize += innerComponentSize;
                innerComponentSize = 0;
                if (!this.lastVisible()) {
                    firstComponentSize = componentSize;
                }
            }
        }
        int space = firstComponentSize;
        if (this.getOrientation()) {
            firstRect.setBounds(0, 0, width, firstComponentSize);
            if (this.firstDividerVisible()) {
                firstDividerRect.setBounds(0, space, width, dividerWidth);
                space += dividerWidth;
            }
            innerRect.setBounds(0, space, width, innerComponentSize);
            space += innerComponentSize;
            if (this.lastDividerVisible()) {
                lastDividerRect.setBounds(0, space, width, dividerWidth);
                space += dividerWidth;
            }
            lastRect.setBounds(0, space, width, lastComponentSize);
        } else {
            firstRect.setBounds(0, 0, firstComponentSize, height);
            if (this.firstDividerVisible()) {
                firstDividerRect.setBounds(space, 0, dividerWidth, height);
                space += dividerWidth;
            }
            innerRect.setBounds(space, 0, innerComponentSize, height);
            space += innerComponentSize;
            if (this.lastDividerVisible()) {
                lastDividerRect.setBounds(space, 0, dividerWidth, height);
                space += dividerWidth;
            }
            lastRect.setBounds(space, 0, lastComponentSize, height);
        }
        this.myFirstDivider.setVisible(this.firstDividerVisible());
        this.myFirstDivider.setBounds(firstDividerRect);
        this.myFirstDivider.doLayout();
        this.myLastDivider.setVisible(this.lastDividerVisible());
        this.myLastDivider.setBounds(lastDividerRect);
        this.myLastDivider.doLayout();
        ThreeComponentsSplitter.validateIfNeeded(this.myFirstComponent, firstRect);
        ThreeComponentsSplitter.validateIfNeeded(this.myInnerComponent, innerRect);
        ThreeComponentsSplitter.validateIfNeeded(this.myLastComponent, lastRect);
    }

    private static void validateIfNeeded(JComponent c, Rectangle rect) {
        if (!Splitter.isNull((Component)c)) {
            if (!c.getBounds().equals(rect)) {
                c.setBounds(rect);
                c.revalidate();
            }
        } else {
            Splitter.hideNull((Component)c);
        }
    }

    public int getDividerWidth() {
        return this.myDividerWidth;
    }

    public void setDividerWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Wrong divider width: " + width);
        }
        if (this.myDividerWidth != width) {
            this.myDividerWidth = width;
            this.doLayout();
            this.repaint();
        }
    }

    public boolean getOrientation() {
        return this.myVerticalSplit;
    }

    public void setOrientation(boolean verticalSplit) {
        this.myVerticalSplit = verticalSplit;
        this.myFirstDivider.setOrientation(verticalSplit);
        this.myLastDivider.setOrientation(verticalSplit);
        this.doLayout();
        this.repaint();
    }

    @Nullable
    public JComponent getFirstComponent() {
        return this.myFirstComponent;
    }

    public void setFirstComponent(@Nullable JComponent component) {
        if (this.myFirstComponent == component) {
            return;
        }
        if (this.myFirstComponent != null) {
            this.remove(this.myFirstComponent);
        }
        this.myFirstComponent = component;
        this.doAddComponent(component);
    }

    @Nullable
    public JComponent getLastComponent() {
        return this.myLastComponent;
    }

    public void setLastComponent(@Nullable JComponent component) {
        if (this.myLastComponent == component) {
            return;
        }
        if (this.myLastComponent != null) {
            this.remove(this.myLastComponent);
        }
        this.myLastComponent = component;
        this.doAddComponent(component);
    }

    @Nullable
    public JComponent getInnerComponent() {
        return this.myInnerComponent;
    }

    private static void updateComponentTreeUI(@Nullable JComponent rootComponent) {
        for (Component component : UIUtil.uiTraverser((Component)rootComponent).postOrderDfsTraversal()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).updateUI();
        }
    }

    public void setInnerComponent(@Nullable JComponent component) {
        if (this.myInnerComponent == component) {
            return;
        }
        if (this.myInnerComponent != null) {
            this.remove(this.myInnerComponent);
        }
        this.myInnerComponent = component;
        this.doAddComponent(component);
    }

    private void doAddComponent(@Nullable JComponent component) {
        if (component != null) {
            ThreeComponentsSplitter.updateComponentTreeUI(component);
            this.add(component);
            component.invalidate();
        }
    }

    public void setMinSize(int minSize) {
        this.myMinSize = Math.max(0, minSize);
        this.doLayout();
        this.repaint();
    }

    public void setFirstSize(int size) {
        int oldSize = this.myFirstSize;
        this.myFirstSize = Math.max(this.getMinSize(true), size);
        if (this.firstVisible() && oldSize != this.myFirstSize) {
            this.doLayout();
            this.repaint();
        }
    }

    public void setLastSize(int size) {
        int oldSize = this.myLastSize;
        this.myLastSize = Math.max(this.getMinSize(false), size);
        if (this.lastVisible() && oldSize != this.myLastSize) {
            this.doLayout();
            this.repaint();
        }
    }

    public int getFirstSize() {
        return this.firstVisible() ? this.myFirstSize : 0;
    }

    public int getLastSize() {
        return this.lastVisible() ? this.myLastSize : 0;
    }

    public int getMinSize(boolean first) {
        return this.getMinSize(first ? this.myFirstComponent : this.myLastComponent);
    }

    public int getMaxSize(boolean first) {
        int size = this.getOrientation() ? this.getHeight() : this.getWidth();
        return size - (first ? this.myLastSize : this.myFirstSize) - this.myMinSize;
    }

    private int getMinSize(JComponent component) {
        if (this.isHonorMinimumSize() && component != null && component.isVisible()) {
            return this.getOrientation() ? component.getMinimumSize().height : component.getMinimumSize().width;
        }
        return this.myMinSize;
    }

    public void addDividerResizeListener(@NotNull ComponentListener listener2) {
        if (listener2 == null) {
            ThreeComponentsSplitter.$$$reportNull$$$0(3);
        }
        if (this.myDividerDispatcher == null) {
            this.myDividerDispatcher = EventDispatcher.create(ComponentListener.class);
        }
        this.myDividerDispatcher.addListener((EventListener)listener2);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/ThreeComponentsSplitter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addDividerResizeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class Divider
    extends JPanel {
        private final boolean myIsOnePixel;
        private boolean myDragging;
        private Point myPoint;
        private final boolean myIsFirst;
        private IdeGlassPane myGlassPane;
        private final MouseAdapter myListener;
        private boolean myWasPressedOnMe;

        private MouseEvent getTargetEvent(@NotNull MouseEvent e) {
            if (e == null) {
                Divider.$$$reportNull$$$0(0);
            }
            return SwingUtilities.convertMouseEvent(e.getComponent(), e, this);
        }

        Divider(boolean isFirst, @NotNull boolean isOnePixel, final Disposable parentDisposable) {
            if (parentDisposable == null) {
                Divider.$$$reportNull$$$0(1);
            }
            super(new GridBagLayout());
            this.myListener = new MyMouseAdapter();
            this.myIsOnePixel = isOnePixel;
            this.setFocusable(false);
            this.enableEvents(48L);
            this.myIsFirst = isFirst;
            this.setOrientation(ThreeComponentsSplitter.this.myVerticalSplit);
            new UiNotifyConnector.Once(this, new Activatable(){

                @Override
                public void showNotify() {
                    Divider.this.init(parentDisposable);
                }
            });
        }

        private boolean isInside(Point p) {
            int dndOff;
            if (!this.isVisible()) {
                return false;
            }
            Window window = ComponentUtil.getWindow((Component)this);
            if (window != null) {
                List<Component> components;
                Point point = SwingUtilities.convertPoint(this, p, window);
                Component component = UIUtil.getDeepestComponentAt((Component)window, (int)point.x, (int)point.y);
                if (ComponentUtil.findParentByCondition((Component)component, arg_0 -> Divider.lambda$isInside$0(components = Arrays.asList(ThreeComponentsSplitter.this.myFirstComponent, ThreeComponentsSplitter.this.myFirstDivider, ThreeComponentsSplitter.this.myInnerComponent, ThreeComponentsSplitter.this.myLastDivider, ThreeComponentsSplitter.this.myLastComponent), arg_0)) == null) {
                    return false;
                }
            }
            int n = dndOff = this.myIsOnePixel ? JBUIScale.scale((int)Registry.intValue((String)"ide.splitter.mouseZone")) / 2 : 0;
            if (ThreeComponentsSplitter.this.myVerticalSplit) {
                if (p.x >= 0 && p.x < this.getWidth()) {
                    if (this.getHeight() > 0) {
                        return p.y >= -dndOff && p.y < this.getHeight() + dndOff;
                    }
                    return p.y >= -ThreeComponentsSplitter.this.myDividerZone / 2 && p.y <= ThreeComponentsSplitter.this.myDividerZone / 2;
                }
            } else if (p.y >= 0 && p.y < this.getHeight()) {
                if (this.getWidth() > 0) {
                    return p.x >= -dndOff && p.x < this.getWidth() + dndOff;
                }
                return p.x >= -ThreeComponentsSplitter.this.myDividerZone / 2 && p.x <= ThreeComponentsSplitter.this.myDividerZone / 2;
            }
            return false;
        }

        private void init(@NotNull Disposable parentDisposable) {
            if (parentDisposable == null) {
                Divider.$$$reportNull$$$0(2);
            }
            this.myGlassPane = IdeGlassPaneUtil.find(this);
            this.myGlassPane.addMouseMotionPreprocessor(this.myListener, parentDisposable);
            this.myGlassPane.addMousePreprocessor(this.myListener, parentDisposable);
        }

        private void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            if (!ThreeComponentsSplitter.this.myShowDividerControls) {
                return;
            }
            int xMask = isVerticalSplit ? 1 : 0;
            int yMask = isVerticalSplit ? 0 : 1;
            Icon glueIcon = isVerticalSplit ? SplitGlueV : AllIcons.General.ArrowSplitCenterH;
            int glueFill = isVerticalSplit ? 3 : 2;
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, isVerticalSplit ? 13 : 11, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitDownlabel = new JLabel(isVerticalSplit ? AllIcons.General.ArrowDown : AllIcons.General.ArrowRight);
            splitDownlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitDownlabel.setToolTipText(isVerticalSplit ? UIBundle.message("splitter.down.tooltip.text", new Object[0]) : UIBundle.message("splitter.right.tooltip.text", new Object[0]));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (ThreeComponentsSplitter.this.myInnerComponent != null) {
                        int income;
                        int n = income = ThreeComponentsSplitter.this.myVerticalSplit ? ThreeComponentsSplitter.this.myInnerComponent.getHeight() : ThreeComponentsSplitter.this.myInnerComponent.getWidth();
                        if (Divider.this.myIsFirst) {
                            ThreeComponentsSplitter.this.setFirstSize(ThreeComponentsSplitter.this.myFirstSize + income);
                        } else {
                            ThreeComponentsSplitter.this.setLastSize(ThreeComponentsSplitter.this.myLastSize + income);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ThreeComponentsSplitter$Divider$2", "onClick"));
                }
            }.installOn((Component)splitDownlabel);
            this.add((Component)splitDownlabel, new GridBagConstraints(isVerticalSplit ? 1 : 0, isVerticalSplit ? 0 : 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(2 * xMask, 2 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitCenterlabel = new JLabel(isVerticalSplit ? AllIcons.General.ArrowSplitCenterV : AllIcons.General.ArrowSplitCenterH);
            splitCenterlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitCenterlabel.setToolTipText(UIBundle.message("splitter.center.tooltip.text", new Object[0]));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    Divider.this.center();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ThreeComponentsSplitter$Divider$3", "onClick"));
                }
            }.installOn((Component)splitCenterlabel);
            this.add((Component)splitCenterlabel, new GridBagConstraints(3 * xMask, 3 * yMask, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(4 * xMask, 4 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitUpLabel = new JLabel(isVerticalSplit ? AllIcons.General.ArrowUp : AllIcons.General.ArrowLeft);
            splitUpLabel.setCursor(Cursor.getPredefinedCursor(12));
            splitUpLabel.setToolTipText(isVerticalSplit ? UIBundle.message("splitter.up.tooltip.text", new Object[0]) : UIBundle.message("splitter.left.tooltip.text", new Object[0]));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (ThreeComponentsSplitter.this.myInnerComponent != null) {
                        int income;
                        int n = income = ThreeComponentsSplitter.this.myVerticalSplit ? ThreeComponentsSplitter.this.myInnerComponent.getHeight() : ThreeComponentsSplitter.this.myInnerComponent.getWidth();
                        if (Divider.this.myIsFirst) {
                            ThreeComponentsSplitter.this.setFirstSize(ThreeComponentsSplitter.this.myFirstSize + income);
                        } else {
                            ThreeComponentsSplitter.this.setLastSize(ThreeComponentsSplitter.this.myLastSize + income);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ThreeComponentsSplitter$Divider$4", "onClick"));
                }
            }.installOn((Component)splitUpLabel);
            this.add((Component)splitUpLabel, new GridBagConstraints(isVerticalSplit ? 5 : 0, isVerticalSplit ? 0 : 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(6 * xMask, 6 * yMask, 1, 1, 0.0, 0.0, isVerticalSplit ? 17 : 15, glueFill, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void center() {
            if (ThreeComponentsSplitter.this.myInnerComponent != null) {
                int total = ThreeComponentsSplitter.this.myFirstSize + (ThreeComponentsSplitter.this.myVerticalSplit ? ThreeComponentsSplitter.this.myInnerComponent.getHeight() : ThreeComponentsSplitter.this.myInnerComponent.getWidth());
                if (this.myIsFirst) {
                    ThreeComponentsSplitter.this.setFirstSize(total / 2);
                } else {
                    ThreeComponentsSplitter.this.setLastSize(total / 2);
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (!this.isShowing()) {
                return;
            }
            if (506 == e.getID() && this.myWasPressedOnMe) {
                int size;
                this.myDragging = true;
                this.setCursor(this.getResizeCursor());
                if (this.myGlassPane != null) {
                    this.myGlassPane.setCursor(this.getResizeCursor(), this.myListener);
                }
                this.myPoint = SwingUtilities.convertPoint(this, e.getPoint(), ThreeComponentsSplitter.this);
                int n = size = ThreeComponentsSplitter.this.getOrientation() ? ThreeComponentsSplitter.this.getHeight() : ThreeComponentsSplitter.this.getWidth();
                if (ThreeComponentsSplitter.this.getOrientation()) {
                    if (size > 0 || ThreeComponentsSplitter.this.myDividerZone > 0) {
                        if (this.myIsFirst) {
                            ThreeComponentsSplitter.this.setFirstSize(Math.min(size - ThreeComponentsSplitter.this.myLastSize - ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myInnerComponent) - ThreeComponentsSplitter.this.getDividerWidth() * ThreeComponentsSplitter.this.visibleDividersCount(), Math.max(ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myFirstComponent), this.myPoint.y)));
                        } else {
                            ThreeComponentsSplitter.this.setLastSize(Math.min(size - ThreeComponentsSplitter.this.myFirstSize - ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myInnerComponent) - ThreeComponentsSplitter.this.getDividerWidth() * ThreeComponentsSplitter.this.visibleDividersCount(), Math.max(ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myLastComponent), size - this.myPoint.y - ThreeComponentsSplitter.this.getDividerWidth())));
                        }
                    }
                } else if (size > 0 || ThreeComponentsSplitter.this.myDividerZone > 0) {
                    if (this.myIsFirst) {
                        ThreeComponentsSplitter.this.setFirstSize(Math.min(size - ThreeComponentsSplitter.this.myLastSize - ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myInnerComponent) - ThreeComponentsSplitter.this.getDividerWidth() * ThreeComponentsSplitter.this.visibleDividersCount(), Math.max(ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myFirstComponent), this.myPoint.x)));
                    } else {
                        ThreeComponentsSplitter.this.setLastSize(Math.min(size - ThreeComponentsSplitter.this.myFirstSize - ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myInnerComponent) - ThreeComponentsSplitter.this.getDividerWidth() * ThreeComponentsSplitter.this.visibleDividersCount(), Math.max(ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myLastComponent), size - this.myPoint.x - ThreeComponentsSplitter.this.getDividerWidth())));
                    }
                }
                ThreeComponentsSplitter.this.doLayout();
            } else if (503 == e.getID() && this.myGlassPane != null) {
                if (this.isInside(e.getPoint())) {
                    this.myGlassPane.setCursor(this.getResizeCursor(), this.myListener);
                    e.consume();
                } else {
                    this.myGlassPane.setCursor(null, this.myListener);
                }
            }
            if (this.myWasPressedOnMe) {
                e.consume();
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (!this.isShowing()) {
                return;
            }
            switch (e.getID()) {
                case 504: {
                    this.setCursor(this.getResizeCursor());
                    break;
                }
                case 505: {
                    if (this.myDragging) break;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 501: {
                    if (this.isInside(e.getPoint())) {
                        this.myWasPressedOnMe = true;
                        if (this.myGlassPane != null) {
                            this.myGlassPane.setCursor(this.getResizeCursor(), this.myListener);
                        }
                        e.consume();
                        break;
                    }
                    this.myWasPressedOnMe = false;
                    break;
                }
                case 502: {
                    if (this.myWasPressedOnMe) {
                        e.consume();
                    }
                    if (this.isInside(e.getPoint()) && this.myGlassPane != null) {
                        this.myGlassPane.setCursor(this.getResizeCursor(), this.myListener);
                    }
                    if (this.myDragging && ThreeComponentsSplitter.this.myDividerDispatcher != null) {
                        ((ComponentListener)ThreeComponentsSplitter.this.myDividerDispatcher.getMulticaster()).componentResized(new ComponentEvent(this, 101));
                    }
                    this.myWasPressedOnMe = false;
                    this.myDragging = false;
                    this.myPoint = null;
                    break;
                }
                case 500: {
                    if (e.getClickCount() != 2) break;
                    this.center();
                }
            }
        }

        private Cursor getResizeCursor() {
            return ThreeComponentsSplitter.this.getOrientation() ? Cursor.getPredefinedCursor(this.myIsFirst ? 9 : 8) : Cursor.getPredefinedCursor(this.myIsFirst ? 10 : 11);
        }

        private static /* synthetic */ boolean lambda$isInside$0(List components, Component c) {
            return c != null && components.contains(c);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/ui/ThreeComponentsSplitter$Divider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTargetEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "init";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyMouseAdapter
        extends MouseAdapter
        implements Weighted {
            private MyMouseAdapter() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this._processMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this._processMouseEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this._processMouseMotionEvent(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this._processMouseMotionEvent(e);
            }

            @Override
            public double getWeight() {
                return 1.0;
            }

            private void _processMouseMotionEvent(MouseEvent e) {
                MouseEvent event = Divider.this.getTargetEvent(e);
                Divider.this.processMouseMotionEvent(event);
                if (event.isConsumed()) {
                    e.consume();
                }
            }

            private void _processMouseEvent(MouseEvent e) {
                MouseEvent event = Divider.this.getTargetEvent(e);
                Divider.this.processMouseEvent(event);
                if (event.isConsumed()) {
                    e.consume();
                }
            }
        }
    }

    private final class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private boolean myReentrantLock = false;

        private MyFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component comp;
            if (SwingUtilities.isDescendingFrom(aComponent, ThreeComponentsSplitter.this.myFirstComponent)) {
                Component next = this.nextVisible(ThreeComponentsSplitter.this.myFirstComponent);
                comp = next != null ? this.findChildToFocus(next) : aComponent;
            } else if (SwingUtilities.isDescendingFrom(aComponent, ThreeComponentsSplitter.this.myInnerComponent)) {
                Component next = this.nextVisible(ThreeComponentsSplitter.this.myInnerComponent);
                comp = next != null ? this.findChildToFocus(next) : aComponent;
            } else {
                Component next = this.nextVisible(ThreeComponentsSplitter.this.myLastComponent);
                Component component = comp = next != null ? this.findChildToFocus(next) : aComponent;
            }
            if (comp == aComponent) {
                return super.getComponentAfter(aContainer, aComponent);
            }
            return comp;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component comp;
            if (SwingUtilities.isDescendingFrom(aComponent, ThreeComponentsSplitter.this.myInnerComponent)) {
                Component prev = this.prevVisible(ThreeComponentsSplitter.this.myInnerComponent);
                comp = prev != null ? this.findChildToFocus(prev) : aComponent;
            } else if (SwingUtilities.isDescendingFrom(aComponent, ThreeComponentsSplitter.this.myLastComponent)) {
                Component prev = this.prevVisible(ThreeComponentsSplitter.this.myLastComponent);
                comp = prev != null ? this.findChildToFocus(prev) : aComponent;
            } else {
                Component prev = this.prevVisible(ThreeComponentsSplitter.this.myFirstComponent);
                Component component = comp = prev != null ? this.findChildToFocus(prev) : aComponent;
            }
            if (comp == aComponent) {
                return super.getComponentBefore(aContainer, aComponent);
            }
            return comp;
        }

        private Component nextVisible(Component comp) {
            if (comp == ThreeComponentsSplitter.this.myFirstComponent) {
                return ThreeComponentsSplitter.this.innerVisible() ? ThreeComponentsSplitter.this.myInnerComponent : (ThreeComponentsSplitter.this.lastVisible() ? ThreeComponentsSplitter.this.myLastComponent : null);
            }
            if (comp == ThreeComponentsSplitter.this.myInnerComponent) {
                return ThreeComponentsSplitter.this.lastVisible() ? ThreeComponentsSplitter.this.myLastComponent : (ThreeComponentsSplitter.this.firstVisible() ? ThreeComponentsSplitter.this.myFirstComponent : null);
            }
            if (comp == ThreeComponentsSplitter.this.myLastComponent) {
                return ThreeComponentsSplitter.this.firstVisible() ? ThreeComponentsSplitter.this.myFirstComponent : (ThreeComponentsSplitter.this.innerVisible() ? ThreeComponentsSplitter.this.myInnerComponent : null);
            }
            return null;
        }

        private Component prevVisible(Component comp) {
            if (comp == ThreeComponentsSplitter.this.myFirstComponent) {
                return ThreeComponentsSplitter.this.lastVisible() ? ThreeComponentsSplitter.this.myLastComponent : (ThreeComponentsSplitter.this.innerVisible() ? ThreeComponentsSplitter.this.myInnerComponent : null);
            }
            if (comp == ThreeComponentsSplitter.this.myInnerComponent) {
                return ThreeComponentsSplitter.this.firstVisible() ? ThreeComponentsSplitter.this.myFirstComponent : (ThreeComponentsSplitter.this.lastVisible() ? ThreeComponentsSplitter.this.myLastComponent : null);
            }
            if (comp == ThreeComponentsSplitter.this.myLastComponent) {
                return ThreeComponentsSplitter.this.innerVisible() ? ThreeComponentsSplitter.this.myInnerComponent : (ThreeComponentsSplitter.this.firstVisible() ? ThreeComponentsSplitter.this.myFirstComponent : null);
            }
            return null;
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            if (ThreeComponentsSplitter.this.firstVisible()) {
                return this.findChildToFocus(ThreeComponentsSplitter.this.myFirstComponent);
            }
            Component next = this.nextVisible(ThreeComponentsSplitter.this.myFirstComponent);
            return next != null ? this.findChildToFocus(next) : null;
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            if (ThreeComponentsSplitter.this.lastVisible()) {
                return this.findChildToFocus(ThreeComponentsSplitter.this.myLastComponent);
            }
            Component prev = this.prevVisible(ThreeComponentsSplitter.this.myLastComponent);
            return prev != null ? this.findChildToFocus(prev) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getDefaultComponent(Container aContainer) {
            if (this.myReentrantLock) {
                return null;
            }
            try {
                this.myReentrantLock = true;
                if (ThreeComponentsSplitter.this.innerVisible()) {
                    Component component = this.findChildToFocus(ThreeComponentsSplitter.this.myInnerComponent);
                    return component;
                }
                Component next = this.nextVisible(ThreeComponentsSplitter.this.myLastComponent);
                Component component = next != null ? this.findChildToFocus(next) : null;
                return component;
            }
            finally {
                this.myReentrantLock = false;
            }
        }

        Component findChildToFocus(Component component) {
            Window ancestor = SwingUtilities.getWindowAncestor(ThreeComponentsSplitter.this);
            Component mostRecentFocusOwner = FocusUtil.getMostRecentComponent((Component)component, (Window)ancestor);
            if (mostRecentFocusOwner != null) {
                return mostRecentFocusOwner;
            }
            Component defaultComponentInPanel = FocusUtil.getDefaultComponentInPanel((Component)component);
            if (defaultComponentInPanel != null) {
                return defaultComponentInPanel;
            }
            return FocusUtil.findFocusableComponentIn((Container)((JComponent)component), null);
        }
    }
}

