/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WriteCommandAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance(WriteCommandAction.class);
    private static final String DEFAULT_COMMAND_NAME = "Undefined";
    private static final String DEFAULT_GROUP_ID = null;
    private final String myCommandName;
    private final String myGroupID;
    private final Project myProject;
    private final PsiFile[] myPsiFiles;

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(Project project) {
        return new BuilderImpl(project, new PsiFile[0]);
    }

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(@NotNull PsiFile first, PsiFile ... others) {
        if (first == null) {
            WriteCommandAction.$$$reportNull$$$0(0);
        }
        if (others == null) {
            WriteCommandAction.$$$reportNull$$$0(1);
        }
        return new BuilderImpl(first.getProject(), (PsiFile[])ArrayUtil.prepend((Object)first, (Object[])others));
    }

    @NotNull
    @Contract(pure=true)
    public static Builder writeCommandAction(Project project, PsiFile ... files) {
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(2);
        }
        return new BuilderImpl(project, files);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, PsiFile ... files) {
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(3);
        }
        this(project, DEFAULT_COMMAND_NAME, files);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, @Nullable String commandName, PsiFile ... files) {
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(4);
        }
        this(project, commandName, DEFAULT_GROUP_ID, files);
    }

    @Deprecated
    protected WriteCommandAction(@Nullable Project project, @Nullable String commandName, @Nullable String groupID, PsiFile ... files) {
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(5);
        }
        this.myCommandName = commandName;
        this.myGroupID = groupID;
        this.myProject = project;
        this.myPsiFiles = files.length == 0 ? PsiFile.EMPTY_ARRAY : files;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final String getCommandName() {
        return this.myCommandName;
    }

    public String getGroupID() {
        return this.myGroupID;
    }

    @Override
    @Deprecated
    @NotNull
    public RunResult<T> execute() {
        Application application = ApplicationManager.getApplication();
        boolean dispatchThread = application.isDispatchThread();
        if (!dispatchThread && application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
            throw new IllegalStateException();
        }
        RunResult result = new RunResult(this);
        if (dispatchThread) {
            this.performWriteCommandAction(result);
        } else {
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> this.performWriteCommandAction(result));
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        RunResult runResult = result;
        if (runResult == null) {
            WriteCommandAction.$$$reportNull$$$0(6);
        }
        return runResult;
    }

    private void performWriteCommandAction(@NotNull RunResult<T> result) {
        if (result == null) {
            WriteCommandAction.$$$reportNull$$$0(7);
        }
        if (this.myPsiFiles.length > 0 && !FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(this.myPsiFiles))) {
            return;
        }
        Ref resultRef = new Ref(result);
        this.doExecuteCommand(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            ((RunResult)resultRef.get()).run();
            resultRef.set(null);
        }));
    }

    @Deprecated
    protected boolean isGlobalUndoAction() {
        return false;
    }

    @Deprecated
    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
        if (undoConfirmationPolicy == null) {
            WriteCommandAction.$$$reportNull$$$0(8);
        }
        return undoConfirmationPolicy;
    }

    @Deprecated
    protected boolean shouldRecordActionForActiveDocument() {
        return true;
    }

    @Deprecated
    public void performCommand() throws Throwable {
        RunResult[] results = new RunResult[]{new RunResult(this)};
        Ref exception = new Ref();
        this.doExecuteCommand(() -> {
            exception.set((Object)results[0].run().getThrowable());
            results[0] = null;
        });
        Throwable throwable = (Throwable)exception.get();
        if (throwable != null) {
            throw throwable;
        }
    }

    private void doExecuteCommand(Runnable runnable) {
        Runnable wrappedRunnable = () -> {
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.getProject());
            }
            runnable.run();
        };
        CommandProcessor.getInstance().executeCommand(this.getProject(), wrappedRunnable, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy(), this.shouldRecordActionForActiveDocument());
    }

    public static void runWriteCommandAction(Project project, @NotNull Runnable runnable) {
        if (runnable == null) {
            WriteCommandAction.$$$reportNull$$$0(9);
        }
        WriteCommandAction.runWriteCommandAction(project, DEFAULT_COMMAND_NAME, DEFAULT_GROUP_ID, runnable, new PsiFile[0]);
    }

    public static void runWriteCommandAction(Project project, @Nullable String commandName, @Nullable String groupID, @NotNull Runnable runnable, PsiFile ... files) {
        if (runnable == null) {
            WriteCommandAction.$$$reportNull$$$0(10);
        }
        if (files == null) {
            WriteCommandAction.$$$reportNull$$$0(11);
        }
        WriteCommandAction.writeCommandAction(project, files).withName(commandName).withGroupId(groupID).run(() -> runnable.run());
    }

    public static <T> T runWriteCommandAction(Project project, @NotNull Computable<T> computable) {
        if (computable == null) {
            WriteCommandAction.$$$reportNull$$$0(12);
        }
        return (T)WriteCommandAction.writeCommandAction(project).compute(() -> computable.compute());
    }

    public static <T, E extends Throwable> T runWriteCommandAction(Project project, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            WriteCommandAction.$$$reportNull$$$0(13);
        }
        return WriteCommandAction.writeCommandAction(project).compute(computable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "others";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/WriteCommandAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/WriteCommandAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoConfirmationPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeCommandAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performWriteCommandAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runWriteCommandAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    public static abstract class Simple<T>
    extends WriteCommandAction<T> {
        protected Simple(Project project, PsiFile ... files) {
            super(project, files);
        }

        protected Simple(Project project, String commandName, PsiFile ... files) {
            super(project, commandName, files);
        }

        protected Simple(Project project, String name, String groupID, PsiFile ... files) {
            super(project, name, groupID, files);
        }

        @Override
        protected void run(@NotNull Result<T> result) throws Throwable {
            if (result == null) {
                Simple.$$$reportNull$$$0(0);
            }
            this.run();
        }

        protected abstract void run() throws Throwable;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$Simple", "run"));
        }
    }

    private static class BuilderImpl
    implements Builder {
        private final Project myProject;
        private final PsiFile[] myFiles;
        private String myCommandName;
        private String myGroupId;
        private UndoConfirmationPolicy myPolicy;
        private boolean myGlobalUndoAction;
        private boolean myShouldRecordActionForActiveDocument;

        private BuilderImpl(Project project, PsiFile ... files) {
            if (files == null) {
                BuilderImpl.$$$reportNull$$$0(0);
            }
            this.myCommandName = WriteCommandAction.DEFAULT_COMMAND_NAME;
            this.myGroupId = DEFAULT_GROUP_ID;
            this.myShouldRecordActionForActiveDocument = true;
            this.myProject = project;
            this.myFiles = files;
        }

        @Override
        @NotNull
        public Builder withName(String name) {
            this.myCommandName = name;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(1);
            }
            return builderImpl;
        }

        @Override
        @NotNull
        public Builder withGlobalUndo() {
            this.myGlobalUndoAction = true;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(2);
            }
            return builderImpl;
        }

        @Override
        @NotNull
        public Builder shouldRecordActionForActiveDocument(boolean value) {
            this.myShouldRecordActionForActiveDocument = value;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(3);
            }
            return builderImpl;
        }

        @Override
        @NotNull
        public Builder withUndoConfirmationPolicy(@NotNull UndoConfirmationPolicy policy) {
            if (policy == null) {
                BuilderImpl.$$$reportNull$$$0(4);
            }
            if (this.myPolicy != null) {
                throw new IllegalStateException("do not call withUndoConfirmationPolicy() several times");
            }
            this.myPolicy = policy;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(5);
            }
            return builderImpl;
        }

        @Override
        @NotNull
        public Builder withGroupId(String groupId) {
            this.myGroupId = groupId;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                BuilderImpl.$$$reportNull$$$0(6);
            }
            return builderImpl;
        }

        @Override
        public <E extends Throwable> void run(final @NotNull ThrowableRunnable<E> action) {
            if (action == null) {
                BuilderImpl.$$$reportNull$$$0(7);
            }
            new MyActionWrap(){

                @Override
                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    action.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl$1", "run"));
                }
            }.execute();
        }

        @Override
        public <R, E extends Throwable> R compute(final @NotNull ThrowableComputable<R, E> action) {
            if (action == null) {
                BuilderImpl.$$$reportNull$$$0(8);
            }
            return (R)new MyActionWrap<R>(){

                @Override
                protected void run(@NotNull Result<R> result) throws Throwable {
                    if (result == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    result.setResult(action.compute());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl$2", "run"));
                }
            }.execute().getResultObject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/command/WriteCommandAction$BuilderImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/command/WriteCommandAction$BuilderImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withGlobalUndo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldRecordActionForActiveDocument";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withUndoConfirmationPolicy";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withGroupId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "withUndoConfirmationPolicy";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private abstract class MyActionWrap<T>
        extends WriteCommandAction<T> {
            MyActionWrap() {
                super(BuilderImpl.this.myProject, BuilderImpl.this.myCommandName, BuilderImpl.this.myGroupId, BuilderImpl.this.myFiles);
            }

            @Override
            @NotNull
            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                UndoConfirmationPolicy undoConfirmationPolicy = (UndoConfirmationPolicy)((Object)ObjectUtils.notNull((Object)((Object)BuilderImpl.this.myPolicy), (Object)((Object)UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION)));
                if (undoConfirmationPolicy == null) {
                    MyActionWrap.$$$reportNull$$$0(0);
                }
                return undoConfirmationPolicy;
            }

            @Override
            protected boolean isGlobalUndoAction() {
                return BuilderImpl.this.myGlobalUndoAction;
            }

            @Override
            protected boolean shouldRecordActionForActiveDocument() {
                return BuilderImpl.this.myShouldRecordActionForActiveDocument;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl$MyActionWrap", "getUndoConfirmationPolicy"));
            }
        }
    }

    public static interface Builder {
        @Contract(pure=true)
        @NotNull
        public Builder withName(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String var1);

        @Contract(pure=true)
        @NotNull
        public Builder withGroupId(@Nullable String var1);

        @Contract(pure=true)
        @NotNull
        public Builder withUndoConfirmationPolicy(@NotNull UndoConfirmationPolicy var1);

        @Contract(pure=true)
        @NotNull
        public Builder withGlobalUndo();

        @Contract(pure=true)
        @NotNull
        public Builder shouldRecordActionForActiveDocument(boolean var1);

        public <E extends Throwable> void run(@NotNull ThrowableRunnable<E> var1) throws E;

        public <R, E extends Throwable> R compute(@NotNull ThrowableComputable<R, E> var1) throws E;
    }
}

