/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.PerFileMappingState;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerFileMappingsBase<T>
implements PersistentStateComponent<Element>,
PerFileMappings<T>,
Disposable {
    private List<PerFileMappingState> myDeferredMappings;
    private final Map<VirtualFile, T> myMappings = new HashMap<VirtualFile, T>();

    public PerFileMappingsBase() {
        this.installDeleteUndo();
    }

    public void dispose() {
    }

    @Nullable
    protected FilePropertyPusher<T> getFilePropertyPusher() {
        return null;
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Map<VirtualFile, T> getMappings() {
        Map<VirtualFile, T> map2 = this.myMappings;
        // MONITORENTER : map2
        this.ensureStateLoaded();
        this.cleanup();
        Map<VirtualFile, T> map = Collections.unmodifiableMap(this.myMappings);
        // MONITOREXIT : map2
        if (map != null) return map;
        PerFileMappingsBase.$$$reportNull$$$0(0);
        return map;
    }

    private void cleanup() {
        Iterator<VirtualFile> i = this.myMappings.keySet().iterator();
        while (i.hasNext()) {
            VirtualFile file = i.next();
            if (file == null || file.isValid()) continue;
            i.remove();
        }
    }

    @Override
    @Nullable
    public T getMapping(@Nullable VirtualFile file) {
        T t = this.getConfiguredMapping(file);
        return t == null ? this.getDefaultMapping(file) : t;
    }

    @Nullable
    public T getConfiguredMapping(@Nullable VirtualFile file) {
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        return this.getMappingInner(file, pusher == null ? null : pusher.getFileDataKey(), false);
    }

    @Nullable
    public T getDirectlyConfiguredMapping(@Nullable VirtualFile file) {
        return this.getMappingInner(file, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private T getMappingInner(@Nullable VirtualFile file, @Nullable Key<T> pusherKey, boolean forHierarchy) {
        Object pushedValue;
        VirtualFile originalFile;
        if (file instanceof VirtualFileWindow) {
            VirtualFileWindow window = (VirtualFileWindow)((Object)file);
            file = window.getDelegate();
        }
        VirtualFile virtualFile2 = originalFile = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getOriginalFile() : null;
        if (Comparing.equal((Object)originalFile, (Object)file)) {
            originalFile = null;
        }
        if (file != null) {
            Object object = pushedValue = pusherKey == null ? null : file.getUserData(pusherKey);
            if (pushedValue != null) {
                return (T)pushedValue;
            }
        }
        if (originalFile != null) {
            Object object = pushedValue = pusherKey == null ? null : originalFile.getUserData(pusherKey);
            if (pushedValue != null) {
                return (T)pushedValue;
            }
        }
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            this.ensureStateLoaded();
            T t = PerFileMappingsBase.getMappingForHierarchy(file, this.myMappings);
            if (t != null) {
                return t;
            }
            t = PerFileMappingsBase.getMappingForHierarchy(originalFile, this.myMappings);
            if (t != null) {
                return t;
            }
            if (forHierarchy && file != null) {
                return null;
            }
            return this.getNotInHierarchy(originalFile != null ? originalFile : file, this.myMappings);
        }
    }

    @Nullable
    protected T getNotInHierarchy(@Nullable VirtualFile file, @NotNull Map<VirtualFile, T> mappings) {
        if (mappings == null) {
            PerFileMappingsBase.$$$reportNull$$$0(1);
        }
        if (this.getProject() == null || file == null || file.getFileSystem() instanceof NonPhysicalFileSystem || !this.getProject().isDefault() && ProjectFileIndex.getInstance(this.getProject()).isInContent(file)) {
            return mappings.get(null);
        }
        return null;
    }

    private static <T> T getMappingForHierarchy(@Nullable VirtualFile file, @NotNull Map<VirtualFile, T> mappings) {
        if (mappings == null) {
            PerFileMappingsBase.$$$reportNull$$$0(2);
        }
        for (VirtualFile cur = file; cur != null; cur = cur.getParent()) {
            T t = mappings.get(cur);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    @Nullable
    public T getDefaultMapping(@Nullable VirtualFile file) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getImmediateMapping(@Nullable VirtualFile file) {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            this.ensureStateLoaded();
            return this.myMappings.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMappings(@NotNull Map<VirtualFile, T> mappings) {
        ArrayList<VirtualFile> oldFiles;
        if (mappings == null) {
            PerFileMappingsBase.$$$reportNull$$$0(3);
        }
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            this.myDeferredMappings = null;
            oldFiles = new ArrayList<VirtualFile>(this.myMappings.keySet());
            this.myMappings.clear();
            this.myMappings.putAll(mappings);
            this.cleanup();
        }
        Project project = this.getProject();
        this.handleMappingChange(mappings.keySet(), oldFiles, project != null && !project.isDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapping(@Nullable VirtualFile file, @Nullable T value) {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            this.ensureStateLoaded();
            if (value == null) {
                this.myMappings.remove(file);
            } else {
                this.myMappings.put(file, value);
            }
        }
        List files = ContainerUtil.createMaybeSingletonList((Object)file);
        this.handleMappingChange(files, files, false);
    }

    private void handleMappingChange(Collection<VirtualFile> files, Collection<VirtualFile> oldFiles, boolean includeOpenFiles) {
        Project project = this.getProject();
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        if (project != null && pusher != null) {
            for (VirtualFile oldFile : oldFiles) {
                if (oldFile == null) continue;
                oldFile.putUserData(pusher.getFileDataKey(), null);
            }
            if (!project.isDefault()) {
                PushedFilePropertiesUpdater.getInstance(project).pushAll(pusher);
            }
        }
        if (this.shouldReparseFiles()) {
            Project[] projects;
            Project[] projectArray;
            if (project == null) {
                projectArray = ProjectManager.getInstance().getOpenProjects();
            } else {
                Project[] projectArray2 = new Project[1];
                projectArray = projectArray2;
                projectArray2[0] = project;
            }
            for (Project p : projects = projectArray) {
                PsiDocumentManager.getInstance(p).reparseFiles(files, includeOpenFiles);
            }
        }
    }

    public abstract List<T> getAvailableValues();

    @Nullable
    protected abstract String serialize(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getState() {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            if (this.myDeferredMappings != null) {
                return PerFileMappingState.write(this.myDeferredMappings, this.getValueAttribute());
            }
            this.cleanup();
            Element element = new Element("x");
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myMappings.keySet());
            Collections.sort(files, (o1, o2) -> {
                if (o1 == null || o2 == null) {
                    return o1 == null ? (o2 == null ? 0 : 1) : -1;
                }
                return o1.getPath().compareTo(o2.getPath());
            });
            for (VirtualFile file : files) {
                String valueStr;
                T value = this.myMappings.get(file);
                String string = valueStr = value == null ? null : this.serialize(value);
                if (valueStr == null) continue;
                Element child = new Element("file");
                element.addContent(child);
                child.setAttribute("url", file == null ? "PROJECT" : file.getUrl());
                child.setAttribute(this.getValueAttribute(), valueStr);
            }
            return element;
        }
    }

    @Nullable
    protected T handleUnknownMapping(VirtualFile file, String value) {
        return null;
    }

    @Deprecated
    @NotNull
    protected String getValueAttribute() {
        return "value";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(@NotNull Element element) {
        if (element == null) {
            PerFileMappingsBase.$$$reportNull$$$0(4);
        }
        List<PerFileMappingState> list = PerFileMappingState.read(element, this.getValueAttribute());
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            if (list.isEmpty()) {
                this.myMappings.clear();
                this.myDeferredMappings = null;
            } else {
                this.myDeferredMappings = list;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureStateLoaded() {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            List<PerFileMappingState> state = this.myDeferredMappings;
            if (state == null) {
                return;
            }
            this.myDeferredMappings = null;
            THashMap valuesMap = new THashMap();
            for (T value : this.getAvailableValues()) {
                String key = this.serialize(value);
                if (key == null) continue;
                valuesMap.put((Object)key, value);
            }
            this.myMappings.clear();
            for (PerFileMappingState entry : state) {
                String url = entry.getUrl();
                String valueStr = entry.getValue();
                VirtualFile file = "PROJECT".equals(url) ? null : VirtualFileManager.getInstance().findFileByUrl(url);
                Object value = valuesMap.get((Object)valueStr);
                if (value == null && (value = this.handleUnknownMapping(file, valueStr)) == null || file == null && !url.equals("PROJECT")) continue;
                this.myMappings.put(file, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupForNextTest() {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            this.myDeferredMappings = null;
            this.myMappings.clear();
        }
    }

    protected boolean shouldReparseFiles() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMappings() {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            this.ensureStateLoaded();
            return !this.myMappings.isEmpty();
        }
    }

    private void installDeleteUndo() {
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        app.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){
            WeakReference<MyUndoableAction> lastAction;

            @Override
            public void before(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
                    return;
                }
                Project project = CommandProcessor.getInstance().getCurrentCommandProject();
                if (project == null || !project.isOpen()) {
                    return;
                }
                MyUndoableAction action = this.createUndoableAction(events);
                if (action == null) {
                    return;
                }
                action.doRemove(action.removed);
                this.lastAction = new WeakReference<MyUndoableAction>(action);
                UndoManager.getInstance(project).undoableActionPerformed(action);
            }

            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(1);
                }
                MyUndoableAction action = (MyUndoableAction)SoftReference.dereference(this.lastAction);
                this.lastAction = null;
                if (action != null) {
                    ApplicationManager.getApplication().invokeLater(() -> action.doAdd(action.added));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            MyUndoableAction createUndoableAction(@NotNull List<? extends VFileEvent> events) {
                List eventsFiltered;
                if (events == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((eventsFiltered = JBIterable.from(events).filter(VFileDeleteEvent.class).toList()).isEmpty()) {
                    return null;
                }
                HashMap removed = new HashMap();
                HashMap added = new HashMap();
                TreeSet navSet = null;
                Map map = PerFileMappingsBase.this.myMappings;
                synchronized (map) {
                    PerFileMappingsBase.this.ensureStateLoaded();
                    for (VFileEvent event : eventsFiltered) {
                        VirtualFile child;
                        VirtualFile file = event.getFile();
                        if (file == null) continue;
                        String fileUrl = file.getUrl();
                        if (!file.isDirectory()) {
                            Object m = PerFileMappingsBase.this.myMappings.get(file);
                            if (m == null) continue;
                            removed.put(fileUrl, m);
                            continue;
                        }
                        if (navSet == null) {
                            navSet = new TreeSet((f1, f2) -> Comparing.compare((Comparable)((Object)(f1 == null ? null : f1.getUrl())), (Comparable)((Object)(f2 == null ? null : f2.getUrl()))));
                            navSet.addAll(PerFileMappingsBase.this.myMappings.keySet());
                        }
                        Iterator iterator = navSet.tailSet(file).iterator();
                        while (iterator.hasNext() && VfsUtilCore.isAncestor(file, child = (VirtualFile)iterator.next(), false)) {
                            String childUrl = child.getUrl();
                            Object m = PerFileMappingsBase.this.myMappings.get(child);
                            removed.put(childUrl, m);
                        }
                    }
                }
                return removed.isEmpty() && added.isEmpty() ? null : new MyUndoableAction(added, removed);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/intellij/lang/PerFileMappingsBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createUndoableAction";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/PerFileMappingsBase";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/PerFileMappingsBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNotInHierarchy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMappingForHierarchy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setMappings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyUndoableAction
    extends BasicUndoableAction {
        final Map<String, T> added;
        final Map<String, T> removed;

        MyUndoableAction(Map<String, T> added, Map<String, T> removed) {
            this.added = added;
            this.removed = removed;
        }

        @Override
        public void undo() {
            this.doRemove(this.added);
            this.doAdd(this.removed);
        }

        @Override
        public void redo() {
            this.doRemove(this.removed);
            this.doAdd(this.added);
        }

        void doAdd(Map<String, T> toAdd) {
            if (toAdd == null) {
                return;
            }
            for (String url : toAdd.keySet()) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file == null) continue;
                PerFileMappingsBase.this.setMapping(file, toAdd.get(url));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRemove(Map<String, T> toRemove) {
            if (toRemove != null) {
                Map map = PerFileMappingsBase.this.myMappings;
                synchronized (map) {
                    for (String url : toRemove.keySet()) {
                        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                        if (file == null) continue;
                        PerFileMappingsBase.this.myMappings.remove(file);
                    }
                }
            }
        }
    }
}

