/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.OccurenceNavigator;
import com.intellij.pom.Navigatable;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OccurenceNavigatorSupport
implements OccurenceNavigator {
    private final JTree myTree;

    public OccurenceNavigatorSupport(@NotNull JTree tree) {
        if (tree == null) {
            OccurenceNavigatorSupport.$$$reportNull$$$0(0);
        }
        this.myTree = tree;
    }

    @Nullable
    protected abstract Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode var1);

    protected boolean isOccurrenceNode(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            OccurenceNavigatorSupport.$$$reportNull$$$0(1);
        }
        return this.createDescriptorForNode(node) != null;
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        DefaultMutableTreeNode node = this.findNode(this.myTree, true);
        if (node == null) {
            return null;
        }
        TreePath treePath = new TreePath(node.getPath());
        TreeUtil.selectPath(this.myTree, treePath);
        Navigatable editSourceDescriptor = this.createDescriptorForNode(node);
        if (editSourceDescriptor == null) {
            return null;
        }
        Counters counters = this.calculatePosition(node);
        return new OccurenceNavigator.OccurenceInfo(editSourceDescriptor, counters.myFoundOccurenceNumber, counters.myOccurencesCount);
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        DefaultMutableTreeNode node = this.findNode(this.myTree, false);
        if (node == null) {
            return null;
        }
        TreePath treePath = new TreePath(node.getPath());
        TreeUtil.selectPath(this.myTree, treePath);
        Navigatable editSourceDescriptor = this.createDescriptorForNode(node);
        if (editSourceDescriptor == null) {
            return null;
        }
        Counters counters = this.calculatePosition(node);
        return new OccurenceNavigator.OccurenceInfo(editSourceDescriptor, counters.myFoundOccurenceNumber, counters.myOccurencesCount);
    }

    @NotNull
    private Counters calculatePosition(@NotNull DefaultMutableTreeNode foundNode) {
        if (foundNode == null) {
            OccurenceNavigatorSupport.$$$reportNull$$$0(2);
        }
        Counters counters = new Counters();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)foundNode.getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode node = enumeration.nextElement();
            if (node instanceof DefaultMutableTreeNode && this.isOccurrenceNode((DefaultMutableTreeNode)node)) {
                ++counters.myOccurencesCount;
            }
            if (node != foundNode) continue;
            counters.myFoundOccurenceNumber = counters.myOccurencesCount;
        }
        Counters counters2 = counters;
        if (counters2 == null) {
            OccurenceNavigatorSupport.$$$reportNull$$$0(3);
        }
        return counters2;
    }

    @Override
    public boolean hasNextOccurence() {
        DefaultMutableTreeNode node = this.findNode(this.myTree, true);
        return node != null;
    }

    @Override
    public boolean hasPreviousOccurence() {
        DefaultMutableTreeNode node = this.findNode(this.myTree, false);
        return node != null;
    }

    private DefaultMutableTreeNode findNode(@NotNull JTree tree, boolean forward) {
        if (tree == null) {
            OccurenceNavigatorSupport.$$$reportNull$$$0(4);
        }
        TreePath selectionPath = tree.getSelectionPath();
        TreeNode selectedNode = null;
        if (selectionPath != null) {
            selectedNode = (TreeNode)selectionPath.getLastPathComponent();
        }
        return this.findNextNodeAfter(tree, selectedNode, forward);
    }

    public DefaultMutableTreeNode findNextNodeAfter(@NotNull JTree tree, TreeNode selectedNode, boolean forward) {
        if (tree == null) {
            OccurenceNavigatorSupport.$$$reportNull$$$0(5);
        }
        if (selectedNode == null) {
            selectedNode = (TreeNode)tree.getModel().getRoot();
        }
        if (forward) {
            for (DefaultMutableTreeNode node = ((DefaultMutableTreeNode)selectedNode).getNextNode(); node != null; node = node.getNextNode()) {
                if (this.createDescriptorForNode(node) == null) continue;
                return node;
            }
        } else {
            for (DefaultMutableTreeNode node = ((DefaultMutableTreeNode)selectedNode).getPreviousNode(); node != null; node = node.getPreviousNode()) {
                if (this.createDescriptorForNode(node) == null) continue;
                return node;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/OccurenceNavigatorSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/OccurenceNavigatorSupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOccurrenceNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculatePosition";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findNode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findNextNodeAfter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Counters {
        int myFoundOccurenceNumber;
        int myOccurencesCount;

        private Counters() {
        }
    }
}

