/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configuration.RunConfigurationExtensionBase;
import com.intellij.execution.configuration.RunConfigurationExtensionsManagerKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.ExtendableSettingsEditor;
import com.intellij.openapi.options.ExtensionSettingsEditor;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\u0011\u001a\u00020\u0012\"\b\b\u0002\u0010\u0013*\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016\u00a2\u0006\u0002\u0010\u0017J;\u0010\u0011\u001a\u00020\u0012\"\b\b\u0002\u0010\u0013*\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u001f\u0010!\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u00002\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010(2\u0006\u0010\u0014\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010)J/\u0010*\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010.J7\u0010*\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0002\u00101J*\u00102\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u00002\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001203H\u0084\b\u00a2\u0006\u0002\u00104J4\u00105\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001203H\u0084\b\u00a2\u0006\u0002\u00106J\u001b\u00107\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u00108\u001a\u000209\u00a2\u0006\u0002\u0010:J\u001b\u0010;\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010<\u001a\u00020=\u00a2\u0006\u0002\u0010>J\u001b\u0010?\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u00108\u001a\u000209\u00a2\u0006\u0002\u0010:R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006@"}, d2={"Lcom/intellij/execution/configuration/RunConfigurationExtensionsManager;", "U", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "T", "Lcom/intellij/execution/configuration/RunConfigurationExtensionBase;", "", "extensionPoint", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "(Lcom/intellij/openapi/extensions/ExtensionPointName;)V", "getExtensionPoint", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "extensionRootAttr", "", "getExtensionRootAttr", "()Ljava/lang/String;", "idAttrName", "getIdAttrName", "appendEditors", "", "V", "configuration", "group", "Lcom/intellij/openapi/options/SettingsEditorGroup;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/openapi/options/SettingsEditorGroup;)V", "mainEditor", "Lcom/intellij/openapi/options/ExtendableSettingsEditor;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/openapi/options/SettingsEditorGroup;Lcom/intellij/openapi/options/ExtendableSettingsEditor;)V", "attachExtensionsToProcess", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/process/ProcessHandler;Lcom/intellij/execution/configurations/RunnerSettings;)V", "extendCreatedConfiguration", "location", "Lcom/intellij/execution/Location;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/Location;)V", "extendTemplateConfiguration", "(Lcom/intellij/execution/configurations/RunConfigurationBase;)V", "getApplicableExtensions", "", "(Lcom/intellij/execution/configurations/RunConfigurationBase;)Ljava/util/List;", "patchCommandLine", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "runnerId", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/RunnerSettings;Lcom/intellij/execution/configurations/GeneralCommandLine;Ljava/lang/String;)V", "executor", "Lcom/intellij/execution/Executor;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/RunnerSettings;Lcom/intellij/execution/configurations/GeneralCommandLine;Ljava/lang/String;Lcom/intellij/execution/Executor;)V", "processApplicableExtensions", "Lkotlin/Function1;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lkotlin/jvm/functions/Function1;)V", "processEnabledExtensions", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/RunnerSettings;Lkotlin/jvm/functions/Function1;)V", "readExternal", "parentNode", "Lorg/jdom/Element;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lorg/jdom/Element;)V", "validateConfiguration", "isExecution", "", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Z)V", "writeExternal", "intellij.platform.lang"})
public class RunConfigurationExtensionsManager<U extends RunConfigurationBase<?>, T extends RunConfigurationExtensionBase<U>> {
    @NotNull
    private final String idAttrName = "ID";
    @NotNull
    private final String extensionRootAttr = "EXTENSION";
    @NotNull
    private final ExtensionPointName<T> extensionPoint;

    @NotNull
    protected String getIdAttrName() {
        return this.idAttrName;
    }

    @NotNull
    protected String getExtensionRootAttr() {
        return this.extensionRootAttr;
    }

    public final void readExternal(@NotNull U configuration, @NotNull Element parentNode) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)parentNode, (String)"parentNode");
        List children = parentNode.getChildren(this.getExtensionRootAttr());
        if (children.isEmpty()) {
            return;
        }
        THashMap extensions = new THashMap();
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            RunConfigurationExtensionBase it;
            if (!extension$iv.isApplicableFor(configuration)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)extension$iv, (String)"extension");
            boolean bl = false;
            extensions.put((Object)it.getSerializationId(), (Object)it);
        }
        boolean hasUnknownExtension = false;
        for (Element element : children) {
            RunConfigurationExtensionBase extension = (RunConfigurationExtensionBase)extensions.remove((Object)element.getAttributeValue(this.getIdAttrName()));
            if (extension == null) {
                hasUnknownExtension = true;
                continue;
            }
            extension.readExternal(configuration, element);
        }
        if (hasUnknownExtension) {
            SmartList copy = new SmartList();
            for (Element child : children) {
                copy.add((Object)JDOMUtil.internElement((Element)child));
            }
            configuration.putCopyableUserData(RunConfigurationExtensionsManagerKt.access$getRUN_EXTENSIONS$p(), (Object)copy);
        }
    }

    public final void writeExternal(@NotNull U configuration, @NotNull Element parentNode) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)parentNode, (String)"parentNode");
        TreeMap<String, Element> map = new TreeMap<String, Element>();
        List elements = (List)configuration.getCopyableUserData(RunConfigurationExtensionsManagerKt.access$getRUN_EXTENSIONS$p());
        if (elements != null) {
            for (Element element : elements) {
                map.put(element.getAttributeValue(this.getIdAttrName()), element.clone());
            }
        }
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            RunConfigurationExtensionBase extension;
            if (!extension$iv.isApplicableFor(configuration)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)extension$iv, (String)"extension");
            boolean bl = false;
            Element element = new Element(this.getExtensionRootAttr());
            element.setAttribute(this.getIdAttrName(), extension.getSerializationId());
            try {
                extension.writeExternal(configuration, element);
            }
            catch (WriteExternalException ignored) {
                continue;
            }
            List list = element.getContent();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"element.content");
            Collection collection = list;
            boolean bl2 = false;
            if (!(!collection.isEmpty()) && element.getAttributes().size() <= 1) continue;
            map.put(extension.getSerializationId(), element);
        }
        for (Element values : map.values()) {
            parentNode.addContent(values);
        }
    }

    public final <V extends U> void appendEditors(@NotNull U configuration, @NotNull SettingsEditorGroup<V> group) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(group, (String)"group");
        this.appendEditors(configuration, group, null);
    }

    public final <V extends U> void appendEditors(@NotNull U configuration, @NotNull SettingsEditorGroup<V> group, @Nullable ExtendableSettingsEditor<V> mainEditor) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(group, (String)"group");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            SettingsEditor<U> editor;
            RunConfigurationExtensionBase it;
            if (!extension$iv.isApplicableFor(configuration)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)extension$iv, (String)"extension");
            boolean bl = false;
            if (it.createEditor(configuration) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull(editor, (String)"it.createEditor(configur\u2026ocessApplicableExtensions");
            if (mainEditor != null && editor instanceof ExtensionSettingsEditor) {
                mainEditor.addExtensionEditor(editor);
                continue;
            }
            group.addEditor(it.getEditorTitle(), editor);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void validateConfiguration(@NotNull U configuration, boolean isExecution) throws Exception {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        RunConfigurationExtensionsManager runConfigurationExtensionsManager = this;
        RunnerSettings runnerSettings$iv = null;
        boolean $i$f$processEnabledExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            RunConfigurationExtensionBase it;
            if (!extension$iv.isApplicableFor(configuration) || !extension$iv.isEnabledFor(configuration, runnerSettings$iv)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)extension$iv, (String)"extension");
            boolean bl = false;
            it.validateConfiguration(configuration, isExecution);
        }
    }

    public final void extendCreatedConfiguration(@NotNull U configuration, @NotNull Location<?> location) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(location, (String)"location");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            RunConfigurationExtensionBase it;
            if (!extension$iv.isApplicableFor(configuration)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)extension$iv, (String)"extension");
            boolean bl = false;
            it.extendCreatedConfiguration(configuration, location);
        }
    }

    public final void extendTemplateConfiguration(@NotNull U configuration) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            RunConfigurationExtensionBase it;
            if (!extension$iv.isApplicableFor(configuration)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)extension$iv, (String)"extension");
            boolean bl = false;
            it.extendTemplateConfiguration(configuration);
        }
    }

    public void patchCommandLine(@NotNull U configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull Executor executor) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkParameterIsNotNull((Object)runnerId, (String)"runnerId");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processEnabledExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            RunConfigurationExtensionBase it;
            if (!extension$iv.isApplicableFor(configuration) || !extension$iv.isEnabledFor(configuration, runnerSettings)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)extension$iv, (String)"extension");
            boolean bl = false;
            it.patchCommandLine(configuration, runnerSettings, cmdLine, runnerId, executor);
        }
    }

    public void patchCommandLine(@NotNull U configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkParameterIsNotNull((Object)runnerId, (String)"runnerId");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processEnabledExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            RunConfigurationExtensionBase it;
            if (!extension$iv.isApplicableFor(configuration) || !extension$iv.isEnabledFor(configuration, runnerSettings)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)extension$iv, (String)"extension");
            boolean bl = false;
            it.patchCommandLine(configuration, runnerSettings, cmdLine, runnerId);
        }
    }

    public void attachExtensionsToProcess(@NotNull U configuration, @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processEnabledExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            RunConfigurationExtensionBase it;
            if (!extension$iv.isApplicableFor(configuration) || !extension$iv.isEnabledFor(configuration, runnerSettings)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)extension$iv, (String)"extension");
            boolean bl = false;
            it.attachToProcess(configuration, handler, runnerSettings);
        }
    }

    @NotNull
    protected final List<T> getApplicableExtensions(@NotNull U configuration) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        SmartList extensions = new SmartList();
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            RunConfigurationExtensionBase it;
            if (!extension$iv.isApplicableFor(configuration)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)extension$iv, (String)"extension");
            boolean bl = false;
            extensions.add((Object)it);
        }
        return (List)extensions;
    }

    protected final void processApplicableExtensions(@NotNull U configuration, @NotNull Function1<? super T, Unit> handler) {
        int $i$f$processApplicableExtensions = 0;
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        for (RunConfigurationExtensionBase extension : this.getExtensionPoint().getIterable()) {
            if (!extension.isApplicableFor(configuration)) continue;
            RunConfigurationExtensionBase runConfigurationExtensionBase = extension;
            Intrinsics.checkExpressionValueIsNotNull((Object)runConfigurationExtensionBase, (String)"extension");
            handler.invoke((Object)runConfigurationExtensionBase);
        }
    }

    protected final void processEnabledExtensions(@NotNull U configuration, @Nullable RunnerSettings runnerSettings, @NotNull Function1<? super T, Unit> handler) {
        int $i$f$processEnabledExtensions = 0;
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        for (RunConfigurationExtensionBase extension : this.getExtensionPoint().getIterable()) {
            if (!extension.isApplicableFor(configuration) || !extension.isEnabledFor(configuration, runnerSettings)) continue;
            RunConfigurationExtensionBase runConfigurationExtensionBase = extension;
            Intrinsics.checkExpressionValueIsNotNull((Object)runConfigurationExtensionBase, (String)"extension");
            handler.invoke((Object)runConfigurationExtensionBase);
        }
    }

    @NotNull
    public final ExtensionPointName<T> getExtensionPoint() {
        return this.extensionPoint;
    }

    public RunConfigurationExtensionsManager(@NotNull ExtensionPointName<T> extensionPoint) {
        Intrinsics.checkParameterIsNotNull(extensionPoint, (String)"extensionPoint");
        this.extensionPoint = extensionPoint;
        this.idAttrName = "ID";
        this.extensionRootAttr = "EXTENSION";
    }
}

