/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NotNullLazyValue;
import java.awt.AWTEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface EventWatcher {
    @NotNull
    public static final NotNullLazyValue<Boolean> IS_ENABLED = NotNullLazyValue.createValue(() -> Boolean.getBoolean("idea.event.queue.dispatch.listen"));

    public static boolean isEnabled() {
        return (Boolean)IS_ENABLED.getValue();
    }

    @Nullable
    public static EventWatcher getInstance() {
        if (!EventWatcher.isEnabled()) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isDisposed()) {
            return null;
        }
        application.assertIsDispatchThread();
        return (EventWatcher)application.getService(EventWatcher.class);
    }

    public void runnableStarted(@NotNull Runnable var1, long var2);

    public void runnableFinished(@NotNull Runnable var1, long var2);

    public void edtEventStarted(@NotNull AWTEvent var1);

    public void edtEventFinished(@NotNull AWTEvent var1, long var2);
}

