/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.MapDataContext;
import com.intellij.testFramework.PerformanceTestInfo;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.io.Decompressor;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.Equality;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.InvocationEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.junit.Assert;

public class PlatformTestUtil {
    private static final Logger LOG = Logger.getInstance(PlatformTestUtil.class);
    public static final boolean COVERAGE_ENABLED_BUILD = "true".equals(System.getProperty("idea.coverage.enabled.build"));
    private static final List<Runnable> ourProjectCleanups = new CopyOnWriteArrayList<Runnable>();
    private static final long MAX_WAIT_TIME = TimeUnit.MINUTES.toMillis(2L);
    private static final OutputStream NULL = new OutputStream(){

        @Override
        public void write(int b) {
        }
    };

    @NotNull
    public static String getTestName(@NotNull String name, boolean lowercaseFirstLetter) {
        if (name == null) {
            PlatformTestUtil.$$$reportNull$$$0(0);
        }
        return StringUtil.isEmpty((String)(name = StringUtil.trimStart((String)name, (String)"test"))) ? "" : PlatformTestUtil.lowercaseFirstLetter(name, lowercaseFirstLetter);
    }

    @NotNull
    public static String lowercaseFirstLetter(@NotNull String name, boolean lowercaseFirstLetter) {
        if (name == null) {
            PlatformTestUtil.$$$reportNull$$$0(1);
        }
        if (lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        String string = name;
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isAllUppercaseName(@NotNull String name) {
        if (name == null) {
            PlatformTestUtil.$$$reportNull$$$0(3);
        }
        int uppercaseChars = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isLowerCase(name.charAt(i))) {
                return false;
            }
            if (!Character.isUpperCase(name.charAt(i))) continue;
            ++uppercaseChars;
        }
        return uppercaseChars >= 3;
    }

    public static <T> void maskExtensions(@NotNull ProjectExtensionPointName<T> pointName, @NotNull Project project2, @NotNull List<T> newExtensions, @NotNull Disposable parentDisposable) {
        if (pointName == null) {
            PlatformTestUtil.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(5);
        }
        if (newExtensions == null) {
            PlatformTestUtil.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            PlatformTestUtil.$$$reportNull$$$0(7);
        }
        ((ExtensionPointImpl)pointName.getPoint((AreaInstance)project2)).maskAll(newExtensions, parentDisposable, true);
    }

    @Nullable
    public static String toString(@Nullable Object node, @Nullable Queryable.PrintInfo printInfo) {
        if (node instanceof AbstractTreeNode) {
            if (printInfo != null) {
                return ((AbstractTreeNode)node).toTestString(printInfo);
            }
            return ((AbstractTreeNode)node).getTestPresentation();
        }
        return String.valueOf(node);
    }

    public static String print(JTree tree, boolean withSelection) {
        return PlatformTestUtil.print(tree, new TreePath(tree.getModel().getRoot()), withSelection, null, null);
    }

    public static String print(JTree tree, TreePath path, @Nullable Queryable.PrintInfo printInfo, boolean withSelection) {
        return PlatformTestUtil.print(tree, path, withSelection, printInfo, null);
    }

    public static String print(JTree tree, boolean withSelection, @Nullable Predicate<? super String> nodePrintCondition) {
        return PlatformTestUtil.print(tree, new TreePath(tree.getModel().getRoot()), withSelection, null, nodePrintCondition);
    }

    private static String print(JTree tree, TreePath path, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        return StringUtil.join(PlatformTestUtil.printAsList(tree, path, withSelection, printInfo, nodePrintCondition), (String)"\n");
    }

    private static Collection<String> printAsList(JTree tree, TreePath path, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        ArrayList<String> strings = new ArrayList<String>();
        PlatformTestUtil.printImpl(tree, path, strings, 0, withSelection, printInfo, nodePrintCondition);
        return strings;
    }

    private static void printImpl(JTree tree, TreePath path, Collection<? super String> strings, int level, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        Object pathComponent = path.getLastPathComponent();
        Object userObject = TreeUtil.getUserObject((Object)pathComponent);
        String nodeText = PlatformTestUtil.toString(userObject, printInfo);
        if (nodePrintCondition != null && !nodePrintCondition.test(nodeText)) {
            return;
        }
        StringBuilder buff = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)buff, (char)' ', (int)level);
        boolean expanded = tree.isExpanded(path);
        int childCount = tree.getModel().getChildCount(pathComponent);
        if (childCount > 0) {
            buff.append(expanded ? "-" : "+");
        }
        boolean selected = tree.getSelectionModel().isPathSelected(path);
        if (withSelection && selected) {
            buff.append("[");
        }
        buff.append(nodeText);
        if (withSelection && selected) {
            buff.append("]");
        }
        strings.add(buff.toString());
        if (expanded) {
            for (int i = 0; i < childCount; ++i) {
                TreePath childPath = path.pathByAddingChild(tree.getModel().getChild(pathComponent, i));
                PlatformTestUtil.printImpl(tree, childPath, strings, level + 1, withSelection, printInfo, nodePrintCondition);
            }
        }
    }

    public static void assertTreeEqual(JTree tree, @NonNls String expected) {
        PlatformTestUtil.assertTreeEqual(tree, expected, false);
    }

    public static void assertTreeEqual(JTree tree, String expected, boolean checkSelected) {
        String treeStringPresentation = PlatformTestUtil.print(tree, checkSelected);
        Assert.assertEquals((Object)expected.trim(), (Object)treeStringPresentation.trim());
    }

    public static void expand(JTree tree, int ... rows) {
        for (int row : rows) {
            tree.expandRow(row);
            PlatformTestUtil.waitWhileBusy(tree);
        }
    }

    public static void expandAll(JTree tree) {
        PlatformTestUtil.waitForPromise(TreeUtil.promiseExpandAll((JTree)tree));
    }

    private static long getMillisSince(long startTimeMillis) {
        return System.currentTimeMillis() - startTimeMillis;
    }

    private static void assertMaxWaitTimeSince(long startTimeMillis) {
        PlatformTestUtil.assertMaxWaitTimeSince(startTimeMillis, MAX_WAIT_TIME);
    }

    private static void assertMaxWaitTimeSince(long startTimeMillis, long timeout) {
        long took = PlatformTestUtil.getMillisSince(startTimeMillis);
        assert (took <= timeout) : String.format("the waiting takes too long. Expected to take no more than: %d ms but took: %d ms", timeout, took);
    }

    private static void assertDispatchThreadWithoutWriteAccess() {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess(ApplicationManager.getApplication());
    }

    private static void assertDispatchThreadWithoutWriteAccess(Application application) {
        if (application != null) {
            assert (!application.isWriteAccessAllowed()) : "do not wait under write action to avoid possible deadlock";
            assert (application.isDispatchThread());
        } else assert (EventQueue.isDispatchThread());
    }

    private static boolean isBusy(JTree tree, TreeModel model) {
        UIUtil.dispatchAllInvocationEvents();
        if (model instanceof AsyncTreeModel) {
            AsyncTreeModel async = (AsyncTreeModel)model;
            if (async.isProcessing()) {
                return true;
            }
            UIUtil.dispatchAllInvocationEvents();
            return async.isProcessing();
        }
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor((JTree)tree);
        if (builder == null) {
            return false;
        }
        AbstractTreeUi ui = builder.getUi();
        if (ui == null) {
            return false;
        }
        return ui.hasPendingWork();
    }

    public static void waitWhileBusy(JTree tree) {
        PlatformTestUtil.waitWhileBusy(tree, tree.getModel());
    }

    public static void waitWhileBusy(JTree tree, TreeModel model) {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long startTimeMillis = System.currentTimeMillis();
        while (PlatformTestUtil.isBusy(tree, model)) {
            PlatformTestUtil.assertMaxWaitTimeSince(startTimeMillis);
            TimeoutUtil.sleep((long)5L);
        }
    }

    public static void waitForCallback(@NotNull ActionCallback callback) {
        if (callback == null) {
            PlatformTestUtil.$$$reportNull$$$0(8);
        }
        AsyncPromise promise = new AsyncPromise();
        callback.doWhenDone(() -> promise.setResult(null)).doWhenRejected(() -> promise.cancel());
        PlatformTestUtil.waitForPromise(promise);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(9);
        }
        return PlatformTestUtil.waitForPromise(promise, MAX_WAIT_TIME);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise, long timeout) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(10);
        }
        return PlatformTestUtil.waitForPromise(promise, timeout, false);
    }

    public static <T> T assertPromiseSucceeds(@NotNull Promise<T> promise) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(11);
        }
        return PlatformTestUtil.waitForPromise(promise, MAX_WAIT_TIME, true);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static <T> T waitForPromise(@NotNull Promise<T> promise, long timeout, boolean bl) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(12);
        }
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long start = System.currentTimeMillis();
        while (true) {
            if (promise.getState() == Promise.State.PENDING) {
                UIUtil.dispatchAllInvocationEvents();
            }
            try {
                return (T)promise.blockingGet(20, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                void assertSucceeded;
                if (assertSucceeded != false) {
                    throw new AssertionError((Object)e);
                }
                return null;
            }
            PlatformTestUtil.assertMaxWaitTimeSince(start, timeout);
        }
    }

    public static <T> T waitForFuture(@NotNull Future<T> future, long timeoutMillis) {
        if (future == null) {
            PlatformTestUtil.$$$reportNull$$$0(13);
        }
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long start = System.currentTimeMillis();
        while (true) {
            if (!future.isDone()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            PlatformTestUtil.assertMaxWaitTimeSince(start, timeoutMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAlarm(int delay) {
        @NotNull Application app = ApplicationManager.getApplication();
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        Disposable tempDisposable = Disposer.newDisposable();
        AtomicBoolean runnableInvoked = new AtomicBoolean();
        AtomicBoolean pooledRunnableInvoked = new AtomicBoolean();
        AtomicBoolean alarmInvoked1 = new AtomicBoolean();
        AtomicBoolean alarmInvoked2 = new AtomicBoolean();
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        Alarm pooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, tempDisposable);
        ModalityState initialModality = ModalityState.current();
        alarm.addRequest(() -> {
            alarmInvoked1.set(true);
            app.invokeLater(() -> {
                runnableInvoked.set(true);
                alarm.addRequest(() -> alarmInvoked2.set(true), delay);
            });
        }, delay);
        pooledAlarm.addRequest(() -> pooledRunnableInvoked.set(true), delay);
        UIUtil.dispatchAllInvocationEvents();
        long start = System.currentTimeMillis();
        try {
            boolean sleptAlready = false;
            while (!alarmInvoked2.get()) {
                AtomicBoolean laterInvoked = new AtomicBoolean();
                app.invokeLater(() -> laterInvoked.set(true));
                UIUtil.dispatchAllInvocationEvents();
                Assert.assertTrue((boolean)laterInvoked.get());
                TimeoutUtil.sleep((long)(sleptAlready ? 10L : (long)delay));
                sleptAlready = true;
                if (PlatformTestUtil.getMillisSince(start) <= MAX_WAIT_TIME) continue;
                String queue = ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).dumpQueue();
                throw new AssertionError((Object)("Couldn't await alarm; alarm passed=" + alarmInvoked1.get() + "; modality1=" + initialModality + "; modality2=" + ModalityState.current() + "; non-modal=" + (initialModality == ModalityState.NON_MODAL) + "; invokeLater passed=" + runnableInvoked.get() + "; pooled alarm passed=" + pooledRunnableInvoked.get() + "; app.disposed=" + app.isDisposed() + "; alarm.disposed=" + alarm.isDisposed() + "; alarm.requests=" + alarm.getActiveRequestCount() + "\n delayQueue=" + StringUtil.trimLog((String)queue, (int)1000) + "\n invocatorEdtQueue=" + LaterInvocator.getLaterInvocatorEdtQueue() + "\n invocatorWtQueue=" + LaterInvocator.getLaterInvocatorWtQueue()));
            }
        }
        finally {
            Disposer.dispose((Disposable)tempDisposable);
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void dispatchAllInvocationEventsInIdeEventQueue() {
        AWTEvent event;
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (!(event instanceof InvocationEvent)) continue;
                eventQueue.dispatchEvent(event);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void dispatchAllEventsInIdeEventQueue() throws InterruptedException {
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while (PlatformTestUtil.dispatchNextEventIfAny(eventQueue) != null) {
        }
    }

    public static AWTEvent dispatchNextEventIfAny(@NotNull IdeEventQueue eventQueue) throws InterruptedException {
        if (eventQueue == null) {
            PlatformTestUtil.$$$reportNull$$$0(14);
        }
        assert (SwingUtilities.isEventDispatchThread()) : Thread.currentThread();
        AWTEvent event = eventQueue.peekEvent();
        if (event == null) {
            return null;
        }
        AWTEvent event1 = eventQueue.getNextEvent();
        eventQueue.dispatchEvent(event1);
        return event1;
    }

    public static StringBuilder print(AbstractTreeStructure structure, Object node, int currentLevel, @Nullable Comparator<?> comparator, int maxRowCount, char paddingChar, @Nullable Queryable.PrintInfo printInfo) {
        return PlatformTestUtil.print(structure, node, currentLevel, comparator, maxRowCount, paddingChar, (Object o) -> PlatformTestUtil.toString(o, printInfo));
    }

    public static String print(AbstractTreeStructure structure, Object node, Function<Object, String> nodePresenter) {
        return PlatformTestUtil.print(structure, node, 0, Comparator.comparing(nodePresenter), -1, ' ', nodePresenter).toString();
    }

    private static StringBuilder print(AbstractTreeStructure structure, Object node, int currentLevel, @Nullable Comparator<?> comparator, int maxRowCount, char paddingChar, Function<Object, String> nodePresenter) {
        StringBuilder buffer = new StringBuilder();
        PlatformTestUtil.doPrint(buffer, currentLevel, node, structure, comparator, maxRowCount, 0, paddingChar, nodePresenter);
        return buffer;
    }

    private static int doPrint(StringBuilder buffer, int currentLevel, Object node, AbstractTreeStructure structure, @Nullable Comparator<?> comparator, int maxRowCount, int currentLine, char paddingChar, Function<Object, String> nodePresenter) {
        if (currentLine >= maxRowCount && maxRowCount != -1) {
            return currentLine;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)paddingChar, (int)currentLevel);
        buffer.append(nodePresenter.apply(node)).append("\n");
        ++currentLine;
        Object[] children = structure.getChildElements(node);
        if (comparator != null) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(children));
            Comparator<?> c = comparator;
            Collections.sort(list, c);
            children = ArrayUtil.toObjectArray(list);
        }
        for (Object child : children) {
            currentLine = PlatformTestUtil.doPrint(buffer, currentLevel + 1, child, structure, comparator, maxRowCount, currentLine, paddingChar, nodePresenter);
        }
        return currentLine;
    }

    public static String print(Object[] objects) {
        return PlatformTestUtil.print(Arrays.asList(objects));
    }

    public static String print(Collection<?> c) {
        return c.stream().map(each -> PlatformTestUtil.toString(each, null)).collect(Collectors.joining("\n"));
    }

    public static String print(@NotNull ListModel<?> model) {
        if (model == null) {
            PlatformTestUtil.$$$reportNull$$$0(15);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < model.getSize(); ++i) {
            result.append(PlatformTestUtil.toString(model.getElementAt(i), null));
            result.append("\n");
        }
        return result.toString();
    }

    public static String print(JTree tree) {
        return PlatformTestUtil.print(tree, false);
    }

    public static void invokeNamedAction(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        Assert.assertNotNull((Object)action);
        Presentation presentation = new Presentation();
        DataContext context = DataManager.getInstance().getDataContext();
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)context);
        action.beforeActionPerformedUpdate(event);
        Assert.assertTrue((boolean)presentation.isEnabled());
        action.actionPerformed(event);
    }

    public static void assertTiming(String message, long expectedMs, long actual) {
        if (COVERAGE_ENABLED_BUILD) {
            return;
        }
        long expectedOnMyMachine = Math.max(1L, expectedMs * Timings.CPU_TIMING / 200L);
        String logMessage = message;
        if (actual > expectedOnMyMachine) {
            int percentage = (int)(100.0 * (double)(actual - expectedOnMyMachine) / (double)expectedOnMyMachine);
            logMessage = logMessage + ". Operation took " + percentage + "% longer than expected";
        }
        logMessage = logMessage + ". Expected on my machine: " + expectedOnMyMachine + ". Actual: " + actual + ". Expected on Standard machine: " + expectedMs + "; Timings: CPU=" + Timings.CPU_TIMING + ", I/O=" + Timings.IO_TIMING + ".";
        double acceptableChangeFactor = 1.1;
        if (actual < expectedOnMyMachine) {
            System.out.println(logMessage);
            TeamCityLogger.info((String)logMessage);
        } else if ((double)actual < (double)expectedOnMyMachine * 1.1) {
            TeamCityLogger.warning((String)logMessage, null);
        } else {
            throw new AssertionFailedError(logMessage);
        }
    }

    @Contract(pure=true)
    public static PerformanceTestInfo startPerformanceTest(@NonNls @NotNull String what, int expectedMs, @NotNull ThrowableRunnable<?> test) {
        if (what == null) {
            PlatformTestUtil.$$$reportNull$$$0(16);
        }
        if (test == null) {
            PlatformTestUtil.$$$reportNull$$$0(17);
        }
        return new PerformanceTestInfo(test, expectedMs, what);
    }

    public static void assertPathsEqual(@Nullable String expected, @Nullable String actual) {
        if (expected != null) {
            expected = FileUtil.toSystemIndependentName((String)expected);
        }
        if (actual != null) {
            actual = FileUtil.toSystemIndependentName((String)actual);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @NotNull
    public static String getJavaExe() {
        String string = SystemProperties.getJavaHome() + (SystemInfo.isWindows ? "\\bin\\java.exe" : "/bin/java");
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static URL getRtJarURL() {
        URL uRL;
        String home = SystemProperties.getJavaHome();
        try {
            uRL = JavaVersion.current().feature >= 9 ? new URL("jrt:" + home) : new File(home + "/lib/rt.jar").toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (uRL == null) {
            PlatformTestUtil.$$$reportNull$$$0(19);
        }
        return uRL;
    }

    public static void forceCloseProjectWithoutSaving(@NotNull Project project2) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(20);
        }
        ProjectManagerEx.getInstanceEx().forceCloseProject(project2);
    }

    public static void saveProject(@NotNull Project project2) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(21);
        }
        PlatformTestUtil.saveProject(project2, false);
    }

    public static void saveProject(@NotNull Project project2, boolean isForceSavingAllSettings) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(22);
        }
        StoreReloadManager.getInstance().flushChangedProjectFileAlarm();
        StateStorageManagerKt.saveComponentManager((ComponentManager)project2, (boolean)isForceSavingAllSettings);
    }

    static void waitForAllBackgroundActivityToCalmDown() {
        CpuUsageData data;
        for (int i = 0; i < 50 && (data = CpuUsageData.measureCpuUsage(() -> TimeoutUtil.sleep((long)100L))).hasAnyActivityBesides(Thread.currentThread()); ++i) {
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(String message, long expected, @NotNull Runnable runnable) {
        void actionToMeasure;
        if (runnable == null) {
            PlatformTestUtil.$$$reportNull$$$0(23);
        }
        PlatformTestUtil.assertTiming(message, expected, 4, (Runnable)actionToMeasure);
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(String message, long expected, int attempts, @NotNull Runnable runnable) {
        if (runnable == null) {
            PlatformTestUtil.$$$reportNull$$$0(24);
        }
        while (true) {
            void actionToMeasure;
            --attempts;
            PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
            long duration = TimeoutUtil.measureExecutionTime(((Runnable)actionToMeasure)::run);
            try {
                PlatformTestUtil.assertTiming(message, expected, duration);
            }
            catch (AssertionFailedError e) {
                if (attempts == 0) {
                    throw e;
                }
                System.gc();
                System.gc();
                System.gc();
                String s = e.getMessage() + "\n  " + attempts + " " + StringUtil.pluralize((String)"attempt", (int)attempts) + " remain";
                TeamCityLogger.warning((String)s, null);
                System.err.println(s);
                continue;
            }
            break;
        }
    }

    private static Map<String, VirtualFile> buildNameToFileMap(VirtualFile[] files, @Nullable VirtualFileFilter filter) {
        HashMap<String, VirtualFile> map = new HashMap<String, VirtualFile>();
        for (VirtualFile file2 : files) {
            if (filter != null && !filter.accept(file2)) continue;
            map.put(file2.getName(), file2);
        }
        return map;
    }

    public static void assertDirectoriesEqual(VirtualFile dirExpected, VirtualFile dirActual) throws IOException {
        PlatformTestUtil.assertDirectoriesEqual(dirExpected, dirActual, null);
    }

    public static void assertDirectoriesEqual(VirtualFile dirExpected, VirtualFile dirActual, @Nullable VirtualFileFilter fileFilter) throws IOException {
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile[] childrenAfter = dirExpected.getChildren();
        PlatformTestUtil.shallowCompare(dirExpected, childrenAfter);
        VirtualFile[] childrenBefore = dirActual.getChildren();
        PlatformTestUtil.shallowCompare(dirActual, childrenBefore);
        Map<String, VirtualFile> mapAfter = PlatformTestUtil.buildNameToFileMap(childrenAfter, fileFilter);
        Map<String, VirtualFile> mapBefore = PlatformTestUtil.buildNameToFileMap(childrenBefore, fileFilter);
        Set<String> keySetAfter = mapAfter.keySet();
        Set<String> keySetBefore = mapBefore.keySet();
        Assert.assertEquals((String)dirExpected.getPath(), keySetAfter, keySetBefore);
        for (String name : keySetAfter) {
            VirtualFile fileAfter = mapAfter.get(name);
            VirtualFile fileBefore = mapBefore.get(name);
            if (fileAfter.isDirectory()) {
                PlatformTestUtil.assertDirectoriesEqual(fileAfter, fileBefore, fileFilter);
                continue;
            }
            PlatformTestUtil.assertFilesEqual(fileAfter, fileBefore);
        }
    }

    private static void shallowCompare(VirtualFile dir, VirtualFile[] vfs) {
        if (dir.isInLocalFileSystem() && dir.getFileSystem() != TempFileSystem.getInstance()) {
            String vfsPaths = Stream.of(vfs).map(VirtualFile::getPath).sorted().collect(Collectors.joining("\n"));
            File[] io = PlatformTestUtil.notNull(new File(dir.getPath()).listFiles());
            String ioPaths = Stream.of(io).map(f -> FileUtil.toSystemIndependentName((String)f.getPath())).sorted().collect(Collectors.joining("\n"));
            Assert.assertEquals((Object)vfsPaths, (Object)ioPaths);
        }
    }

    public static void assertFilesEqual(VirtualFile fileExpected, VirtualFile fileActual) throws IOException {
        block3: {
            try {
                PlatformTestUtil.assertJarFilesEqual(VfsUtilCore.virtualToIoFile((VirtualFile)fileExpected), VfsUtilCore.virtualToIoFile((VirtualFile)fileActual));
            }
            catch (IOException e) {
                String actual = PlatformTestUtil.fileText(fileActual);
                String expected = PlatformTestUtil.fileText(fileExpected);
                if (expected == null || actual == null) {
                    Assert.assertArrayEquals((String)fileExpected.getPath(), (byte[])fileExpected.contentsToByteArray(), (byte[])fileActual.contentsToByteArray());
                }
                if (StringUtil.equals((CharSequence)expected, (CharSequence)actual)) break block3;
                throw new FileComparisonFailure("Text mismatch in the file " + fileExpected.getName(), expected, actual, fileExpected.getPath());
            }
        }
    }

    private static String fileText(VirtualFile file2) throws IOException {
        Document doc = FileDocumentManager.getInstance().getDocument(file2);
        if (doc != null) {
            return doc.getText();
        }
        if (!file2.getFileType().isBinary() || FileTypeRegistry.getInstance().isFileOfType(file2, FileTypes.UNKNOWN)) {
            return LoadTextUtil.getTextByBinaryPresentation((byte[])file2.contentsToByteArray(false), (VirtualFile)file2).toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertJarFilesEqual(File file1, File file2) throws IOException {
        File tempDir = FileUtilRt.createTempDirectory((String)"assert_jar_tmp", null, (boolean)false);
        try {
            File tempDirectory1 = new File(tempDir, "tmp1");
            File tempDirectory2 = new File(tempDir, "tmp2");
            FileUtilRt.createDirectory((File)tempDirectory1);
            FileUtilRt.createDirectory((File)tempDirectory2);
            try (JarFile jarFile1 = new JarFile(file1);
                 JarFile jarFile2 = new JarFile(file2);){
                new Decompressor.Zip(new File(jarFile1.getName())).extract(tempDirectory1);
                new Decompressor.Zip(new File(jarFile2.getName())).extract(tempDirectory2);
            }
            VirtualFile dirAfter = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory1);
            Assert.assertNotNull((String)tempDirectory1.toString(), (Object)dirAfter);
            VirtualFile dirBefore = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory2);
            Assert.assertNotNull((String)tempDirectory2.toString(), (Object)dirBefore);
            ApplicationManager.getApplication().runWriteAction(() -> {
                dirAfter.refresh(false, true);
                dirBefore.refresh(false, true);
            });
            PlatformTestUtil.assertDirectoriesEqual(dirAfter, dirBefore);
        }
        finally {
            FileUtilRt.delete((File)tempDir);
        }
    }

    @NotNull
    public static String getCommunityPath() {
        String homePath = IdeaTestExecutionPolicy.getHomePathWithPolicy();
        if (new File(homePath, "community/.idea").isDirectory()) {
            String string = homePath + File.separatorChar + "community";
            if (string == null) {
                PlatformTestUtil.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = homePath;
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getPlatformTestDataPath() {
        String string = PlatformTestUtil.getCommunityPath().replace(File.separatorChar, '/') + "/platform/platform-tests/testData/";
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static Comparator<AbstractTreeNode<?>> createComparator(Queryable.PrintInfo printInfo) {
        Comparator comparator = (o1, o2) -> {
            String displayText1 = o1.toTestString(printInfo);
            String displayText2 = o2.toTestString(printInfo);
            return Comparing.compare((Comparable)((Object)displayText1), (Comparable)((Object)displayText2));
        };
        if (comparator == null) {
            PlatformTestUtil.$$$reportNull$$$0(28);
        }
        return comparator;
    }

    @NotNull
    public static <T> T notNull(@Nullable T t) {
        Assert.assertNotNull(t);
        T t2 = t;
        if (t2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(29);
        }
        return t2;
    }

    @NotNull
    public static String loadFileText(@NotNull String fileName) throws IOException {
        if (fileName == null) {
            PlatformTestUtil.$$$reportNull$$$0(30);
        }
        String string = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)new File(fileName)));
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    public static void withEncoding(@NotNull String encoding, @NotNull ThrowableRunnable<?> r) {
        if (encoding == null) {
            PlatformTestUtil.$$$reportNull$$$0(32);
        }
        if (r == null) {
            PlatformTestUtil.$$$reportNull$$$0(33);
        }
        Charset.forName(encoding);
        try {
            Charset oldCharset = Charset.defaultCharset();
            try {
                PlatformTestUtil.patchSystemFileEncoding(encoding);
                r.run();
            }
            finally {
                PlatformTestUtil.patchSystemFileEncoding(oldCharset.name());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void patchSystemFileEncoding(String encoding) {
        ReflectionUtil.resetField(Charset.class, Charset.class, (String)"defaultCharset");
        System.setProperty("file.encoding", encoding);
    }

    public static void withStdErrSuppressed(@NotNull Runnable r) {
        if (r == null) {
            PlatformTestUtil.$$$reportNull$$$0(34);
        }
        PrintStream std = System.err;
        System.setErr(new PrintStream(NULL));
        try {
            r.run();
        }
        finally {
            System.setErr(std);
        }
    }

    public static void assertSuccessful(@NotNull GeneralCommandLine command) {
        if (command == null) {
            PlatformTestUtil.$$$reportNull$$$0(35);
        }
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)command.withRedirectErrorStream(true));
            Assert.assertEquals((String)output.getStdout(), (long)0L, (long)output.getExitCode());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static List<WebReference> collectWebReferences(@NotNull PsiElement element) {
        if (element == null) {
            PlatformTestUtil.$$$reportNull$$$0(36);
        }
        final ArrayList<WebReference> refs = new ArrayList<WebReference>();
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (PsiReference ref : element.getReferences()) {
                    if (!(ref instanceof WebReference)) continue;
                    refs.add((WebReference)ref);
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/PlatformTestUtil$2", "visitElement"));
            }
        });
        ArrayList<WebReference> arrayList = refs;
        if (arrayList == null) {
            PlatformTestUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    public static <T extends PsiReference> T getReferenceOfTypeWithAssertion(@Nullable PsiReference reference, Class<T> refType) {
        if (refType.isInstance(reference)) {
            PsiReference psiReference = reference;
            if (psiReference == null) {
                PlatformTestUtil.$$$reportNull$$$0(38);
            }
            return (T)psiReference;
        }
        if (reference instanceof PsiMultiReference) {
            PsiReference[] psiReferences;
            for (PsiReference psiReference : psiReferences = ((PsiMultiReference)reference).getReferences()) {
                if (!refType.isInstance(psiReference)) continue;
                PsiReference psiReference2 = psiReference;
                if (psiReference2 == null) {
                    PlatformTestUtil.$$$reportNull$$$0(39);
                }
                return (T)psiReference2;
            }
        }
        throw new AssertionError((Object)("given reference should be " + refType + " but " + (reference != null ? reference.getClass() : null) + " was given"));
    }

    public static void registerProjectCleanup(@NotNull Runnable cleanup) {
        if (cleanup == null) {
            PlatformTestUtil.$$$reportNull$$$0(40);
        }
        ourProjectCleanups.add(cleanup);
    }

    public static void cleanupAllProjects() {
        for (Runnable each : ourProjectCleanups) {
            each.run();
        }
        ourProjectCleanups.clear();
    }

    public static void captureMemorySnapshot() {
        try {
            String className = "com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler";
            Method snapshot = ReflectionUtil.getMethod(Class.forName(className), (String)"captureMemorySnapshot", (Class[])new Class[0]);
            if (snapshot != null) {
                Object path = snapshot.invoke(null, new Object[0]);
                System.out.println("Memory snapshot captured to '" + path + "'");
            }
        }
        catch (ClassNotFoundException className) {
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static <T> void assertComparisonContractNotViolated(@NotNull List<? extends T> values, @NotNull Comparator<? super T> comparator, @NotNull Equality<? super T> equality) {
        if (values == null) {
            PlatformTestUtil.$$$reportNull$$$0(41);
        }
        if (comparator == null) {
            PlatformTestUtil.$$$reportNull$$$0(42);
        }
        if (equality == null) {
            PlatformTestUtil.$$$reportNull$$$0(43);
        }
        for (int i1 = 0; i1 < values.size(); ++i1) {
            for (int i2 = i1; i2 < values.size(); ++i2) {
                T value1 = values.get(i1);
                T value2 = values.get(i2);
                int result12 = comparator.compare(value1, value2);
                int result21 = comparator.compare(value2, value1);
                if (equality.equals(value1, value2)) {
                    Assert.assertEquals((String)String.format("Equal, but not 0: '%s' - '%s'", value1, value2), (long)0L, (long)result12);
                    Assert.assertEquals((String)String.format("Equal, but not 0: '%s' - '%s'", value2, value1), (long)0L, (long)result21);
                } else {
                    if (result12 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value1, value2));
                    }
                    if (result21 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value2, value1));
                    }
                    if (Integer.signum(result12) == Integer.signum(result21)) {
                        Assert.fail((String)String.format("Not symmetrical: '%s' - '%s'", value1, value2));
                    }
                }
                for (int i3 = i2; i3 < values.size(); ++i3) {
                    int result31;
                    T value3 = values.get(i3);
                    int result23 = comparator.compare(value2, value3);
                    if (PlatformTestUtil.isTransitive(result12, result23, result31 = comparator.compare(value3, value1))) continue;
                    Assert.fail((String)String.format("Not transitive: '%s' - '%s' - '%s'", value1, value2, value3));
                }
            }
        }
    }

    private static boolean isTransitive(int result12, int result23, int result31) {
        if (result12 == 0 && result23 == 0 && result31 == 0) {
            return true;
        }
        if (result12 > 0 && result23 > 0 && result31 > 0) {
            return false;
        }
        if (result12 < 0 && result23 < 0 && result31 < 0) {
            return false;
        }
        if (result12 == 0 && Integer.signum(result23) * Integer.signum(result31) >= 0) {
            return false;
        }
        if (result23 == 0 && Integer.signum(result12) * Integer.signum(result31) >= 0) {
            return false;
        }
        return result31 != 0 || Integer.signum(result23) * Integer.signum(result12) < 0;
    }

    public static void setLongMeaninglessFileIncludeTemplateTemporarilyFor(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(44);
        }
        if (parentDisposable == null) {
            PlatformTestUtil.$$$reportNull$$$0(45);
        }
        FileTemplateManagerImpl templateManager = (FileTemplateManagerImpl)FileTemplateManager.getInstance((Project)project2);
        templateManager.setDefaultFileIncludeTemplateTextTemporarilyForTest("File Header", "/**\n * Created by ${USER} on ${DATE}.\n */\n", parentDisposable);
    }

    @NotNull
    public static VirtualFile getOrCreateProjectTestBaseDir(@NotNull Project project2) {
        block6: {
            VirtualFile virtualFile;
            if (project2 == null) {
                PlatformTestUtil.$$$reportNull$$$0(46);
            }
            try {
                String path = Objects.requireNonNull(project2.getBasePath());
                VirtualFile result = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                if (result == null) break block6;
                virtualFile = result;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (virtualFile == null) {
                PlatformTestUtil.$$$reportNull$$$0(47);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = Objects.requireNonNull(VfsUtil.createDirectories((String)Objects.requireNonNull(project2.getBasePath())));
        if (virtualFile == null) {
            PlatformTestUtil.$$$reportNull$$$0(48);
        }
        return virtualFile;
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(@NotNull PsiElement element, @NotNull RunConfigurationProducer producer) {
        if (element == null) {
            PlatformTestUtil.$$$reportNull$$$0(49);
        }
        if (producer == null) {
            PlatformTestUtil.$$$reportNull$$$0(50);
        }
        MapDataContext dataContext = new MapDataContext();
        dataContext.put(CommonDataKeys.PROJECT, element.getProject());
        dataContext.put(LangDataKeys.MODULE, ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
        Location location = PsiLocation.fromPsiElement((PsiElement)element);
        dataContext.put(Location.DATA_KEY, location);
        ConfigurationContext cc = ConfigurationContext.getFromContext((DataContext)dataContext);
        ConfigurationFromContext configuration = producer.createConfigurationFromContext(cc);
        return configuration != null ? configuration.getConfiguration() : null;
    }

    public static ExecutionEnvironment executeConfiguration(@NotNull RunConfiguration runConfiguration) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(51);
        }
        return PlatformTestUtil.executeConfiguration(runConfiguration, "Run");
    }

    public static ExecutionEnvironment executeConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull String executorId) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(52);
        }
        if (executorId == null) {
            PlatformTestUtil.$$$reportNull$$$0(53);
        }
        Project project2 = runConfiguration.getProject();
        ConfigurationFactory factory = runConfiguration.getFactory();
        if (factory == null) {
            Assert.fail((String)("No factory found for: " + runConfiguration));
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)project2).createConfiguration(runConfiguration, factory);
        ProgramRunner runner = ProgramRunner.getRunner((String)executorId, (RunProfile)runConfiguration);
        if (runner == null) {
            Assert.fail((String)("No runner found for: " + executorId + " and " + runConfiguration));
        }
        final Ref refRunContentDescriptor = new Ref();
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironment(DefaultRunExecutor.getRunExecutorInstance(), runner, runnerAndConfigurationSettings, project2);
        final CountDownLatch latch = new CountDownLatch(1);
        ProgramRunnerUtil.executeConfigurationAsync((ExecutionEnvironment)executionEnvironment, (boolean)false, (boolean)false, (ProgramRunner.Callback)new ProgramRunner.Callback(){

            public void processStarted(RunContentDescriptor descriptor) {
                LOG.debug("Process started");
                refRunContentDescriptor.set((Object)descriptor);
                latch.countDown();
            }
        });
        latch.await(60L, TimeUnit.SECONDS);
        ProcessHandler processHandler = ((RunContentDescriptor)refRunContentDescriptor.get()).getProcessHandler();
        if (processHandler == null) {
            Assert.fail((String)"No process handler found");
        }
        CapturingProcessAdapter capturingProcessAdapter = new CapturingProcessAdapter();
        processHandler.addProcessListener((ProcessListener)capturingProcessAdapter);
        processHandler.waitFor(60000L);
        LOG.debug("Process terminated: " + processHandler.isProcessTerminated());
        ProcessOutput processOutput = capturingProcessAdapter.getOutput();
        LOG.debug("Exit code: " + processOutput.getExitCode());
        LOG.debug("Stdout: " + processOutput.getStdout());
        LOG.debug("Stderr: " + processOutput.getStderr());
        return executionEnvironment;
    }

    public static PsiElement findElementBySignature(@NotNull String signature, @NotNull String fileRelativePath, @NotNull Project project2) {
        if (signature == null) {
            PlatformTestUtil.$$$reportNull$$$0(54);
        }
        if (fileRelativePath == null) {
            PlatformTestUtil.$$$reportNull$$$0(55);
        }
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(56);
        }
        String filePath = project2.getBasePath() + File.separator + fileRelativePath;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null || !virtualFile.exists()) {
            throw new IllegalArgumentException(String.format("File '%s' doesn't exist", filePath));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        int offset = psiFile.getText().indexOf(signature);
        return psiFile.findElementAt(offset);
    }

    public static void useAppConfigDir(ThrowableRunnable<? extends Exception> task) throws Exception {
        Path configCopy;
        Path configDir = PathManager.getConfigDir();
        if (Files.exists(configDir, new LinkOption[0])) {
            configCopy = Files.move(configDir, Paths.get(configDir + "_bak", new String[0]), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        } else {
            FileUtil.delete((Path)configDir);
            configCopy = null;
        }
        try {
            task.run();
        }
        catch (Throwable throwable) {
            FileUtil.delete((Path)configDir);
            if (configCopy != null) {
                Files.move(configCopy, configDir, StandardCopyOption.ATOMIC_MOVE);
            }
            throw throwable;
        }
        FileUtil.delete((Path)configDir);
        if (configCopy != null) {
            Files.move(configCopy, configDir, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PlatformTestUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 5: 
            case 20: 
            case 21: 
            case 22: 
            case 44: 
            case 46: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExtensions";
                break;
            }
            case 7: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventQueue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToMeasure";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 36: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanup";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PlatformTestUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "lowercaseFirstLetter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaExe";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRtJarURL";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityPath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformTestDataPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createComparator";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebReferences";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceOfTypeWithAssertion";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectTestBaseDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "lowercaseFirstLetter";
                break;
            }
            case 2: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 48: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAllUppercaseName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "maskExtensions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "waitForCallback";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "waitForPromise";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "assertPromiseSucceeds";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "waitForFuture";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dispatchNextEventIfAny";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startPerformanceTest";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "forceCloseProjectWithoutSaving";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "saveProject";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "assertTiming";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "withEncoding";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "withStdErrSuppressed";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "assertSuccessful";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectWebReferences";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectCleanup";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "assertComparisonContractNotViolated";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setLongMeaninglessFileIncludeTemplateTemporarilyFor";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProjectTestBaseDir";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfiguration";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "executeConfiguration";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findElementBySignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

