/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightJavaModule
extends LightElement
implements PsiJavaModule {
    private final LightJavaModuleReferenceElement myRefElement;
    private final VirtualFile myRoot;
    private final NotNullLazyValue<List<PsiPackageAccessibilityStatement>> myExports;

    private LightJavaModule(@NotNull PsiManager manager, @NotNull VirtualFile root2, @NotNull String name) {
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(0);
        }
        if (root2 == null) {
            LightJavaModule.$$$reportNull$$$0(1);
        }
        if (name == null) {
            LightJavaModule.$$$reportNull$$$0(2);
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myExports = AtomicNotNullLazyValue.createValue(() -> this.findExports());
        this.myRoot = root2;
        this.myRefElement = new LightJavaModuleReferenceElement(manager, name);
    }

    @NotNull
    public VirtualFile getRootVirtualFile() {
        VirtualFile virtualFile2 = this.myRoot;
        if (virtualFile2 == null) {
            LightJavaModule.$$$reportNull$$$0(3);
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        List<PsiRequiresStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        Iterable iterable = this.myExports.getValue();
        if (iterable == null) {
            LightJavaModule.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    private List<PsiPackageAccessibilityStatement> findExports() {
        final ArrayList<PsiPackageAccessibilityStatement> exports = new ArrayList<PsiPackageAccessibilityStatement>();
        VfsUtilCore.visitChildrenRecursively(this.myRoot, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
            private final JavaDirectoryService service;
            {
                super(arg0);
                this.service = JavaDirectoryService.getInstance();
            }

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                String packageName;
                PsiPackage pkg;
                PsiDirectory directory;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2.isDirectory() && !LightJavaModule.this.myRoot.equals(file2) && (directory = LightJavaModule.this.getManager().findDirectory(file2)) != null && (pkg = this.service.getPackage(directory)) != null && !(packageName = pkg.getQualifiedName()).isEmpty() && !PsiUtil.isPackageEmpty(new PsiDirectory[]{directory}, packageName)) {
                    exports.add(new LightPackageAccessibilityStatement(LightJavaModule.this.getManager(), packageName));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/light/LightJavaModule$1", "visitFile"));
            }
        });
        return exports;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        List<PsiPackageAccessibilityStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        List<PsiUsesStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        List<PsiProvidesStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        LightJavaModuleReferenceElement lightJavaModuleReferenceElement = this.myRefElement;
        if (lightJavaModuleReferenceElement == null) {
            LightJavaModule.$$$reportNull$$$0(9);
        }
        return lightJavaModuleReferenceElement;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myRefElement.getReferenceText();
        if (string2 == null) {
            LightJavaModule.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            LightJavaModule.$$$reportNull$$$0(11);
        }
        throw new IncorrectOperationException("Cannot modify automatic module '" + this.getName() + "'");
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            LightJavaModule.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = ObjectUtils.notNull(this.myManager.findDirectory(this.myRoot), super.getNavigationElement());
        if (psiElement == null) {
            LightJavaModule.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    public boolean equals(Object obj) {
        return obj instanceof LightJavaModule && this.myRoot.equals(((LightJavaModule)obj).myRoot) && this.getManager() == ((LightJavaModule)obj).getManager();
    }

    public int hashCode() {
        return this.getName().hashCode() * 31 + this.getManager().hashCode();
    }

    @Override
    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static LightJavaModule getModule(@NotNull PsiManager manager, @NotNull VirtualFile root2) {
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(14);
        }
        if (root2 == null) {
            LightJavaModule.$$$reportNull$$$0(15);
        }
        LightJavaModule module2 = LightJavaModule.findModule(manager, root2);
        assert (module2 != null) : root2;
        LightJavaModule lightJavaModule = module2;
        if (lightJavaModule == null) {
            LightJavaModule.$$$reportNull$$$0(16);
        }
        return lightJavaModule;
    }

    @Nullable
    public static LightJavaModule findModule(@NotNull PsiManager manager, @NotNull VirtualFile root2) {
        PsiDirectory directory;
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(17);
        }
        if (root2 == null) {
            LightJavaModule.$$$reportNull$$$0(18);
        }
        if ((directory = manager.findDirectory(root2)) == null) {
            return null;
        }
        if (root2.isInLocalFileSystem()) {
            return (LightJavaModule)CachedValuesManager.getCachedValue(directory, () -> {
                PsiFile file2;
                VirtualFile manifest2 = root2.findFileByRelativePath("META-INF/MANIFEST.MF");
                if (manifest2 != null && (file2 = manager.findFile(manifest2)) != null) {
                    String name = LightJavaModule.claimedModuleName(manifest2);
                    LightJavaModule module2 = name != null ? new LightJavaModule(manager, root2, name) : null;
                    return CachedValueProvider.Result.create(module2, file2);
                }
                return CachedValueProvider.Result.create(null, PsiModificationTracker.MODIFICATION_COUNT);
            });
        }
        return (LightJavaModule)CachedValuesManager.getCachedValue(directory, () -> {
            LightJavaModule module2 = new LightJavaModule(manager, root2, LightJavaModule.moduleName(root2));
            return CachedValueProvider.Result.create(module2, directory);
        });
    }

    @NotNull
    public static String moduleName(@NotNull VirtualFile jarRoot) {
        String claimed;
        VirtualFile manifest2;
        if (jarRoot == null) {
            LightJavaModule.$$$reportNull$$$0(19);
        }
        if ((manifest2 = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF")) != null && (claimed = LightJavaModule.claimedModuleName(manifest2)) != null) {
            String string2 = claimed;
            if (string2 == null) {
                LightJavaModule.$$$reportNull$$$0(20);
            }
            return string2;
        }
        return LightJavaModule.moduleName(jarRoot.getNameWithoutExtension());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String claimedModuleName(@NotNull VirtualFile manifest2) {
        if (manifest2 == null) {
            LightJavaModule.$$$reportNull$$$0(21);
        }
        try (InputStream stream = manifest2.getInputStream();){
            String string2 = new Manifest(stream).getMainAttributes().getValue("Automatic-Module-Name");
            return string2;
        }
        catch (IOException e) {
            Logger.getInstance(LightJavaModule.class).warn(manifest2.getPath(), e);
            return null;
        }
    }

    @NotNull
    public static String moduleName(@NotNull String name) {
        Matcher m;
        if (name == null) {
            LightJavaModule.$$$reportNull$$$0(22);
        }
        if ((m = Patterns.VERSION.matcher(name)).find()) {
            name = name.substring(0, m.start());
        }
        name = Patterns.NON_NAME.matcher(name).replaceAll(".");
        name = Patterns.DOT_SEQUENCE.matcher(name).replaceAll(".");
        String string2 = name = StringUtil.trimLeading(StringUtil.trimTrailing(name, '.'), '.');
        if (string2 == null) {
            LightJavaModule.$$$reportNull$$$0(23);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightJavaModule";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarRoot";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightJavaModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootVirtualFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequires";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpens";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvides";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 19: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "moduleName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "claimedModuleName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Patterns {
        private static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9]");
        private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");

        private Patterns() {
        }
    }

    private static class LightPackageAccessibilityStatement
    extends LightElement
    implements PsiPackageAccessibilityStatement {
        private final String myPackageName;

        LightPackageAccessibilityStatement(@NotNull PsiManager manager, @NotNull String packageName) {
            if (manager == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(1);
            }
            super(manager, JavaLanguage.INSTANCE);
            this.myPackageName = packageName;
        }

        @Override
        @NotNull
        public PsiPackageAccessibilityStatement.Role getRole() {
            PsiPackageAccessibilityStatement.Role role = PsiPackageAccessibilityStatement.Role.EXPORTS;
            if (role == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(2);
            }
            return role;
        }

        @Override
        @Nullable
        public PsiJavaCodeReferenceElement getPackageReference() {
            return null;
        }

        @Override
        @Nullable
        public String getPackageName() {
            return this.myPackageName;
        }

        @Override
        @NotNull
        public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
            List<PsiJavaModuleReferenceElement> list2 = Collections.emptyList();
            if (list2 == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        @NotNull
        public List<String> getModuleNames() {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @Override
        public String toString() {
            return "PsiPackageAccessibilityStatement";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRole";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleReferences";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LightJavaModuleReferenceElement
    extends LightElement
    implements PsiJavaModuleReferenceElement {
        private final String myText;

        private LightJavaModuleReferenceElement(@NotNull PsiManager manager, @NotNull String text2) {
            if (manager == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(1);
            }
            super(manager, JavaLanguage.INSTANCE);
            this.myText = text2;
        }

        @Override
        @NotNull
        public String getReferenceText() {
            String string2 = this.myText;
            if (string2 == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        public PsiJavaModuleReference getReference() {
            return null;
        }

        @Override
        public String toString() {
            return "PsiJavaModuleReference";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

