/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.ngram.profiles;

import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.model.LanguageISO;
import com.intellij.grazie.detector.ngram.NgramDetector;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfile;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfileImpl;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\n0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\nJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grazie/detector/ngram/profiles/LanguageProfileReader;", "", "()V", "FREQ_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "NAME_PATTERN", "PROFILES_DIR", "", "getResource", "Ljava/io/InputStream;", "language", "Lcom/intellij/grazie/detector/model/Language;", "read", "Lcom/intellij/grazie/detector/ngram/profiles/LanguageProfile;", "locale", "file", "Ljava/io/File;", "input", "readAllBuiltIn", "", "language-detector"})
public final class LanguageProfileReader {
    private static final Pattern FREQ_PATTERN;
    private static final Pattern NAME_PATTERN;
    private static final String PROFILES_DIR = "languages";
    public static final LanguageProfileReader INSTANCE;

    private final InputStream getResource(Language language) {
        String string = language.getIso().name();
        StringBuilder stringBuilder = new StringBuilder().append("languages/");
        ClassLoader classLoader = this.getClass().getClassLoader();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        return classLoader.getResourceAsStream(stringBuilder.append(string4).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final LanguageProfile read(@NotNull File file) {
        LanguageProfile languageProfile;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean bl = file.exists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "File does not exist";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Closeable closeable = new FileInputStream(file);
        bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl5 = false;
            languageProfile = INSTANCE.read(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return languageProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final LanguageProfile read(@NotNull Language locale) {
        LanguageProfile languageProfile;
        Intrinsics.checkParameterIsNotNull((Object)((Object)locale), (String)"locale");
        InputStream inputStream = this.getResource(locale);
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        Closeable closeable = inputStream;
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            languageProfile = INSTANCE.read(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return languageProfile;
    }

    @NotNull
    public final List<LanguageProfile> readAllBuiltIn() {
        ArrayList<LanguageProfile> loaded = new ArrayList<LanguageProfile>();
        for (Language lang : NgramDetector.Companion.getSupported()) {
            loaded.add(this.read(lang));
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final LanguageProfile read(@NotNull InputStream input) {
        String string;
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Closeable closeable = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        int n = 8192;
        bl = false;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        n = 0;
        Throwable throwable = null;
        try {
            Object it2 = (BufferedReader)closeable;
            boolean bl2 = false;
            it2 = SequencesKt.joinToString$default((Sequence)TextStreamsKt.lineSequence((BufferedReader)it2), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object profile = it2;
        Matcher name = NAME_PATTERN.matcher((CharSequence)profile);
        n = name.find() ? 1 : 0;
        boolean bl3 = false;
        boolean it2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String it2 = "No locale specified in file";
            throw (Throwable)new IllegalArgumentException(it2.toString());
        }
        try {
            String string2 = name.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name.group(1)");
            object2 = string2;
            object = Language.Companion;
            it2 = false;
            String string3 = object2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
            string = string4;
            object2 = ((Language.Companion)object).getByIsoCode6391(LanguageISO.valueOf(string));
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Profile file name logic was changed in v0.5, please update your custom profiles!", e);
        }
        Object locale = object2;
        HashMap ngrams = new HashMap();
        Matcher freq = FREQ_PATTERN.matcher((CharSequence)profile);
        if (freq.find()) {
            String $this$filterTo$iv$iv;
            String string5 = freq.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"freq.group(1)");
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string5, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo3 = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                String it3 = (String)element$iv$iv;
                boolean bl5 = false;
                CharSequence charSequence = it3;
                boolean bl6 = false;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List entries = (List)destination$iv$iv;
            for (String entry : entries) {
                Object object3;
                void $this$getOrPut$iv;
                void key;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = StringsKt.split$default((CharSequence)entry, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$filter22 = false;
                Iterable it3 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    String it4 = (String)element$iv$iv;
                    boolean bl7 = false;
                    CharSequence charSequence = it4;
                    boolean bl8 = false;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List $i$f$filterTo3 = (List)destination$iv$iv2;
                $this$filter$iv2 = $i$f$filterTo3;
                $i$f$filter22 = false;
                $this$filterTo$iv$iv = (String)$this$filter$iv2.get(0);
                $this$filter$iv2 = $i$f$filterTo3;
                $i$f$filter22 = false;
                String value = (String)$this$filter$iv2.get(1);
                $this$filter$iv2 = key;
                $i$f$filter22 = false;
                Iterable iterable2 = $this$filter$iv2;
                if (iterable2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String label = StringsKt.trim((String)((Object)StringsKt.trim((CharSequence)((CharSequence)((Object)iterable2)))).toString(), (char[])new char[]{'\"'});
                Map $i$f$filter22 = ngrams;
                Integer key$iv = label.length();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl9 = false;
                    HashMap answer$iv = new HashMap();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                Map ngramMap = (Map)object3;
                Integer n2 = (Integer)ngramMap.get(label);
                String string6 = value;
                int n3 = n2 != null ? n2 : 0;
                string = label;
                object = ngramMap;
                boolean bl10 = false;
                int n4 = Integer.parseInt(string6);
                object.put(string, n3 + n4);
            }
        }
        return new LanguageProfileImpl((Language)((Object)locale), ngrams);
    }

    private LanguageProfileReader() {
    }

    static {
        LanguageProfileReader languageProfileReader;
        INSTANCE = languageProfileReader = new LanguageProfileReader();
        FREQ_PATTERN = Pattern.compile("\"freq\" ?: ?\\{(.+?)}");
        NAME_PATTERN = Pattern.compile("\"name\" ?: ?\"(.+?)\"");
    }
}

