/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.byteCodeViewer.ByteCodeViewerComponent;
import com.intellij.byteCodeViewer.ByteCodeViewerManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShowByteCodeAction
extends AnAction {
    ShowByteCodeAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        PsiElement psiElement;
        if (e == null) {
            ShowByteCodeAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(false);
        e.getPresentation().setIcon(AllIcons.Actions.Preview);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null && (psiElement = ShowByteCodeAction.getPsiElement(e.getDataContext(), project, (Editor)e.getData(CommonDataKeys.EDITOR))) != null && psiElement.getContainingFile() instanceof PsiClassOwner) {
            e.getPresentation().setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowByteCodeAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        final Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        final PsiElement psiElement = ShowByteCodeAction.getPsiElement(dataContext, project, editor);
        if (psiElement == null) {
            return;
        }
        if (ByteCodeViewerManager.getContainingClass(psiElement) == null) {
            Messages.showWarningDialog((Project)project, (String)"The selection should contain a class", (String)"Unable to Find Class to Show Bytecode");
            return;
        }
        final String psiElementTitle = ByteCodeViewerManager.getInstance(project).getTitle(psiElement);
        final VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        if (virtualFile == null) {
            return;
        }
        final RelativePoint bestPopupLocation = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        final SmartPsiElementPointer element = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(psiElement);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Looking for Bytecode..."){
            private String myByteCode;
            private String myErrorMessage;
            private String myErrorTitle;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile) && ShowByteCodeAction.isMarkedForCompilation(project, virtualFile)) {
                    this.myErrorTitle = "Class File May Be Out-of-Date";
                }
                this.myByteCode = (String)ReadAction.compute(() -> ByteCodeViewerManager.getByteCode(psiElement));
            }

            public void onSuccess() {
                if (project.isDisposed()) {
                    return;
                }
                PsiElement targetElement = element.getElement();
                if (targetElement == null) {
                    return;
                }
                ByteCodeViewerManager codeViewerManager = ByteCodeViewerManager.getInstance(project);
                if (codeViewerManager.hasActiveDockedDocWindow()) {
                    codeViewerManager.doUpdateComponent(targetElement, this.myByteCode);
                } else {
                    if (this.myByteCode == null) {
                        Messages.showErrorDialog((Project)project, (String)("Unable to parse class file for '" + psiElementTitle + "'."), (String)"Bytecode not Found");
                        return;
                    }
                    ByteCodeViewerComponent component = new ByteCodeViewerComponent(project);
                    component.setText(this.myByteCode, targetElement);
                    Processor pinCallback = popup -> {
                        codeViewerManager.recreateToolWindow(targetElement, targetElement);
                        popup.cancel();
                        return false;
                    };
                    if (this.myErrorTitle != null) {
                        JLabel errorLabel = new JLabel(this.myErrorTitle);
                        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
                        if (color != null) {
                            errorLabel.setBorder((Border)new JBEmptyBorder(2));
                            errorLabel.setBackground(color);
                            errorLabel.setOpaque(true);
                        }
                        component.add((Component)errorLabel, "North");
                    }
                    JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, component.getEditorComponent()).setProject(project).setDimensionServiceKey(project, ShowByteCodeAction.class.getName(), false).setResizable(true).setMovable(true).setRequestFocus(LookupManager.getActiveLookup((Editor)editor) == null).setTitle(psiElementTitle + " Bytecode").setCouldPin(pinCallback).createPopup();
                    Disposer.register((Disposable)popup2, (Disposable)component);
                    if (editor != null) {
                        popup2.showInBestPositionFor(editor);
                    } else {
                        popup2.show(bestPopupLocation);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/byteCodeViewer/ShowByteCodeAction$1", "run"));
            }
        });
    }

    private static boolean isMarkedForCompilation(Project project, VirtualFile virtualFile) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        return !compilerManager.isUpToDate(compilerManager.createFilesCompileScope(new VirtualFile[]{virtualFile}));
    }

    @Nullable
    private static PsiElement getPsiElement(DataContext dataContext, Project project, @Nullable Editor editor) {
        PsiElement psiElement = null;
        if (editor == null) {
            psiElement = (PsiElement)dataContext.getData(CommonDataKeys.PSI_ELEMENT);
        } else {
            PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file);
            if (injectedEditor != null) {
                psiElement = ShowByteCodeAction.findElementInFile(PsiUtilBase.getPsiFileInEditor((Editor)injectedEditor, (Project)project), injectedEditor);
            }
            if (file != null && psiElement == null) {
                psiElement = ShowByteCodeAction.findElementInFile(file, editor);
            }
        }
        return psiElement;
    }

    private static PsiElement findElementInFile(@Nullable PsiFile psiFile, @NotNull Editor editor) {
        if (editor == null) {
            ShowByteCodeAction.$$$reportNull$$$0(2);
        }
        return psiFile != null ? psiFile.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/byteCodeViewer/ShowByteCodeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementInFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

