/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.JavaVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.Environment;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionContext;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil$getGradleJdkReference$;
import org.jetbrains.plugins.gradle.util.GradleProperties;
import org.jetbrains.plugins.gradle.util.GradlePropertiesUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a*\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0001\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0003*\u00020\u000fH\u0002\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0003*\u00020\u000fH\u0002\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0003*\u00020\u000fH\u0002\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0003*\u00020\u000fH\u0002\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0003*\u00020\u000fH\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0003*\u00020\u000fH\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0017*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0017*\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c*\u00020\u000fH\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"JAVA_HOME", "", "findOrAddJdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "homePath", "suggestGradleJvm", "project", "Lcom/intellij/openapi/project/Project;", "projectSdk", "externalProjectPath", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "updateGradleJvm", "", "findOrAddGradleJdk", "Lorg/jetbrains/plugins/gradle/util/GradleJvmResolutionContext;", "getAndAddExternalJdkReference", "getGradleJdkReference", "getMostRecentJdkReference", "getOrAddEnvJavaHomeJdkReference", "getOrAddGradleJavaHomeJdkReference", "getProjectJdkReference", "isSupported", "", "versionString", "isValidAndSupported", "sdk", "resolvePossibleGradleJvms", "", "resolveReference", "intellij.gradle.common"})
@JvmName(name="GradleJvmResolutionUtil")
public final class GradleJvmResolutionUtil {
    @NotNull
    public static final String JAVA_HOME = "JAVA_HOME";

    @Nullable
    public static final String suggestGradleJvm(@NotNull Project project, @Nullable Sdk projectSdk2, @NotNull String externalProjectPath, @NotNull GradleVersion gradleVersion) {
        Sdk sdk;
        Sdk sdk2;
        Sdk sdk3;
        Sdk sdk4;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)externalProjectPath, (String)"externalProjectPath");
        Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
        GradleJvmResolutionContext gradleJvmResolutionContext = new GradleJvmResolutionContext(project, projectSdk2, externalProjectPath, gradleVersion);
        boolean bl = false;
        boolean bl2 = false;
        GradleJvmResolutionContext $this$with = gradleJvmResolutionContext;
        boolean bl3 = false;
        Sdk sdk5 = GradleJvmResolutionUtil.getOrAddGradleJavaHomeJdkReference($this$with);
        if (sdk5 == null) {
            sdk5 = sdk4 = GradleJvmResolutionUtil.getOrAddEnvJavaHomeJdkReference($this$with);
        }
        if (sdk5 == null) {
            sdk4 = sdk3 = GradleJvmResolutionUtil.getGradleJdkReference($this$with);
        }
        if (sdk4 == null) {
            sdk3 = sdk2 = GradleJvmResolutionUtil.getProjectJdkReference($this$with);
        }
        if (sdk3 == null) {
            sdk2 = sdk = GradleJvmResolutionUtil.getMostRecentJdkReference($this$with);
        }
        if (sdk2 == null) {
            sdk = GradleJvmResolutionUtil.getAndAddExternalJdkReference($this$with);
        }
        if (sdk == null) {
            return null;
        }
        Sdk suggestedGradleJvm = sdk;
        return GradleJvmResolutionUtil.resolveReference($this$with, suggestedGradleJvm);
    }

    public static final void updateGradleJvm(@NotNull Project project, @NotNull String externalProjectPath) {
        ProjectRootManager projectRootManager;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)externalProjectPath, (String)"externalProjectPath");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings settings = gradleSettings;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings.getLinkedProjectSettings(externalProjectPath);
        if (gradleProjectSettings == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleProjectSettings), (String)"settings.getLinkedProjec\u2026nalProjectPath) ?: return");
        GradleProjectSettings projectSettings = gradleProjectSettings;
        String string = projectSettings.getGradleJvm();
        if (string == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectSettings.gradleJvm ?: return");
        String gradleJvm = string;
        ProjectRootManager projectRootManager2 = projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager2, (String)"projectRootManager");
        Sdk sdk = projectRootManager2.getProjectSdk();
        if (sdk == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sdk, (String)"projectRootManager.projectSdk ?: return");
        Sdk projectSdk2 = sdk;
        GradleVersion gradleVersion = projectSettings.resolveGradleVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"projectSettings.resolveGradleVersion()");
        GradleVersion gradleVersion2 = gradleVersion;
        GradleJvmResolutionContext gradleJvmResolutionContext = new GradleJvmResolutionContext(project, projectSdk2, externalProjectPath, gradleVersion2);
        boolean bl = false;
        boolean bl2 = false;
        GradleJvmResolutionContext $this$with = gradleJvmResolutionContext;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)projectSdk2.getName(), (Object)gradleJvm) ^ true) {
            return;
        }
        if (!GradleJvmResolutionUtil.isValidAndSupported($this$with, projectSdk2)) {
            return;
        }
        projectSettings.setGradleJvm("#USE_PROJECT_JDK");
    }

    private static final String resolveReference(@NotNull GradleJvmResolutionContext $this$resolveReference, Sdk sdk) {
        String string;
        Sdk sdk2 = sdk;
        if (Intrinsics.areEqual((Object)sdk2, (Object)$this$resolveReference.getProjectSdk())) {
            string = "#USE_PROJECT_JDK";
        } else {
            String string2 = sdk.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sdk.name");
        }
        return string;
    }

    private static final boolean isValidAndSupported(@NotNull GradleJvmResolutionContext $this$isValidAndSupported, String homePath) {
        if (!ExternalSystemJdkUtil.isValidJdk((String)homePath)) {
            return false;
        }
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkType, (String)"ExternalSystemJdkUtil.getJavaSdkType()");
        SdkType javaSdkType = sdkType;
        String string = javaSdkType.getVersionString(homePath);
        if (string == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaSdkType.getVersionSt\u2026homePath) ?: return false");
        String versionString = string;
        return GradleJvmResolutionUtil.isSupported($this$isValidAndSupported, versionString);
    }

    private static final boolean isValidAndSupported(@NotNull GradleJvmResolutionContext $this$isValidAndSupported, Sdk sdk) {
        if (!ExternalSystemJdkUtil.isValidJdk((Sdk)sdk)) {
            return false;
        }
        String string = sdk.getVersionString();
        if (string == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdk.versionString ?: return false");
        String versionString = string;
        return GradleJvmResolutionUtil.isSupported($this$isValidAndSupported, versionString);
    }

    private static final boolean isSupported(@NotNull GradleJvmResolutionContext $this$isSupported, String versionString) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        JavaVersion javaVersion = JavaVersion.tryParse((String)versionString);
        if (javaVersion == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)javaVersion, (String)"JavaVersion.tryParse(ver\u2026onString) ?: return false");
        JavaVersion version = javaVersion;
        boolean bl = $this$isSupported.getGradleVersion().compareTo(GradleVersion.version((String)"6.0")) >= 0 ? 8 <= (n6 = version.feature) && 13 >= n6 : ($this$isSupported.getGradleVersion().compareTo(GradleVersion.version((String)"5.4.1")) >= 0 ? 8 <= (n5 = version.feature) && 12 >= n5 : ($this$isSupported.getGradleVersion().compareTo(GradleVersion.version((String)"5.0")) >= 0 ? 8 <= (n4 = version.feature) && 11 >= n4 : ($this$isSupported.getGradleVersion().compareTo(GradleVersion.version((String)"4.1")) >= 0 ? 7 <= (n3 = version.feature) && 9 >= n3 : ($this$isSupported.getGradleVersion().compareTo(GradleVersion.version((String)"4.0")) >= 0 ? 7 <= (n2 = version.feature) && 8 >= n2 : 6 <= (n = version.feature) && 8 >= n))));
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Sdk> resolvePossibleGradleJvms(@NotNull GradleJvmResolutionContext $this$resolvePossibleGradleJvms) {
        void $this$filterTo$iv$iv;
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkType, (String)"ExternalSystemJdkUtil.getJavaSdkType()");
        SdkType javaSdkType = sdkType;
        List list = projectJdkTable.getSdksOfType((SdkTypeId)javaSdkType);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"projectJdkTable.getSdksOfType(javaSdkType)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sdk it = (Sdk)element$iv$iv;
            boolean bl = false;
            Sdk sdk = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)sdk, (String)"it");
            if (!GradleJvmResolutionUtil.isValidAndSupported($this$resolvePossibleGradleJvms, sdk)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Sdk findOrAddJdk(String homePath) {
        Object v3;
        String canonicalHomePath;
        block2: {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
            Intrinsics.checkExpressionValueIsNotNull((Object)sdkType, (String)"ExternalSystemJdkUtil.getJavaSdkType()");
            SdkType javaSdkType = sdkType;
            canonicalHomePath = FileUtil.toCanonicalPath((String)homePath);
            List list = projectJdkTable.getSdksOfType((SdkTypeId)javaSdkType);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"projectJdkTable.getSdksOfType(javaSdkType)");
            Iterable iterable = list;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Sdk it = (Sdk)t;
                boolean bl3 = false;
                Sdk sdk = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)sdk, (String)"it");
                if (!Intrinsics.areEqual((Object)FileUtil.toCanonicalPath((String)sdk.getHomePath()), (Object)canonicalHomePath)) continue;
                v3 = t;
                break block2;
            }
            v3 = null;
        }
        Sdk foundJdk = v3;
        if (foundJdk != null) {
            return foundJdk;
        }
        return ExternalSystemJdkUtil.addJdk((String)canonicalHomePath);
    }

    private static final Sdk findOrAddGradleJdk(@NotNull GradleJvmResolutionContext $this$findOrAddGradleJdk, String homePath) {
        Object v0;
        String canonicalHomePath;
        block3: {
            canonicalHomePath = FileUtil.toCanonicalPath((String)homePath);
            Iterable iterable = $this$findOrAddGradleJdk.getPossibleGradleJvms();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Sdk it = (Sdk)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)FileUtil.toCanonicalPath((String)it.getHomePath()), (Object)canonicalHomePath)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Sdk foundJdk = v0;
        if (foundJdk != null) {
            return foundJdk;
        }
        String string = canonicalHomePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"canonicalHomePath");
        if (!GradleJvmResolutionUtil.isValidAndSupported($this$findOrAddGradleJdk, string)) {
            return null;
        }
        return ExternalSystemJdkUtil.addJdk((String)canonicalHomePath);
    }

    private static final Sdk getGradleJdkReference(@NotNull GradleJvmResolutionContext $this$getGradleJdkReference) {
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)$this$getGradleJdkReference.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractExternalSystemSettings, (String)"ExternalSystemApiUtil.ge\u2026radleConstants.SYSTEM_ID)");
        AbstractExternalSystemSettings settings = abstractExternalSystemSettings;
        Collection collection = settings.getLinkedProjectsSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"settings.getLinkedProjectsSettings()");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)collection);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getGradleJdkReference$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return (Sdk)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)sequence, (Function1)((Function1)new Function1<GradleProjectSettings, Sdk>($this$getGradleJdkReference){
            final /* synthetic */ GradleJvmResolutionContext $this_getGradleJdkReference;

            @Nullable
            public final Sdk invoke(@NotNull GradleProjectSettings ps) {
                Object v0;
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)ps), (String)"ps");
                    Iterable iterable = this.$this_getGradleJdkReference.getPossibleGradleJvms();
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (T t : iterable2) {
                        Sdk it = (Sdk)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)ps.getGradleJvm())) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
            {
                this.$this_getGradleJdkReference = gradleJvmResolutionContext;
                super(1);
            }
        })));
    }

    private static final Sdk getOrAddGradleJavaHomeJdkReference(@NotNull GradleJvmResolutionContext $this$getOrAddGradleJavaHomeJdkReference) {
        GradleProperties properties = GradlePropertiesUtil.getGradleProperties($this$getOrAddGradleJavaHomeJdkReference.getExternalProjectPath());
        String string = properties.getJavaHome();
        if (string == null) {
            return null;
        }
        String javaHome = string;
        return GradleJvmResolutionUtil.findOrAddJdk(javaHome);
    }

    private static final Sdk getOrAddEnvJavaHomeJdkReference(@NotNull GradleJvmResolutionContext $this$getOrAddEnvJavaHomeJdkReference) {
        String string = Environment.Companion.getEnvVariable(JAVA_HOME);
        if (string == null) {
            return null;
        }
        String javaHome = string;
        return GradleJvmResolutionUtil.findOrAddGradleJdk($this$getOrAddEnvJavaHomeJdkReference, javaHome);
    }

    private static final Sdk getProjectJdkReference(@NotNull GradleJvmResolutionContext $this$getProjectJdkReference) {
        Sdk sdk = $this$getProjectJdkReference.getProjectSdk();
        if (sdk == null) {
            return null;
        }
        Sdk projectSdk2 = sdk;
        Sdk sdk2 = ExternalSystemJdkUtil.resolveDependentJdk((Sdk)projectSdk2);
        Intrinsics.checkExpressionValueIsNotNull((Object)sdk2, (String)"ExternalSystemJdkUtil.re\u2026eDependentJdk(projectSdk)");
        Sdk resolvedProjectSdk = sdk2;
        if (!GradleJvmResolutionUtil.isValidAndSupported($this$getProjectJdkReference, resolvedProjectSdk)) {
            return null;
        }
        return resolvedProjectSdk;
    }

    private static final Sdk getMostRecentJdkReference(@NotNull GradleJvmResolutionContext $this$getMostRecentJdkReference) {
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkType, (String)"ExternalSystemJdkUtil.getJavaSdkType()");
        SdkType javaSdkType = sdkType;
        Iterable iterable = $this$getMostRecentJdkReference.getPossibleGradleJvms();
        Comparator comparator = javaSdkType.versionComparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"javaSdkType.versionComparator()");
        return (Sdk)CollectionsKt.maxWith((Iterable)iterable, (Comparator)comparator);
    }

    /*
     * WARNING - void declaration
     */
    private static final Sdk getAndAddExternalJdkReference(@NotNull GradleJvmResolutionContext $this$getAndAddExternalJdkReference) {
        Sdk sdk;
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkType, (String)"ExternalSystemJdkUtil.getJavaSdkType()");
        SdkType javaSdkType = sdkType;
        Comparator comparator = javaSdkType.versionStringComparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"javaSdkType.versionStringComparator()");
        Comparator versionComparator = comparator;
        Collection collection = ExternalSystemJdkUtil.suggestJdkHomePaths();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ExternalSystemJdkUtil.suggestJdkHomePaths()");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            if (!GradleJvmResolutionUtil.isValidAndSupported($this$getAndAddExternalJdkReference, string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)javaSdkType.getVersionString(it));
            collection2.add(pair);
        }
        Pair pair = (Pair)CollectionsKt.maxWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator<Pair<? extends String, ? extends String>>(versionComparator){
            final /* synthetic */ Comparator $versionComparator;

            public final int compare(Pair<String, String> $dstr$_u24__u24$v1, Pair<String, String> $dstr$_u24__u24$v2) {
                String v1 = (String)$dstr$_u24__u24$v1.component2();
                String v2 = (String)$dstr$_u24__u24$v2.component2();
                return this.$versionComparator.compare(v1, v2);
            }
            {
                this.$versionComparator = comparator;
            }
        });
        if (pair != null) {
            String homePath;
            Pair pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair $dstr$homePath$_u24__u24 = pair2;
            boolean bl3 = false;
            String string = homePath = (String)$dstr$homePath$_u24__u24.component1();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"homePath");
            sdk = GradleJvmResolutionUtil.findOrAddGradleJdk($this$getAndAddExternalJdkReference, string);
        } else {
            sdk = null;
        }
        return sdk;
    }

    public static final /* synthetic */ List access$resolvePossibleGradleJvms(GradleJvmResolutionContext $this$access_u24resolvePossibleGradleJvms) {
        return GradleJvmResolutionUtil.resolvePossibleGradleJvms($this$access_u24resolvePossibleGradleJvms);
    }
}

