/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="gradleExecuteTaskHistory", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExecuteGradleTaskHistoryService
implements PersistentStateComponent<String[]> {
    private static final int MAX_HISTORY_LENGTH = 20;
    private final LinkedList<String> myHistory = new LinkedList();
    private String myWorkDirectory = "";
    private String myCanceledCommand;

    public static ExecuteGradleTaskHistoryService getInstance(@NotNull Project project) {
        if (project == null) {
            ExecuteGradleTaskHistoryService.$$$reportNull$$$0(0);
        }
        return (ExecuteGradleTaskHistoryService)ServiceManager.getService((Project)project, ExecuteGradleTaskHistoryService.class);
    }

    @Nullable
    public String getCanceledCommand() {
        return this.myCanceledCommand;
    }

    public void setCanceledCommand(@Nullable String canceledCommand) {
        this.myCanceledCommand = canceledCommand;
    }

    public void addCommand(@NotNull String command, @NotNull String projectPath) {
        if (command == null) {
            ExecuteGradleTaskHistoryService.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            ExecuteGradleTaskHistoryService.$$$reportNull$$$0(2);
        }
        this.myWorkDirectory = projectPath.trim();
        if ((command = command.trim()).length() == 0) {
            return;
        }
        this.myHistory.remove(command);
        this.myHistory.addFirst(command);
        while (this.myHistory.size() > 20) {
            this.myHistory.removeLast();
        }
    }

    public List<String> getHistory() {
        return new ArrayList<String>(this.myHistory);
    }

    @NotNull
    public String getWorkDirectory() {
        String string = this.myWorkDirectory;
        if (string == null) {
            ExecuteGradleTaskHistoryService.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String @Nullable [] getState() {
        String[] res = new String[this.myHistory.size() + 1];
        res[0] = this.myWorkDirectory;
        int i2 = 1;
        for (String goal : this.myHistory) {
            res[i2++] = goal;
        }
        return res;
    }

    public void loadState(String @NotNull [] state) {
        if (state == null) {
            ExecuteGradleTaskHistoryService.$$$reportNull$$$0(4);
        }
        if (state.length == 0) {
            this.myWorkDirectory = "";
            this.myHistory.clear();
        } else {
            this.myWorkDirectory = state[0];
            this.myHistory.addAll(Arrays.asList(state).subList(1, state.length));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/task/ExecuteGradleTaskHistoryService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/task/ExecuteGradleTaskHistoryService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCommand";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

